#
# TABLE STRUCTURE FOR: add_amt
#

DROP TABLE IF EXISTS `add_amt`;

CREATE TABLE `add_amt` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `amt` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `utr` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `note` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (1, 'ADMIN', '100', '124346', '', '1', '2021-07-03 17:19:46');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (2, 'ADMIN', '10', '6434', '', '2', '2021-07-03 17:50:08');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (3, 'T478838', '10', '118513598442', '', '1', '2021-07-04 13:54:52');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (4, 'T686636', '10', '652389566', '', '2', '2021-07-04 14:04:59');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (5, '1234567891', '100', '253388', '', '1', '2021-07-05 12:44:51');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (6, '6207475162', '360', '5467978', '', '1', '2021-07-05 17:11:22');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (7, 'ADMIN', '1000', '35468', '', '1', '2021-07-05 19:50:29');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (8, 'T974372', '37', '118799342554', '', '1', '2021-07-06 09:18:24');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (9, 'T201269', '100', '119013559902', '', '1', '2021-07-09 13:53:36');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (10, '9798067920', '375', '9798067920', '', '2', '2021-07-12 10:27:52');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (11, '9798067920', '375', '119312956163', '', '1', '2021-07-12 12:09:06');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (12, '9798067920', '45', '119414435822', '', '1', '2021-07-13 14:44:28');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (13, '9798067920', '45', '119414435822', '', '2', '2021-07-13 14:50:08');


#
# TABLE STRUCTURE FOR: applied_coupon
#

DROP TABLE IF EXISTS `applied_coupon`;

CREATE TABLE `applied_coupon` (
  `id` int NOT NULL AUTO_INCREMENT,
  `coupon_id` varchar(999) NOT NULL,
  `user_id` varchar(999) NOT NULL,
  `payment_id` varchar(999) NOT NULL,
  `addon` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `applied_coupon` (`id`, `coupon_id`, `user_id`, `payment_id`, `addon`) VALUES (1, '', '347', '1748590064', '2025-05-30 12:57:44');
INSERT INTO `applied_coupon` (`id`, `coupon_id`, `user_id`, `payment_id`, `addon`) VALUES (2, '', '324', '1748702009', '2025-05-31 20:03:29');
INSERT INTO `applied_coupon` (`id`, `coupon_id`, `user_id`, `payment_id`, `addon`) VALUES (3, '', '324', '1748702731', '2025-05-31 20:15:31');


#
# TABLE STRUCTURE FOR: applied_delivery_address
#

DROP TABLE IF EXISTS `applied_delivery_address`;

CREATE TABLE `applied_delivery_address` (
  `id` int NOT NULL AUTO_INCREMENT,
  `delivery_address_id` int NOT NULL,
  `user_id` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(99) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pin_code` int NOT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (1, 74, '347', 'Vishal Kumar ', '9939864956', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill-chakwaja , p.s- chakwaja nagwan, Vaishali Bihar , 844120', '2025-05-30 12:57:44', '2025-05-30 12:57:44', 1, 1748590064);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (2, 75, '324', 'BIKASH KUMAR DAS', '9903382291', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill-lautan', '2025-05-31 20:03:29', '2025-05-31 20:03:29', 1, 1748702009);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (3, 75, '324', 'BIKASH KUMAR DAS', '9903382291', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill-lautan', '2025-05-31 20:15:31', '2025-05-31 20:15:31', 1, 1748702731);


#
# TABLE STRUCTURE FOR: applied_shipping_cost
#

DROP TABLE IF EXISTS `applied_shipping_cost`;

CREATE TABLE `applied_shipping_cost` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shipping_cost` float NOT NULL,
  `payment_id` int NOT NULL,
  `user_id` int NOT NULL,
  `addon` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: banner
#

DROP TABLE IF EXISTS `banner`;

CREATE TABLE `banner` (
  `id` int NOT NULL AUTO_INCREMENT,
  `photo` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `banner` (`id`, `photo`, `status`) VALUES (1, 'IMG-20210629-WA0009.jpg', 0);


#
# TABLE STRUCTURE FOR: closing
#

DROP TABLE IF EXISTS `closing`;

CREATE TABLE `closing` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `total` float DEFAULT NULL,
  `amt` float DEFAULT NULL,
  `tds` float DEFAULT NULL,
  `pr` int DEFAULT NULL,
  `admin` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `note` varchar(999) DEFAULT NULL,
  `txnid` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: complant
#

DROP TABLE IF EXISTS `complant`;

CREATE TABLE `complant` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `q1` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qdate` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `a1` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `adate` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `admins` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: coupon_payment
#

DROP TABLE IF EXISTS `coupon_payment`;

CREATE TABLE `coupon_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(99) NOT NULL,
  `pmode` varchar(99) NOT NULL,
  `utr` varchar(99) NOT NULL,
  `date` varchar(99) NOT NULL,
  `des` varchar(99) NOT NULL,
  `amount` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: customer_invoice
#

DROP TABLE IF EXISTS `customer_invoice`;

CREATE TABLE `customer_invoice` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `pv` float NOT NULL,
  `address` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`, `address`) VALUES (3, '1', '9876543210', '81629822', '1', '247', '', '2500', '1', '2500', '2', '1', '2025-07-24 07:11:29', '1', '');
INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`, `address`) VALUES (4, '1', '9876543210', '42655434', '2', '307', '', '2500', '3', '7500', '4', '1', '2025-07-24 07:12:10', '1', '');
INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`, `address`) VALUES (5, '1', '9876543210', '67096209', '1', '247', '', '2500', '2', '5000', '2', '1', '2025-07-24 07:34:33', '1', '');
INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`, `address`) VALUES (6, '1', '9876543210', '23015139', '18', '176', '', '16', '100', '1600', '27', '1', '2025-08-09 18:29:34', '5', '');


#
# TABLE STRUCTURE FOR: customer_invoice1
#

DROP TABLE IF EXISTS `customer_invoice1`;

CREATE TABLE `customer_invoice1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: customer_invoice_list
#

DROP TABLE IF EXISTS `customer_invoice_list`;

CREATE TABLE `customer_invoice_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `tamt1` varchar(999) NOT NULL,
  `dis` varchar(999) NOT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (3, '1', '9876543210', '81629822', '2500', '0', '2500', '2025-07-24 07:11:29', '1');
INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (4, '1', '9876543210', '42655434', '7500', '100', '7400', '2025-07-24 07:12:10', '1');
INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (5, '1', '9876543210', '67096209', '5000', '0', '5000', '2025-07-24 07:34:33', '1');
INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (6, '1', '9876543210', '23015139', '1600', '0', '1600', '2025-08-09 18:29:34', '1');


#
# TABLE STRUCTURE FOR: customer_invoice_list1
#

DROP TABLE IF EXISTS `customer_invoice_list1`;

CREATE TABLE `customer_invoice_list1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `tamt1` varchar(999) NOT NULL,
  `dis` varchar(999) NOT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: customer_payment
#

DROP TABLE IF EXISTS `customer_payment`;

CREATE TABLE `customer_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `payid` varchar(999) DEFAULT NULL,
  `pre_amt` varchar(999) DEFAULT NULL,
  `paid` varchar(999) DEFAULT NULL,
  `dues` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (1, '1', '9876543210', '81629822', '232878', '2500', '500', '2000', '2025-07-24 07:11:29', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (2, '1', '9876543210', '42655434', '331744', '7500', '1000', '6500', '2025-07-24 07:12:10', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (3, '1', '9876543210', '42655434', '884134', '6400', '500', '5900', '2025-07-24 07:12:28', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (4, '1', '9876543210', '81629822', '582944', '2000', '100', '1900', '2025-07-24 07:13:01', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (5, '1', '9876543210', '67096209', '690873', '5000', '5000', '0', '2025-07-24 07:34:33', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (6, '1', '9876543210', '23015139', '389949', '1600', '01600', '0', '2025-08-09 18:29:34', '1');


#
# TABLE STRUCTURE FOR: cut_pv
#

DROP TABLE IF EXISTS `cut_pv`;

CREATE TABLE `cut_pv` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) DEFAULT NULL,
  `pv` int DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `note` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: details
#

DROP TABLE IF EXISTS `details`;

CREATE TABLE `details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sponsor` varchar(111) DEFAULT NULL,
  `upid` varchar(111) DEFAULT NULL,
  `uid` varchar(111) DEFAULT NULL,
  `mid` varchar(99) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `branch` varchar(99) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `staff` varchar(99) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `pass` varchar(111) DEFAULT NULL,
  `pass1` varchar(999) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `pass2` varchar(999) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `name` varchar(111) DEFAULT NULL,
  `fname` varchar(111) DEFAULT NULL,
  `mob` varchar(111) DEFAULT NULL,
  `email` varchar(111) DEFAULT NULL,
  `dob` varchar(111) DEFAULT NULL,
  `address` varchar(111) DEFAULT NULL,
  `aadhar` varchar(111) DEFAULT NULL,
  `pan` varchar(111) DEFAULT NULL,
  `photo` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `doc_aadhar` varchar(111) DEFAULT NULL,
  `doc_pan` varchar(111) DEFAULT NULL,
  `sponsors` varchar(99) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `luid` varchar(111) DEFAULT NULL,
  `ruid` varchar(111) DEFAULT NULL,
  `tlm` int DEFAULT NULL,
  `tlpv` int NOT NULL,
  `trpv` int NOT NULL,
  `tlpv1` int NOT NULL,
  `trpv1` int NOT NULL,
  `trm` int NOT NULL,
  `tpv` int NOT NULL,
  `rpv` int NOT NULL,
  `lsp` varchar(99) DEFAULT NULL,
  `rsp` varchar(99) DEFAULT NULL,
  `tlsp` int NOT NULL,
  `trsp` int NOT NULL,
  `capping` int NOT NULL,
  `root1` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `tlm1` int DEFAULT NULL,
  `tlm2` int NOT NULL,
  `tlm3` int NOT NULL,
  `wallet` float DEFAULT NULL,
  `wallet1` float DEFAULT NULL,
  `wallet2` float NOT NULL,
  `wallet3` float NOT NULL,
  `level` int DEFAULT NULL,
  `level1` int NOT NULL,
  `level2` int NOT NULL,
  `level3` int NOT NULL,
  `status` int DEFAULT NULL,
  `status1` int NOT NULL,
  `status2` int NOT NULL,
  `status3` int NOT NULL,
  `status4` int NOT NULL,
  `root` text,
  `ac_holder` varchar(111) DEFAULT NULL,
  `bank_name` varchar(111) DEFAULT NULL,
  `branch_name` varchar(111) DEFAULT NULL,
  `ifsc` varchar(111) DEFAULT NULL,
  `ac_no` varchar(111) DEFAULT NULL,
  `n_name` varchar(111) DEFAULT NULL,
  `n_relation` varchar(999) DEFAULT NULL,
  `n_address` varchar(111) DEFAULT NULL,
  `n_dob` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `role` int DEFAULT NULL,
  `product` int DEFAULT NULL,
  `paym` int DEFAULT NULL,
  `kyc` int DEFAULT NULL,
  `gen` varchar(111) DEFAULT NULL,
  `state` varchar(111) DEFAULT NULL,
  `dist` varchar(111) DEFAULT NULL,
  `pin` varchar(111) DEFAULT NULL,
  `ac_type` varchar(111) DEFAULT NULL,
  `pans` int DEFAULT NULL,
  `pr` int DEFAULT NULL,
  `binary1` int DEFAULT NULL,
  `upd_date` varchar(999) DEFAULT NULL,
  `upd_date2` varchar(999) DEFAULT NULL,
  `kyc2` int DEFAULT NULL,
  `smsd` varchar(999) NOT NULL,
  `logs` int NOT NULL,
  `roya` int DEFAULT NULL,
  `kyc_message` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `popups` int NOT NULL,
  `mt` int NOT NULL,
  `per` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=597 DEFAULT CHARSET=latin1;

INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (1, '', '', '9876543210', '70897', '1', '56605', 'amit@12345', '123456', '123456', 'Lov Prakash', '', '8084940179', 'ssp@gmail.com', '2002-03-01', 'nawachak, Patepur, Patepur, Vaishali, Nawa Chak, Bihar, India, 843114', '823539636200', 'CBZPP2003E', 'photo_1748939201.png', '', '', '', '9903382291', NULL, 53, 10500017, 0, 10500017, 0, 0, 0, 0, '9903382291', NULL, 53, 0, 100000, '', 0, 1, 0, '0', '0', '1', '0', 0, 0, 0, 0, 0, 1, 1, 1, 1, NULL, 'Lov Prakash', '', '', 'IBKL0001836', '1836104000018203', '', '', '', '', '2020-05-24 21:35:57', '2025-09-12 09:29:39', 1, 14, 0, 1, 'Male', 'Bihar', 'Vaishali', '843114', 'Saving', 1, 0, 1, '2021-05-05 20:26:01', '', 0, 'Docate No 989898 Delhivery', 1, NULL, '', 0, 2, '2');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (543, '9876543210', '9876543210', '9903382291', '', '', '', '0987', '', '', 'Bikash Kumar Das', '', '9903382291', 'bkdaskol@gmail.com', '1977-01-01', 'Gurmia, Lalganj, Vaishali, Akhtiarpur Mohan Urf Lautan, Bihar, India, 844117', '490608171152', 'AGVPD4624q', 'photo_1749208604.png', NULL, NULL, '', '9057513280', '7282076549', 47, 10500014, 2, 10500011, 0, 5, 2, 0, '0000000006', '7282076549', 47, 5, 80, '', NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210', 'Bikash Kumar Das', '', '', 'SBIN0003231', '20014673518', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, 'Male', 'Bihar', 'Vaishali', '844117', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (547, '9876543210', '0052369741', '0000000001', '', '', '', '123456', '', '', 'akash kumar', NULL, '0000000001', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000002', NULL, 43, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 43, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (546, '9876543210', '0852369741', '0052369741', '', '', '', '123456', '', '', 'MD zakir', NULL, '0052369741', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000001', NULL, 44, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 44, 0, 80, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (544, '9903382291', '9903382291', '9057513280', '', '', '', '999999999', '', '', 'ARJUN SINGH ', NULL, '9057513280', 'arjunsog1564@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0852369741', NULL, 46, 10500014, 0, 10500014, 0, 0, 0, 0, NULL, NULL, 46, 0, 0, '', NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (545, '9876543210', '9057513280', '0852369741', '', '', '', '123456', '', '', 'Ashok das', NULL, '0852369741', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0052369741', NULL, 45, 10500014, 0, 10500014, 0, 0, 0, 0, NULL, NULL, 45, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (548, '9876543210', '0000000001', '0000000002', '', '', '', '123456', '', '', 'pardeep kumar', NULL, '0000000002', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000003', NULL, 42, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 42, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (549, '9876543210', '0000000002', '0000000003', '', '', '', '123456', '', '', 'arvind kumar', NULL, '0000000003', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000004', NULL, 41, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 41, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (550, '9876543210', '0000000003', '0000000004', '', '', '', '123456', '', '', 'shahil singh', NULL, '0000000004', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000005', NULL, 40, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 40, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (551, '9876543210', '0000000004', '0000000005', '', '', '', '123456', '', '', 'kunal gupta', NULL, '0000000005', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000007', NULL, 39, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 39, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (552, '9876543210', '0000000005', '0000000007', '', '', '', '123456', '', '', 'MD shazad ', NULL, '0000000007', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000008', NULL, 38, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 38, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (553, '9876543210', '0000000007', '0000000008', '', '', '', '123456', '', '', 'vicky sharma', NULL, '0000000008', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000009', NULL, 37, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 37, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (554, '9876543210', '0000000008', '0000000009', '', '', '', '123456', '', '', 'nitendra kumar', NULL, '0000000009', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000010', NULL, 36, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 36, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (555, '9903382291', '0000000009', '0000000010', '', '', '', '123456', '', '', 'golu parshad', NULL, '0000000010', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000011', NULL, 35, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 35, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (556, '9903382291', '0000000010', '0000000011', '', '', '', '123456', '', '', 'Karan sharma', NULL, '0000000011', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000012', NULL, 34, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 34, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (557, '9903382291', '0000000011', '0000000012', '', '', '', '123456', '', '', 'Lalita kumari', NULL, '0000000012', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000013', NULL, 33, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 33, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (558, '9903382291', '0000000012', '0000000013', '', '', '', '123456', '', '', 'Muskan singh', NULL, '0000000013', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000014', NULL, 32, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 32, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (559, '9903382291', '0000000013', '0000000014', '', '', '', '123456', '', '', 'Nitu das', NULL, '0000000014', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000015', NULL, 31, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 31, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (560, '9903382291', '0000000014', '0000000015', '', '', '', '123456', '', '', 'abhiraj kumar', NULL, '0000000015', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000016', NULL, 30, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 30, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (561, '9903382291', '0000000015', '0000000016', '', '', '', '1234', '', '', 'anish singh', NULL, '0000000016', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000017', NULL, 29, 10500013, 0, 10500013, 0, 0, 0, 0, NULL, NULL, 29, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (562, '9903382291', '0000000016', '0000000017', '', '', '', '1990', '', '', 'Santu Sardar', '', '890217775', '', '1990-04-13', '25/E middle road o sen para, Santoshpur, Circus Avenue, Kolkata, Santoshpur, West Bengal, India, 700075', '596264201864', 'EXTPS8219D', 'photo_1750486008.png', NULL, NULL, '', '0000000018', '8420245625', 4, 10000003, 500009, 9499994, 0, 24, 88, 0, '6290254725', '8420245625', 4, 24, 80, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016', 'Santu Sardar', '', '', 'IOBA0003273', '327301000003561', '', '', '', '', NULL, '2025-09-12 09:29:39', 0, 14, NULL, NULL, 'Male', 'West Bengal', 'Kolkata', '700075', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (563, '9903382291', '0000000017', '0000000018', '', '', '', '09876', '', '', 'Amar kumar', NULL, '7903365811', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0000000006', NULL, 3, 10000002, 0, 10000002, 0, 0, 0, 0, NULL, NULL, 3, 0, 80, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (564, '9903382291', '0000000018', '0000000006', '', '', '', '123456', '', '', 'Debarshi Basu', NULL, '9830195350', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '9939864956', NULL, 2, 10000001, 0, 10000001, 0, 0, 0, 0, NULL, NULL, 2, 0, 80, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,0000000018', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (565, '9903382291', '9903382291', '7282076549', '', '', '', '94567', '', '', 'AJIT KUMAR ', NULL, '7282076549', 'bkdaskol@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '9525225480', '9230679356', 2, 10000001, 0, 10000001, 0, 2, 0, 0, '9525225480', NULL, 2, 2, 80, '', NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (566, '9876543210', '0000000006', '9939864956', '', '', '', '23456765', '', '', 'anil das', NULL, '9876878709', 'vishaldastanti@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '6290254725', NULL, 1, 10000001, 0, 10000001, 0, 0, 0, 0, NULL, NULL, 1, 0, 0, '', NULL, 1, 0, '0', NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,0000000018,0000000006', NULL, NULL, NULL, '', '', '', '', NULL, NULL, NULL, '2025-09-12 09:29:39', 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (567, '9903382291', '7282076549', '9230679356', NULL, NULL, NULL, '891516', NULL, NULL, 'Akhilesh Kumar Shaw', '', '9230679356', 'akhileshkumarshaw@gmail.com', '1973-06-05', '101/8, SURENDRA NATH BANERJEE ROAD, PS- TALTALA, Kolkata, Entally, West Bengal, India, 700014', '274203923875', 'AVZPS3588H', 'photo_1749888348.png', NULL, NULL, NULL, NULL, '9339116805', 0, 0, 0, 0, 0, 1, 0, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,7282076549', 'Akhilesh Kumar Shaw', '', '', 'UCBA0000322', '032201000013982', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, 'Male', 'West Bengal', 'Kolkata', '700014', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (568, '0000000017', '9939864956', '6290254725', NULL, NULL, NULL, '1990', NULL, NULL, 'Santu Sardar', '', '6290254725', '', '1990-04-13', '25/E middle road o sen para, Santoshpur, Circus Avenue, Kolkata, Santoshpur, West Bengal, India, 700075', '596264201864', 'EXTPS8219D', 'photo_1750487633.png', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,0000000018,0000000006,9939864956', 'Santu Sardar', '', '', 'IOBA0003273', '327301000003561', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, 'Male', 'West Bengal', 'Kolkata', '700075', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (569, '0000000017', '0000000017', '8420245625', NULL, NULL, NULL, '842024', NULL, NULL, 'Santu Sardar', '', '8420245625', '', '1990-04-13', '25/E middle road o sen para, Santoshpur, Circus Avenue, Kolkata, Santoshpur, West Bengal, India, 700075', '596264201864', 'EXTPS8219D', 'photo_1750488316.png', NULL, NULL, NULL, '8617298087', '9804624269', 1, 1, 500007, 0, 500005, 22, 1, 0, '8617298087', '9804624269', 1, 22, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017', 'Santu Sardar', '', '', 'IOBA0003273', '327301000003561', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, 'Male', 'West Bengal', 'Kolkata', '700075', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (570, '8420245625', '8420245625', '9804624269', NULL, NULL, NULL, '9804624269', NULL, NULL, 'DEBASISH NASKAR ', NULL, '9804624269', 'dnaskar100@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8240364230', 0, 0, 500006, 0, 500006, 21, 0, 0, NULL, NULL, 0, 21, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (571, '7282076549', '7282076549', '9525225480', NULL, NULL, NULL, '9525225480', NULL, NULL, 'Naresh Kumar Sharma', '', '9525225480', 'nks050593@gmail.com', '1993-05-05', 'Gurmia, Lalganj, Vaishali, Akhtiarpur Mohan Urf Lautan, Bihar, India, 844117', '424605146599', 'CMPPS3988C', 'photo_1751718843.png', NULL, NULL, NULL, '90075627728', NULL, 1, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 1, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,7282076549', 'Naresh Kumar Sharma', '', '', 'SBIN0001483', '30968335955', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, 'Male', 'Bihar', 'Vaishali', '844117', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (572, '7282076549', '9525225480', '90075627728', NULL, NULL, NULL, '12345678', NULL, NULL, 'SAGAR GUPTA ', NULL, '90075627728', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,7282076549,9525225480', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (573, '8420245625', '9804624269', '8240364230', NULL, NULL, NULL, 'Sgtx@2023', NULL, NULL, 'Partha Bose', '', '8240364230', 'Parthabose370@gmail.com', '1980-09-30', 'A/53, R.PALLY, BAGHAJATIN, Kolkata, KOLKATA, West Bengal, India, 700086', '957993360493', 'AHTPB4710', 'photo_1751517030.png', NULL, NULL, NULL, '9051778326', '9732811805', 4, 4, 500001, 0, 499998, 16, 3, 0, '9051778326', '9732811805', 4, 16, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269', 'Partha Bose', '', '', 'SBIN0016629', '40035928043', '', '', '', '', NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, 'Male', 'West Bengal', 'Kolkata', '700086', 'Saving', NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (574, '9230679356', '9230679356', '9339116805', NULL, NULL, NULL, '933911', NULL, NULL, 'Manoj Kumar Das ', NULL, '9339116805', 'dasm16552@gmai.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,7282076549,9230679356', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (575, '8240364230', '8240364230', '9051778326', NULL, NULL, NULL, '123456', NULL, NULL, 'MAMPI BOSE ', NULL, '9051778326', 'tuhinbose370@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8617298372', NULL, 3, 3, 0, 3, 0, 0, 0, 0, NULL, NULL, 3, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (576, '8240364230', '9051778326', '8617298372', NULL, NULL, NULL, '123456', NULL, NULL, 'RUDRABRATA SIKDER', NULL, '8617298372', 'rudrab935@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8617712078', NULL, 2, 2, 0, 2, 0, 0, 0, 0, NULL, NULL, 2, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9051778326', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (577, '8240364230', '8240364230', '9732811805', NULL, NULL, NULL, '123456', NULL, NULL, 'GOBINDA MONDAL ', NULL, '9732811805', 'asylumgobindamondal@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8337084087', 0, 0, 500000, 0, 500000, 15, 0, 0, NULL, NULL, 0, 15, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (578, '8420245625', '8420245625', '8617298087', NULL, NULL, NULL, '1234', NULL, NULL, 'JUI MONDAL ', NULL, '8617298087', 'aquaguardservice61@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (579, '8240364230', '8617298372', '8617712078', NULL, NULL, NULL, '123456', NULL, NULL, 'TAPAN ROY', NULL, '8617712078', 'tapanroy251959@gmai.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9123619266', NULL, 1, 1, 0, 1, 0, 0, 0, 0, NULL, NULL, 1, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9051778326,8617298372', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (580, '8240364230', '9732811805', '8337084087', NULL, NULL, NULL, '123456', NULL, NULL, 'Sanat  biswas', NULL, '8337084087', 'biswassagar054@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9831930896', '9831026647', 1, 0, 500000, 0, 500000, 13, 0, 0, NULL, NULL, 1, 13, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (581, '8337084087', '8337084087', '9831930896', NULL, NULL, NULL, '1234', NULL, NULL, 'Shailendra sharma ', NULL, '9831930896', 'shailendrashar9748@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (582, '8240364230', '8337084087', '9831026647', NULL, NULL, NULL, '0987', NULL, NULL, 'SAMBHU SAHA', NULL, '9831026647', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9073858941', 0, 0, 500000, 0, 500000, 12, 0, 0, NULL, NULL, 0, 12, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (583, '9831026647', '9831026647', '9073858941', NULL, NULL, NULL, '1234', NULL, NULL, 'PHOOL MURMU ', NULL, '9073858941', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7595940416', '7439227614', 1, 0, 500000, 0, 500000, 10, 0, 0, NULL, NULL, 1, 10, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (584, '9831026647', '9073858941', '7439227614', NULL, NULL, NULL, '9632', NULL, NULL, 'PRADIP SAHA ', NULL, '7439227614', 'pradipcar70@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8777685384', 0, 0, 500000, 0, 500000, 9, 0, 0, NULL, NULL, 0, 9, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (585, '8420245625', '7439227614', '8777685384', NULL, NULL, NULL, '1234', NULL, NULL, 'MANGAL HALDER', NULL, '8777685384', 'halmangolf1984@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9570032720', 0, 0, 500000, 0, 500000, 8, 0, 0, NULL, NULL, 0, 8, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (586, '8777685384', '8777685384', '9570032720', NULL, NULL, NULL, '1234', NULL, NULL, 'Deepak kumar swarnkar', NULL, '9570032720', 'deepakbarma204@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7908777395', 0, 0, 500000, 0, 500000, 7, 0, 0, NULL, NULL, 0, 7, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (587, '9570032720', '9570032720', '7908777395', NULL, NULL, NULL, '1234', NULL, NULL, 'Sanjeeb Kumar Jha ', NULL, '7908777395', 'sanjeevjha15121979@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9830184939', 0, 0, 500000, 0, 500000, 6, 0, 0, NULL, NULL, 0, 6, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (588, '8777685384', '7908777395', '9830184939', NULL, NULL, NULL, '1234', NULL, NULL, 'Kutubuddin Laskar', NULL, '9830184939', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '8509254991', 0, 0, 500000, 0, 500000, 5, 0, 0, NULL, NULL, 0, 5, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (589, '8777685384', '9830184939', '8509254991', NULL, NULL, NULL, '1234', NULL, NULL, 'RAM MONDAL', NULL, '8509254991', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9064093897', 0, 0, 500000, 0, 500000, 4, 0, 0, NULL, NULL, 0, 4, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395,9830184939', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (590, '8777685384', '8509254991', '9064093897', NULL, NULL, NULL, '1234', NULL, NULL, 'DIPAK GUPTA ', NULL, '9064093897', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '7003241019', 0, 0, 500000, 0, 500000, 3, 0, 0, NULL, NULL, 0, 3, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395,9830184939,8509254991', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (591, '8777685384', '9064093897', '7003241019', NULL, NULL, NULL, '1234', NULL, NULL, 'SUMAN DHAR', NULL, '7003241019', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9674182846', 0, 0, 500000, 0, 500000, 2, 0, 0, NULL, NULL, 0, 2, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395,9830184939,8509254991,9064093897', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (592, '8777685384', '7003241019', '9674182846', NULL, NULL, NULL, '1234', NULL, NULL, 'RAJ SARDAR', NULL, '9674182846', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '9635764037', 0, 0, 0, 0, 0, 1, 0, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395,9830184939,8509254991,9064093897,7003241019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (593, '8240364230', '8617712078', '9123619266', NULL, NULL, NULL, '123456', NULL, NULL, 'Sumanta Banerjee', NULL, '9123619266', 'banerjeesumanta891@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 80, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 0, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9051778326,8617298372,8617712078', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (594, '9073858941', '9073858941', '7595940416', NULL, NULL, NULL, '1234', NULL, NULL, 'SHYAMALY KOTAL', NULL, '7595940416', 'shyamalykotal@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (595, '8240364230', '9674182846', '9635764037', NULL, NULL, NULL, '123456', NULL, NULL, 'Tanmoy biswas', NULL, '9635764037', 'rocktanmoy43@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, '0', '0', NULL, 0, 0, 0, 1, 0, 0, 0, 0, ',9876543210,9903382291,9057513280,0852369741,0052369741,0000000001,0000000002,0000000003,0000000004,0000000005,0000000007,0000000008,0000000009,0000000010,0000000011,0000000012,0000000013,0000000014,0000000015,0000000016,0000000017,8420245625,9804624269,8240364230,9732811805,8337084087,9831026647,9073858941,7439227614,8777685384,9570032720,7908777395,9830184939,8509254991,9064093897,7003241019,9674182846', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 0, NULL, NULL, 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `sponsors`, `luid`, `ruid`, `tlm`, `tlpv`, `trpv`, `tlpv1`, `trpv1`, `trm`, `tpv`, `rpv`, `lsp`, `rsp`, `tlsp`, `trsp`, `capping`, `root1`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `status4`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (596, '8084940179', NULL, '9876543210', NULL, '0', NULL, '123456', NULL, NULL, 'Test', NULL, '9876543210', 'test@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 0, 0, NULL, 0, 0, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-09-12 09:29:39', '2025-09-12 09:29:39', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, NULL, 0, 0, '0');


#
# TABLE STRUCTURE FOR: details1
#

DROP TABLE IF EXISTS `details1`;

CREATE TABLE `details1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sponsor` varchar(111) DEFAULT NULL,
  `upid` varchar(111) DEFAULT NULL,
  `uid` varchar(111) DEFAULT NULL,
  `mid` varchar(99) NOT NULL,
  `branch` varchar(99) NOT NULL,
  `staff` varchar(99) NOT NULL,
  `pass` varchar(111) DEFAULT NULL,
  `pass1` varchar(999) NOT NULL,
  `pass2` varchar(999) NOT NULL,
  `name` varchar(111) DEFAULT NULL,
  `fname` varchar(111) DEFAULT NULL,
  `mob` varchar(111) DEFAULT NULL,
  `email` varchar(111) DEFAULT NULL,
  `dob` varchar(111) DEFAULT NULL,
  `address` varchar(111) DEFAULT NULL,
  `aadhar` varchar(111) DEFAULT NULL,
  `pan` varchar(111) DEFAULT NULL,
  `photo` varchar(111) DEFAULT NULL,
  `doc_aadhar` varchar(111) DEFAULT NULL,
  `doc_pan` varchar(111) DEFAULT NULL,
  `luid` varchar(111) DEFAULT NULL,
  `ruid` varchar(111) DEFAULT NULL,
  `tlm` int DEFAULT NULL,
  `tlm1` int DEFAULT NULL,
  `tlm2` int NOT NULL,
  `tlm3` int NOT NULL,
  `wallet` float DEFAULT NULL,
  `wallet1` float DEFAULT NULL,
  `wallet2` float NOT NULL,
  `wallet3` float NOT NULL,
  `level` int DEFAULT NULL,
  `level1` int NOT NULL,
  `level2` int NOT NULL,
  `level3` int NOT NULL,
  `status` int DEFAULT NULL,
  `status1` int NOT NULL,
  `status2` int NOT NULL,
  `status3` int NOT NULL,
  `root` text,
  `ac_holder` varchar(111) DEFAULT NULL,
  `bank_name` varchar(111) DEFAULT NULL,
  `branch_name` varchar(111) DEFAULT NULL,
  `ifsc` varchar(111) DEFAULT NULL,
  `ac_no` varchar(111) DEFAULT NULL,
  `n_name` varchar(111) DEFAULT NULL,
  `n_relation` varchar(999) DEFAULT NULL,
  `n_address` varchar(111) DEFAULT NULL,
  `n_dob` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `role` int DEFAULT NULL,
  `product` int DEFAULT NULL,
  `paym` int DEFAULT NULL,
  `kyc` int DEFAULT NULL,
  `gen` varchar(111) DEFAULT NULL,
  `state` varchar(111) DEFAULT NULL,
  `dist` varchar(111) DEFAULT NULL,
  `pin` varchar(111) DEFAULT NULL,
  `ac_type` varchar(111) DEFAULT NULL,
  `pans` int DEFAULT NULL,
  `pr` int DEFAULT NULL,
  `binary1` int DEFAULT NULL,
  `upd_date` varchar(999) DEFAULT NULL,
  `upd_date2` varchar(999) DEFAULT NULL,
  `kyc2` int DEFAULT NULL,
  `smsd` varchar(999) NOT NULL,
  `logs` int NOT NULL,
  `roya` int DEFAULT NULL,
  `kyc_message` text NOT NULL,
  `popups` int NOT NULL,
  `mt` int NOT NULL,
  `per` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=433 DEFAULT CHARSET=latin1;

INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (1, '', '', '8084940179', '70897', '1', '56605', 'Abhishek@21574', 'Manoj', 'future', 'Tryit India', '', '8084940179', 'tryit@gmail.com', '', 'Muz', '458745684586', '', '', '', '', '', '', 0, 0, 219, 0, '0', '0', '896.261', '0', 0, 0, 0, 0, 0, 1, 1, 1, NULL, 'admin', 'ICICI BANK', 'Muzaffarpur', 'ICIC0000306', '030605010185', '', '', '', '', '2020-05-24 21:35:57', '2021-08-21 21:08:30', 1, 14, 0, 1, '', '', '', '', 'Saving', 1, 0, 1, '2021-05-05 20:26:01', '', 0, 'Docate No 989898 Delhivery', 1, NULL, '', 0, 2, '2');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (220, '8084940179', NULL, '9939195269', '', '0', '', '12345', '', '', 'Manoj Sharma', NULL, '9939195269', 'tryit@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 218, 0, '0', '0', '1655.86', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-16 18:13:54', '2021-08-21 21:08:30', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 1, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (221, '9939195269', NULL, '7979030395', '', '0', '', '123456', '', '', 'AMAR SINGH', NULL, '7979030395', 'amarsingh101834@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 211, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-19 19:26:18', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (222, '9939195269', NULL, '9918508019', '', '0', '', 'imcool_manish1984', '', '', 'Manish kumar sharma', NULL, '9918508019', 'manishsharma873@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 210, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:20:53', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (223, '9939195269', NULL, '7992259617', '', '0', '', 'v12345', '', '', 'Vimal Kumar', NULL, '7992259617', 'biharbhakti.vimal@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 209, 0, '0', '0', '329.3', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:26:19', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (224, '9918508019', NULL, '6386476787', '', '0', '', 'Rohit@1819', '', '', 'Rohit Sharma', NULL, '6386476787', 'rohitfriends.rkt@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 208, 0, '0', '0', '77.05', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:32:07', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (225, '9939195269', NULL, '9939090087', '', '0', '', 'Sanjay123', '', '', 'Sanjay Kumar Mishra', NULL, '9939090087', 'skmishra951968@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 207, 0, '0', '0', '197.54', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:33:38', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (249, '9939090087', NULL, '9955688371', '', '0', '', 'Info@123', '', '', 'Surendra Bharti', NULL, '9955688371', 'bdm.surendra@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 183, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:19:38', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (227, '6386476787', NULL, '7004983144', '', '0', '', 'abhi1234', '', '', 'Abhishek Sharma', NULL, '7004983144', 'abhisheksharma.rkt@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 205, 0, '0', '0', '10.8', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:39:10', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (228, '9939195269', NULL, '9693287571', '', '0', '', '1977', '', '', 'SANJEEV PANDEY ', NULL, '9693287571', 'Sanjeev.pds73@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 204, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:44:19', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (248, '9931667459', NULL, '9471668022', '', '0', '', 'S12345', '', '', 'Sidh Nath Tiwari', NULL, '9471668022', 'nathtiwarys@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 184, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:16:00', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (230, '7004983144', NULL, '9576684117', '', '0', '', 'abhi1234', '', '', 'Raghuraj Rai', NULL, '9576684117', 'abhiraat18@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 201, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:48:53', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (247, '9939090087', NULL, '7700841919', '', '0', '', '123456', '', '', 'Abhishek Kumar', NULL, '7700841919', 'abhishek11178@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 185, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:11:54', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (246, '7004983144', NULL, '9931667459', '', '0', '', '654321', '', '', 'Umesh sharma', NULL, '9931667459', 'umeshvibha123@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 186, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:05:54', '2021-08-21 20:25:37', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (233, '7004983144', NULL, '9508253533', '', '0', '', 'Manglam@123', '', '', 'Manglam', NULL, '9508253533', 'manglamvats175@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 199, 0, '0', '0', '1.7', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:52:26', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (245, '9939090087', NULL, '7301536136', '', '0', '', 'Amit@2907', '', '', 'Amit Kumar', NULL, '7301536136', 'ajay.amit29@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 187, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 19:51:46', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (244, '7004983144', NULL, '9546177051', '', '0', '', '842002abhigyan', '', '', 'Abhigyan kumar', NULL, '9546177051', 'abhigyan80@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 188, 0, '0', '0', '11.5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 15:37:24', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (236, '7004983144', NULL, '7764898317', '', '0', '', 'yash@tryit', '', '', 'Yash Rajpal', NULL, '7764898317', 'yashh.you@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 196, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:56:10', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (237, '7004983144', NULL, '7004779572', '', '0', '', '77791sbp', '', '', 'kaushik srivastava', NULL, '7004779572', 'harshkaushik129@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 195, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 11:44:54', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (238, '7004983144', NULL, '6201211018', '', '0', '', '20376762473', '', '', 'Prince Raj Jha', NULL, '6201211018', 'vickyjha5078@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 194, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 12:28:37', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (243, '8210179625', NULL, '7369882648', '', '0', '', 'avanisH@9', '', '', 'Avanish Kumar', NULL, '7369882648', 'avkumar4321@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 189, 0, '0', '0', '49.235', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 14:00:31', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (240, '7004983144', NULL, '7301101143', '', '0', '', 'steveroger007', '', '', 'Harshit Harsh', NULL, '7301101143', 'harshitharsh32@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 192, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 12:31:01', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (241, '7979030395', NULL, '8210179625', '', '0', '', 'kumar', '', '', 'Mithilesh Kumar', NULL, '8210179625', 'mithileshpds@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 191, 0, '0', '0', '146.345', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 13:18:21', '2021-08-21 20:25:37', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (242, '7004983144', NULL, '9934748803', '', '0', '', 'adi123...', '', '', 'Aditya Raj', NULL, '9934748803', 'adityaraj001213@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 190, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 13:42:21', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (250, '7004983144', NULL, '7050096409', '', '0', '', 'Ab21021989@', '', '', 'Abhishek Kumar', NULL, '7050096409', 'akumarsit1989@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 182, 0, '0', '0', '1', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:20:49', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (251, '6201211018', NULL, '9798067920', '', '0', '', 'Pramod 123', '', '', 'Pramod Kumar jha', NULL, '9798067920', 'pramodkumarjha38@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 181, 0, '0', '0', '2.36', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:29:08', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (252, '9939090087', NULL, '9939002200', '', '0', '', 'amresh', '', '', 'Amresh kumar', NULL, '9939002200', 'oshoamresh94@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 180, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:33:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (253, '6201211018', NULL, '8227973889', '', '0', '', 'passwordkumari', '', '', 'Shalini mishra', NULL, '8227973889', 'shalinimishra8804@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 179, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:46:14', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (254, '9939090087', NULL, '8084562474', '', '0', '', 'shobha', '', '', 'Surendra chaudhary', NULL, '8084562474', 'surendraflp74@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 178, 0, '0', '0', '3.94', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:50:56', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (255, '7369882648', NULL, '7371815641', '', '0', '', 'shyam3115kumar', '', '', 'Shyam kumar', NULL, '7371815641', 'shyam7371@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 177, 0, '0', '0', '33.065', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,7369882648', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 22:02:55', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (256, '8210179625', NULL, '8936058495', '', '0', '', '181922', '', '', 'Rajni', NULL, '8936058495', 'rspankhurig@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 176, 0, '0', '0', '201', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 22:23:47', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (257, '7004983144', NULL, '9334906149', '', '0', '', 'Npa241116@', '', '', 'Hanuman Prasad Marodiya', NULL, '9334906149', 'mr.nagarwal27@rediffmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 175, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 07:57:06', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (258, '7004983144', NULL, '9155868679', '', '0', '', '9693', '', '', 'Amod Kumar ', NULL, '9155868679', 'amod200584@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 174, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 08:08:22', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (259, '7004983144', NULL, '8789369583', '', '0', '', '9934033810', '', '', 'Himanshu kumar singh', NULL, '8789369583', 'Himanshusinghrathore0000@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 173, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 08:38:15', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (260, '9334906149', NULL, '9199354154', '', '0', '', 'Npa241116@', '', '', 'Pooja Agarwal', NULL, '9199354154', 'Poojakeshri07@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 172, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:01:52', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (261, '9199354154', NULL, '8603590717', '', '0', '', 'Npa241116@', '', '', 'Nikhil Kumar Agarwal', NULL, '8603590717', 'jaimatadi010413@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 171, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149,9199354154', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:05:20', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (262, '9334906149', NULL, '9199701755', '', '0', '', 'Npa241116@', '', '', 'Nikhil kumar Agarwal', NULL, '9199701755', 'jaimatadeetraders010410@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 170, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:10:29', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (263, '9939090087', NULL, '7903515631', '', '0', '', '9771123695', '', '', 'Raghavendra Kumar', NULL, '7903515631', 'raghavendrakrmishra@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 169, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:36:26', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (264, '6201211018', NULL, '7461099919', '', '0', '', '746109', '', '', 'KÃRÃÑ kumar', NULL, '7461099919', 'karankumar37160@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 168, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:06:22', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (265, '7461099919', NULL, '8574681882', '', '0', '', 'jata shankar', '', '', 'Jata shankar ', NULL, '8574681882', 'jatashankarzee@gmail', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 167, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018,7461099919', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:16:05', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (266, '8210179625', NULL, '9955659959', '', '0', '', 'prachi51', '', '', 'Wipin kumar', NULL, '9955659959', 'prachi9955659959@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 166, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:23:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (267, '9693287571', NULL, '9931220861', '', '0', '', '12345', '', '', 'Sunny Pandey ', NULL, '9931220861', 'sunnypandey850@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 165, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9693287571', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:27:08', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (268, '9199701755', NULL, '6201655088', '', '0', '', 'Npa241116@', '', '', 'Nikhil kumar Agarwal', NULL, '6201655088', 'jaimatadi010413@rediffmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 164, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149,9199701755', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:40:06', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (269, '8210179625', NULL, '8210687557', '', '0', '', 'R12345', '', '', 'RAJEEV RANJAN MISHRA', NULL, '8210687557', 'rajiv@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 163, 0, '0', '0', '157.14', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:52:29', '2021-08-21 21:08:30', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (270, '8210179625', NULL, '9570641920', '', '0', '', '7250164501', '', '', 'Manish kumar', NULL, '9570641920', 'mk14606@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 162, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 13:43:45', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (271, '9939090087', NULL, '9708773892', '', '0', '', '27011996', '', '', 'Ram kumar', NULL, '9708773892', 'ar586399@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 161, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 13:46:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (308, '9939195269', NULL, '9835153380', '', '0', '', '983515', '', '', 'Lov Prakash', NULL, '9835153380', 'kushprakash92@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 124, 0, '0', '0', '102.8', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 18:16:58', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (272, '8210179625', NULL, '9661725051', '', '0', '', '9661725051', '', '', 'Dilip kumar', NULL, '9661725051', 'dkjee5051@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 160, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 14:34:04', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (273, '9939090087', NULL, '9708203929', '', '0', '', 'Kpsingh123', '', '', 'Kaushlendra prasad singh', NULL, '9708203929', 'kaushlendra10bxdps3869n@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 159, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:25:54', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (274, '8210179625', NULL, '9934919689', '', '0', '', '22222', '', '', 'Jitendra kumar', NULL, '9934919689', 'jitendra_kumar008@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 158, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:43:07', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (275, '8210687557', NULL, '6207574162', '', '0', '', 'S12345', '', '', 'SURESH PRASAD SHAHI', NULL, '6207574162', 'suresh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 157, 0, '0', '0', '54', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:57:30', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (276, '8210687557', NULL, '9708314717', '', '0', '', 'krity0', '', '', 'Kanhaiya Lal Singh', NULL, '9708314717', 'kl.singh86@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 156, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 21:10:00', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (277, '7004983144', NULL, '7717790405', '', '0', '', '9525093649', '', '', 'Pankaj Kumar ', NULL, '7717790405', 'pankajkumar02390@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 155, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 22:10:51', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (278, '9939090087', NULL, '7563092302', '', '0', '', 'av1234', '', '', 'Abhilasha Kumari', NULL, '7563092302', 'abhilashapathak1999@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 154, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 22:27:36', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (279, '8210179625', NULL, '9304292354', '', '0', '', 'deepak', '', '', 'Deepak', NULL, '9304292354', 'deepakpappu9304@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 153, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 12:35:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (280, '7979030395', NULL, '9122894111', '', '0', '', '12345', '', '', 'amar', NULL, '9122894111', 'amarsingh101834@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 152, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 14:36:26', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (281, '9122894111', NULL, '8102811241', '', '0', '', '12345', '', '', 'AMAR SINGH', NULL, '8102811241', 'gmart.today@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 151, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 14:38:19', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (282, '9939090087', NULL, '8340289850', '', '0', '', 'chandni@123', '', '', 'Chandni', NULL, '8340289850', 'ck8409678724@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 150, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 15:36:04', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (283, '9939090087', NULL, '7991159941', '', '0', '', 'Gaurav@12345', '', '', 'Gaurav', NULL, '7991159941', 'gauav.pandey@icicibank.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 149, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 16:13:20', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (284, '7992259617', NULL, '7033280505', '', '0', '', 'Atul123', '', '', 'Atul Kumar', NULL, '7033280505', 'www.akumar6@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 148, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 18:18:31', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (285, '8102811241', NULL, '8873749286', '', '0', '', 'teamteogther2021', '', '', 'Team Teogther ', NULL, '8873749286', 'teamteogther2021@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 147, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:08:07', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (286, '8873749286', NULL, '6201847968', '', '0', '', 'rajkri', '', '', 'Team togther 1', NULL, '6201847968', 'teamtogther20211@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 146, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:38:46', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (287, '6201847968', NULL, '6204143525', '', '0', '', 'rajkri', '', '', 'Team together 2', NULL, '6204143525', 'teamtogether20212@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 145, 0, '0', '0', '100', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:50:03', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (288, '8210179625', NULL, '9835295896', '', '0', '', 'k123456', '', '', 'Kamlesh kumar', NULL, '9835295896', 'mithileshpds@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 144, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:54:29', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (289, '7004983144', NULL, '8092221370', '', '0', '', 'N12345', '', '', 'Nandan Kumar', NULL, '8092221370', 'nandanonly4u@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 143, 0, '0', '0', '2', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 20:19:40', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (290, '7004983144', NULL, '9430409859', '', '0', '', 'bcegkmqs', '', '', 'Manoj Kumar Singh', NULL, '9430409859', 'manojksinghreal952@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 142, 0, '0', '0', '2.5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 20:23:35', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (291, '6204143525', NULL, '6204736973', '', '0', '', '12345', '', '', 'AKASH OJHA', NULL, '6204736973', 'rajojha22222@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 141, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 12:57:08', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (292, '6204143525', NULL, '8235175667', '', '0', '', 'krishna', '', '', 'Krishna Kumar', NULL, '8235175667', 'krishna.ke55@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 140, 0, '0', '0', '434.4', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 13:07:09', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (293, '7004983144', NULL, '8102689164', '', '0', '', 'abhi1234', '', '', 'Pooja sharma ', NULL, '8102689164', 'poojaabhisharma14@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 139, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 15:27:17', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (294, '8235175667', NULL, '8873395437', '', '0', '', 'abha kumari', '', '', 'Abha Kumari', NULL, '8873395437', 'manishkumar88733954@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 138, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,8235175667', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 08:22:00', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (295, '6204143525', NULL, '7277977659', '', '0', '', '123456', '', '', 'RAJAN KUMAR', NULL, '7277977659', 'rajan1995ca@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 137, 0, '0', '0', '259.73', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 11:00:34', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (296, '9939195269', NULL, '9097027327', '', '0', '', 'Guriya', '', '', 'Anand mohan', NULL, '9097027327', 'mohananand887@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 136, 0, '0', '0', '5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 22:12:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (297, '7371815641', NULL, '7079700793', '', '0', '', 'Kunal@123', '', '', 'Kunal kumar', NULL, '7079700793', 'kunalbabu3238@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 135, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,7369882648,7371815641', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-26 10:15:17', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (298, '7004983144', NULL, '7903332032', '', '0', '', 'anadibabu71', '', '', 'Gauri Shankar Chaudhary', NULL, '7903332032', 'advgauriji71@email.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 134, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-26 16:29:27', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (299, '7004983144', NULL, '8083760428', '', '0', '', 'myname02QA', '', '', 'Kamar Alam', NULL, '8083760428', 'qamar198280@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 133, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-27 12:28:19', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (300, '8102811241', NULL, '7905018718', '', '0', '', 'tryitindia@123', '', '', 'Alok kushwaha', NULL, '7905018718', 'alok.prolabs@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 132, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-27 19:49:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (301, '7004983144', NULL, '9234659964', '', '0', '', 'A12345', '', '', 'Amod Kumar', NULL, '9234659964', 'srirambhoj@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 131, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 08:14:18', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (302, '6207574162', NULL, '7562026045', '', '0', '', 's12345', '', '', 'Shantanu kumar', NULL, '7562026045', 'Shantanukumar7562@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 130, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 09:17:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (303, '6386476787', NULL, '7518496436', '', '0', '', 'tryit123', '', '', 'Saroj Singh ', NULL, '7518496436', 'singhsaroj571@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 129, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 13:58:50', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (304, '8936058495', NULL, '7654487814', '', '0', '', 'aisha1234', '', '', 'Amisha ', NULL, '7654487814', 'amishakumari828@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 128, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 08:41:06', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (305, '8936058495', NULL, '7979835482', '', '0', '', '9852', '', '', 'Dhruv kumar', NULL, '7979835482', 'dhruvkumar.dk5@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 127, 0, '0', '0', '13', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 09:16:09', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (306, '7004983144', NULL, '8789638761', '', '0', '', '1982', '', '', 'Abhishek kartikya', NULL, '8789638761', 'abhi.shreemahimasteelandcrocry@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 126, 0, '0', '0', '8', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 10:41:15', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (307, '8235175667', NULL, '7992241588', '', '0', '', '001993', '', '', 'MD SARFRAJ', NULL, '7992241588', 'mdsarfrajmuz1993@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 125, 0, '0', '0', '2.4', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,8235175667', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 12:56:59', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (309, '9835153380', NULL, '8010221234', '', '0', '', '626474', '', '', 'Manish Kumar', NULL, '8010221234', 'manishmani116@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 123, 0, '0', '0', '82.72', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 18:18:37', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (310, '7004983144', NULL, '7903611039', '', '0', '', 'mack9852', '', '', 'Vikas singh', NULL, '7903611039', 'viks.singh62@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 122, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-30 19:02:44', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (311, '7004983144', NULL, '9386254826', '', '0', '', 'molu', '', '', 'Arjun singh ', NULL, '9386254826', 'arjun.sidhwalia@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 121, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 07:02:40', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (312, '7050096409', NULL, '9031291591', '', '0', '', 'k1r2i3t4i5', '', '', 'Raja kumar', NULL, '9031291591', 'kritinayakk@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 120, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,7050096409', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 16:14:15', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (313, '7004983144', NULL, '7004565299', '', '0', '', '777766', '', '', 'Shambhu Kumar', NULL, '7004565299', 'shambhu1976muz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 119, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 19:02:33', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (314, '9471668022', NULL, '9801037453', '', '0', '', 'R12345', '', '', 'Raghvendra Tiwari', NULL, '9801037453', 'raghvendratiwari504@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 118, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459,9471668022', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 20:06:45', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (315, '8936058495', NULL, '7352028508', '', '0', '', 'hk1087752', '', '', 'Harsh Raj', NULL, '7352028508', 'hk1087752@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 117, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 20:24:51', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (316, '7992259617', NULL, '9142836671', '', '0', '', 'Sona1976@', '', '', 'Sushmita kumari', NULL, '9142836671', 'sushmitakumari692@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 116, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 07:35:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (317, '7992259617', NULL, '7004233679', '', '0', '', '99318', '', '', 'Anand kumar', NULL, '7004233679', 'sonusinghanand01@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 115, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:13:02', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (318, '7004233679', NULL, '6204132224', '', '0', '', 'manishmahi', '', '', 'Manish kumar ', NULL, '6204132224', 'Manishmahi818@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 114, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,7004233679', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:18:12', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (319, '7004233679', NULL, '7903214726', '', '0', '', '5255', '', '', 'SHIVAM', NULL, '7903214726', 'shivam1983muz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 113, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,7004233679', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:53:49', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (320, '7992259617', NULL, '9939197125', '', '0', '', 'skdmka@@@123', '', '', 'Sanjay kumar', NULL, '9939197125', 'skdmka@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 112, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 14:10:55', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (321, '8102811241', NULL, '9852520379', '', '0', '', '9554', '', '', 'Raj Kumar', NULL, '9852520379', 'sksantoshart@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 111, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 15:51:52', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (322, '9142836671', NULL, '9773957736', '', '0', '', 'mahesh6218', '', '', 'Mahesh Pandit', NULL, '9773957736', 'maheshpandit6218@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 110, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9142836671', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 20:29:47', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (323, '6204736973', NULL, '9128372179', '', '0', '', '12345', '', '', 'suraj ojha', NULL, '9128372179', '6204736973', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 109, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,6204736973', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-02 14:17:47', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (324, '7004983144', NULL, '7739531880', '', '0', '', 'S12345', '', '', 'Kumari Seema', NULL, '7739531880', 'seemakumari02439@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 108, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-02 19:18:32', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (325, '7004983144', NULL, '7013657676', '', '0', '', 'majhaulia', '', '', 'md naushad', NULL, '7013657676', 'knaushad918@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 107, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-03 11:18:31', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (326, '8210687557', NULL, '7992282859', '', '0', '', 'B12345', '', '', 'Ravi Shankar kumar', NULL, '7992282859', '9934469875', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 106, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-04 16:35:48', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (327, '7992259617', NULL, '9431650043', '', '0', '', '1965sanjay', '', '', 'Sanjay Kumar ', NULL, '9431650043', 'sanjaykr12358@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 105, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 07:46:23', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (328, '9431650043', NULL, '8409394547', '', '0', '', 'bkranjan3155', '', '', 'Braj kishor ranjan', NULL, '8409394547', 'bkranjansjfil@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 104, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 10:56:00', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (329, '9835153380', NULL, '9939527762', '', '0', '', '12345', '', '', 'Chandrabhushan Prakash', NULL, '9939527762', 'chandrabhushan1225@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 103, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 10:56:42', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (330, '9939090087', NULL, '8210297807', '', '0', '', 'N12345', '', '', 'Niraj Kumar', NULL, '8210297807', 'putul0433@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 102, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 15:05:08', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (331, '8210297807', NULL, '8709725571', '', '0', '', 'R12345', '', '', 'RAJESH SAH', NULL, '8709725571', 'rksah97099@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 101, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087,8210297807', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 15:35:35', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (332, '7004983144', NULL, '9835229360', '', '0', '', 'R12345', '', '', 'RANJIT KUMAR', NULL, '9835229360', 'ranjitkumarahuja@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 100, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 17:57:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (333, '8936058495', NULL, '8936064895', '', '0', '', 'kumar', '', '', 'Stuti Singh', NULL, '8936064895', 'mithileshsingh18814@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 99, 0, '0', '0', '250', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 18:27:44', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (334, '8936064895', NULL, '9905222899', '', '0', '', 'kumar', '', '', 'Akshra Singh', NULL, '9905222899', 'akshrasingh2210@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 98, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 19:19:46', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (335, '7004983144', NULL, '9905739033', '', '0', '', 'R12345', '', '', 'Rajnish Kumar', NULL, '9905739033', 'rajnishkumar83455@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 97, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 20:14:33', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (336, '7004983144', NULL, '9693148039', '', '0', '', 'G12345', '', '', 'Govind Kumar', NULL, '9693148039', 'govind@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 96, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:34:01', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (337, '8084940179', NULL, '9693147039', '', '0', '', 'G12345', '', '', 'Govind Kumar', NULL, '9693147039', 'govind@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 95, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:39:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (338, '7004983144', NULL, '9142768216', '', '0', '', '630630', '', '', 'Rajput Karan', NULL, '9142768216', 'rajputkarancima@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 94, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:57:57', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (339, '9939195269', NULL, '9801211629', '', '0', '', 'B12345', '', '', 'Baba ji', NULL, '9801211629', 'babaji@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 93, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 10:38:42', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (340, '9931667459', NULL, '9939177039', '', '0', '', '8199', '', '', 'Mrityunjay Kumar', NULL, '9939177039', 'mrityunjaymuzaffarpur@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 92, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 11:54:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (341, '7004983144', NULL, '9334543228', '', '0', '', 'S12345', '', '', 'Shyam Sharma', NULL, '9334543228', 'atrisharma1@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 91, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 14:11:30', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (342, '9334543228', NULL, '9631506226', '', '0', '', 'R12345', '', '', 'Ram Sharma', NULL, '9631506226', 'ramgungun94@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 90, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334543228', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 14:19:13', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (343, '9835153380', NULL, '9576244038', '', '0', '', '12345', '', '', 'Chhotu kumar', NULL, '9576244038', '9939527762', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 89, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 17:18:42', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (344, '9431650043', NULL, '7979041485', '', '0', '', '12345', '', '', 'Pramod Kumar', NULL, '7979041485', 'pramodkumarteacher73@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 88, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 18:23:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (345, '7004983144', NULL, '8877877602', '', '0', '', 'D12345', '', '', 'Dilip Kumar Thakur', NULL, '8877877602', 'dilipthakur1234321@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 87, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 11:00:56', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (346, '7004983144', NULL, '8789420986', '', '0', '', 'phani@123', '', '', 'Phani Sinha', NULL, '8789420986', 'phanibksinha@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 86, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 15:21:22', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (347, '9905222899', NULL, '7488006584', '', '0', '', 'nihal@2002', '', '', 'Navin kumar', NULL, '7488006584', 'kantienterprisesauto@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 85, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 18:57:42', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (348, '8936064895', NULL, '9964852841', '', '0', '', '9934886341', '', '', 'Nitin Kumar', NULL, '9964852841', 'nitin3791@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 84, 0, '0', '0', '20.5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 09:36:45', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (349, '8936064895', NULL, '7541984238', '', '0', '', 'golu6004', '', '', 'Akshay Kumar', NULL, '7541984238', 'akshays1191044@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 83, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:00:48', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (350, '7541984238', NULL, '8709438362', '', '0', '', '8709438362', '', '', 'Damini kumari', NULL, '8709438362', 'kumaridamini29@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 82, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7541984238', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:04:11', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (351, '8936064895', NULL, '9334094589', '', '0', '', '123456789', '', '', 'SUDERSHAN SINGH', NULL, '9334094589', 'riya03821@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 81, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:45:09', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (352, '8936064895', NULL, '9709568770', '', '0', '', '1203', '', '', 'Arun kumar Sharma', NULL, '9709568770', 'arunkumar@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 80, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 11:16:48', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (353, '9964852841', NULL, '7069449125', '', '0', '', '9135141688', '', '', 'Nitesh kumar', NULL, '7069449125', 'kumarnitesh.npti@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 79, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9964852841', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 11:38:51', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (354, '9939090087', NULL, '9934982684', '', '0', '', 'N123456', '', '', 'Navin kumar nishad', NULL, '9934982684', 'navilflp72@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 78, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 12:36:36', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (355, '9939090087', NULL, '7324950411', '', '0', '', 'S12345', '', '', 'SHASHI RANJAN SRIVASTSVA', NULL, '7324950411', 'shashiranjanshrivastav745@gmel.come', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 77, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 13:07:06', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (356, '6386476787', NULL, '7860683831', '', '0', '', '0007', '', '', 'Amit kumar pathak', NULL, '7860683831', 'amitpathak231217@gmail.con', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 76, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:34:46', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (357, '7860683831', NULL, '8419020475', '', '0', '', '6394097561', '', '', 'Apil ', NULL, '8419020475', 'apilkumarbhuiyan@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 75, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:38:34', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (358, '8419020475', NULL, '8052330561', '', '0', '', 'rajit1234', '', '', 'Rajitram', NULL, '8052330561', 'rajitramnishad0@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 74, 0, '0', '0', '964.25', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831,8419020475', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:49:49', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (359, '7992259617', NULL, '9334904141', '', '0', '', 'p@ssword123', '', '', 'Rakesh Kumar', NULL, '9334904141', 'computer.worldmuz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 73, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 19:57:21', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (360, '9939090087', NULL, '7654353455', '', '0', '', 'Dr123456', '', '', 'Dr. Manoranjan Kumar', NULL, '7654353455', 'manoranjan1239@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 72, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:01:45', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (361, '7004983144', NULL, '9934018161', '', '0', '', 'C12345', '', '', 'Chandra Shekhar Tiwari', NULL, '9934018161', 'chandan18161@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 71, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:11:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (362, '9934018161', NULL, '9931103870', '', '0', '', 'S12345', '', '', 'RAGHVENDRA TIWARI', NULL, '9931103870', 'shwetiprabha4@g.mail', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 70, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9934018161', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:16:32', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (363, '9905222899', NULL, '9128806623', '', '0', '', '1982', '', '', 'Kapileshwar jha', NULL, '9128806623', 'kapileshwarjha1325@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 69, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 21:59:05', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (364, '6207574162', NULL, '7634039847', '', '0', '', 'N12345', '', '', 'Naval Kumar', NULL, '7634039847', 'nabaldas34@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 68, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 08:50:02', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (365, '7634039847', NULL, '9525370899', '', '0', '', 'R12345', '', '', 'Rajesh Kumar', NULL, '9525370899', 'rajesh87220@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 67, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162,7634039847', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 08:57:05', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (366, '9097027327', NULL, '7903057185', '', '0', '', 'rajput', '', '', 'Nishab kumar', NULL, '7903057185', 'rajputnishab2005@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 66, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9097027327', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 11:07:03', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (367, '9939090087', NULL, '9708853302', '', '0', '', 'bh123456', '', '', 'Bharti Mishra', NULL, '9708853302', 'bharti0302@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 65, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 16:19:57', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (368, '7004983144', NULL, '6202116564', '', '0', '', 'S12345', '', '', 'Md Shakil', NULL, '6202116564', 'mdshakil08714@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 64, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 18:01:01', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (369, '7004983144', NULL, '7488764188', '', '0', '', '129110', '', '', 'Aditya Kumar', NULL, '7488764188', 'adityakaushik12911@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 63, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 08:36:05', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (370, '9939090087', NULL, '9708491927', '', '0', '', 'guru123456', '', '', 'Ashok kumar', NULL, '9708491927', 'ashokashok32877@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 62, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 14:57:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (371, '7992259617', NULL, '6203818802', '', '0', '', 'R12345', '', '', 'Ritesh Kumar', NULL, '6203818802', 'riteshkmr83cup@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 61, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 14:59:26', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (372, '6386476787', NULL, '9792465464', '', '0', '', 'kalim7878', '', '', 'Kalim Siddiqui', NULL, '9792465464', 'kalimarfeen78@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 60, 0, '0', '0', '8.325', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 15:28:44', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (373, '7004983144', NULL, '6299907015', '', '0', '', '6299907015', '', '', 'Akshay Kumar', NULL, '6299907015', 'ak1238496@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 59, 0, '0', '0', '15.5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 22:07:20', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (374, '7488764188', NULL, '8102183836', '', '0', '', '12345', '', '', 'Ashutosh Kumar ', NULL, '8102183836', 'royalboysadi@gamsil.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 58, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,7488764188', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 08:14:13', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (375, '6386476787', NULL, '9305903970', '', '0', '', '7777777', '', '', 'Jai Prakash Kumar', NULL, '9305903970', 'jaiprakashkumar22051996@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 57, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 12:16:02', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (376, '8409394547', NULL, '7061012879', '', '0', '', '124355', '', '', 'Nidhi kumari', NULL, '7061012879', 'nidhikumari21091999@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 56, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 13:55:54', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (377, '7004983144', NULL, '8960941010', '', '0', '', 'Rahul@1993', '', '', 'Rahul Sharma', NULL, '8960941010', 'rahulsharma.srj@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 55, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:05:24', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (378, '7004983144', NULL, '7004990540', '', '0', '', 'Manish@8696', '', '', 'Vijayant Thakur', NULL, '7004990540', 'vijayantkumar15@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 54, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:54:40', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (379, '7061012879', NULL, '7352730408', '', '0', '', '124355', '', '', 'Vijay kumar', NULL, '7352730408', 'vijay.kmr1243@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 53, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547,7061012879', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:55:40', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (380, '8210179625', NULL, '9142879079', '', '0', '', 'fdsa123456', '', '', 'Rupesh kumar ', NULL, '9142879079', 'rupeshkumar.altos@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 52, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 16:13:21', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (381, '8409394547', NULL, '9162646022', '', '0', '', 'habib786', '', '', 'Md Habib Ansari', NULL, '9162646022', 'mdhansari87@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 51, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 17:04:33', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (382, '8052330561', NULL, '8299506513', '', '0', '', '8423956441', '', '', 'Amardeep kumar', NULL, '8299506513', 'amardeepkumar180@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 50, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831,8419020475,8052330561', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 17:43:36', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (383, '8409394547', NULL, '9117759250', '', '0', '', '9117759250', '', '', 'Manikant singh', NULL, '9117759250', 'manikantsinggh@Gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 49, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 18:50:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (384, '7004983144', NULL, '7667702006', '', '0', '', 'L12345', '', '', 'Lal Babu prasad singh', NULL, '7667702006', 'lalbabu995565@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 48, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 20:07:53', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (385, '9162646022', NULL, '8757470705', '', '0', '', 'ravindra@123', '', '', 'Ravindra Kumar sah', NULL, '8757470705', 'ravindrakumarsah8901@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 47, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547,9162646022', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 22:32:11', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (386, '8960941010', NULL, '7897275730', '', '0', '', '231217', '', '', 'Mannu Kumar Singh', NULL, '7897275730', 'mannukumar18592@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 46, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,8960941010', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 05:48:00', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (387, '8409394547', NULL, '8409888556', '', '0', '', '9097842091', '', '', 'Gudakesh', NULL, '8409888556', 'gudeshgupta@Gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 45, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 16:47:59', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (388, '7992259617', NULL, '9334900495', '', '0', '', 'Ranavika@1', '', '', 'Rajesh G', NULL, '9334900495', 'rajeshappan@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 44, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 17:16:55', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (389, '8936064895', NULL, '7004982268', '', '0', '', '17october', '', '', 'Nayan Prakash', NULL, '7004982268', 'nayanprakash17@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 43, 0, '0', '0', '15', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 18:48:20', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (390, '9939090087', NULL, '9122181692', '', '0', '', 'ram08146', '', '', 'Ram Kumar', NULL, '9122181692', 'ram08146@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 42, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 19:39:14', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (391, '9939090087', NULL, '6204218979', '', '0', '', 'chhoti123', '', '', 'Bhabya Bharti ', NULL, '6204218979', 'Bhabyabharti953@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 41, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 20:06:51', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (392, '7004983144', NULL, '9572683083', '', '0', '', 'tryyuvraj4587.', '', '', 'Yuvraj anand', NULL, '9572683083', 'hiyuvraj123@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 40, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 21:39:11', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (393, '9905222899', NULL, '8789620730', '', '0', '', 'anupampravin', '', '', 'Pravin kumar', NULL, '8789620730', 'annupravin8@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 39, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-13 15:01:56', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (394, '9905222899', NULL, '9113108453', '', '0', '', '7654573632', '', '', 'mukesh kumar', NULL, '9113108453', '8101991mukesh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 38, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-13 15:56:22', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (395, '9905222899', NULL, '6207063262', '', '0', '', '12345678', '', '', 'Sk Diwakar', NULL, '6207063262', 'skdiwakar58@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 37, 0, '0', '0', '2', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-13 17:10:32', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (396, '9097027327', NULL, '8210898066', '', '0', '', '875732', '', '', 'Om Prakash', NULL, '8210898066', 'rpfom104@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 36, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9097027327', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-13 17:20:12', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (397, '8936064895', NULL, '7761952639', '', '0', '', 'avantika', '', '', 'Anshika', NULL, '7761952639', 'anshikajanvi12@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 35, 0, '0', '0', '4', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-13 23:03:58', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (398, '9939090087', NULL, '6207603435', '', '0', '', 'shreya', '', '', 'Manish kumar ', NULL, '6207603435', 'manishkumar100188@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 34, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-14 10:39:30', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (399, '7004983144', NULL, '7979947530', '', '0', '', 'akashkumar', '', '', 'Akash Kumar', NULL, '7979947530', 'akashkumar842002@outlook.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 33, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-15 10:29:58', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (400, '9955659959', NULL, '8709785682', '', '0', '', 'Arvind1093@', '', '', 'Arvind Kumar Shahi ', NULL, '8709785682', 'aarvindsahi@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 32, 0, '0', '0', '490', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,9955659959', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-15 16:38:07', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (401, '7992259617', NULL, '9122323454', '', '0', '', 'sweta123', '', '', 'Sweta', NULL, '9122323454', 'swetasweta006@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 31, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-15 17:49:14', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (402, '7004983144', NULL, '9835468496', '', '0', '', 'narayan123', '', '', 'Narayan Rajpal Narayan Rajpal', NULL, '9835468496', 'narayanrajpal9805@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 30, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-15 18:46:49', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (403, '8084940179', NULL, '8102540762', '', '0', '', 'R12345', '', '', 'Rahul Kumar', NULL, '8102540762', 'rahulkumar1947124@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 29, 0, '0', '0', '4.25', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 07:32:25', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (404, '7004983144', NULL, '9939903944', '', '0', '', 'R12345', '', '', 'RAM PRAVESH SINGH', NULL, '9939903944', 'rampravesh3603@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 28, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 08:32:58', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (405, '7004983144', NULL, '8097688109', '', '0', '', 'sherpur@1980', '', '', 'Deepak Tiwari', NULL, '8097688109', 'deepak.tk80@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 27, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 08:43:49', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (406, '8936064895', NULL, '9835290303', '', '0', '', '1706', '', '', 'Subhash Kumar ', NULL, '9835290303', 'ksubhashlic@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 26, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 12:05:31', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (407, '7004983144', NULL, '9955659038', '', '0', '', 'VINA@8196', '', '', 'Vinay Singh', NULL, '9955659038', 'vinaykumarsingh9227@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 25, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 12:17:45', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (408, '7004983144', NULL, '7903237778', '', '0', '', 'Azad@123', '', '', 'MD ZAFAR AZAD', NULL, '7903237778', 'zafarazadm@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 24, 0, '0', '0', '26', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 18:25:01', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (409, '8084940179', NULL, '9304117388', '', '0', '', 'Manasangita', '', '', 'MANAS KUMAR', NULL, '9304117388', 'manaskumar2014.mk@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 23, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-16 18:41:22', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (410, '8084940179', NULL, '98351533855', '', '0', '', '12345', '', '', 'ss', NULL, '98351533855', 'ss@ss.ss', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 22, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-17 12:43:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (411, '8084940179', NULL, '7004983144', '', '0', '', '123456', '', '', 'abhishek sharma', NULL, '7004983144', 'abhisheksharma.rkt@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 21, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-17 16:28:41', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (412, '9955659038', NULL, '7903305016', '', '0', '', '306200', '', '', 'Sudhir kumar', NULL, '7903305016', 'sudhirkumarilu@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 20, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9955659038', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-17 17:54:37', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (413, '7004982268', NULL, '9308196472', '', '0', '', '1710', '', '', 'Jyotsana mani', NULL, '9308196472', 'jyotsanamani0017@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 19, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7004982268', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-17 21:16:53', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (414, '7004982268', NULL, '9565873620', '', '0', '', 'annu0026', '', '', 'Anuranjan kumar', NULL, '9565873620', 'amant7808@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 18, 0, '0', '0', '33', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7004982268', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 07:06:36', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (415, '8097688109', NULL, '7564856061', '', '0', '', 'rajpoot26', '', '', 'Binit Kumar', NULL, '7564856061', 'binitparwara@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 17, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,8097688109', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 11:00:15', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (416, '8936064895', NULL, '7060035539', '', '0', '', '35539', '', '', 'Awishkar ', NULL, '7060035539', 'awishkar10@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 16, 0, '0', '0', '20', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 14:59:30', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (417, '8936064895', NULL, '7903392008', '', '0', '', '2008', '', '', 'Sunil Kumar', NULL, '7903392008', 'Sunilkumar.muz36@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 15, 0, '0', '0', '26.2', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 16:31:09', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (418, '8936064895', NULL, '9570973635', '', '0', '', 'divya3635', '', '', 'Archana devi', NULL, '9570973635', 'divyasomyajiya@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 14, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 19:42:28', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (419, '9939090087', NULL, '9102849149', '', '0', '', 'Sippu@231292', '', '', 'Sippu Mishra', NULL, '9102849149', 'sippumisra@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 13, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 20:28:26', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (420, '7004983144', NULL, '9955980210', '', '0', '', 'S12345', '', '', 'Sushil Pandey', NULL, '9955980210', 'sushilpandey9955@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 12, 0, '0', '0', '6', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-19 09:43:21', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (421, '8936064895', NULL, '9264489691', '', '0', '', '776681', '', '', 'Pushp Ranjan', NULL, '9264489691', 'ranjanpushp02@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 11, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-19 12:57:30', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (422, '8936064895', NULL, '7047037587', '', '0', '', 'maya91335', '', '', 'Sakesh singh', NULL, '7047037587', 'sakeshsumansingh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 10, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-19 21:13:25', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (423, '8936064895', NULL, '9708106087', '', '0', '', '64895', '', '', 'Kavindra Jha', NULL, '9708106087', 'muzkavindra132@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 9, 0, '0', '0', '12.5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-20 16:28:53', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (424, '9934018161', NULL, '7004191773', '', '0', '', '9608', '', '', 'Vikram', NULL, '7004191773', 'pradeepthaur9608@.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 8, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9934018161', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-20 17:47:43', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (425, '8936064895', NULL, '8651174991', '', '0', '', '86511', '', '', 'Guddu', NULL, '8651174991', 'shashikr175@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 7, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-20 19:00:17', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (426, '8936064895', NULL, '9006997575', '', '0', '', '15august', '', '', 'Pramathnath kumar', NULL, '9006997575', 'pramathanathbkumarc13579@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 6, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-20 20:27:39', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (427, '8936064895', NULL, '9166418260', '', '0', '', 'lali2009', '', '', 'Ranjan Shahi', NULL, '9166418260', 'ranjanshahi120@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 5, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-21 15:14:20', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (428, '7004982268', NULL, '9304928494', '', '0', '', '1q2w3e4r5t6y', '', '', 'Mrinal', NULL, '9304928494', 'minukumari2621985@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 4, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7004982268', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-21 15:31:02', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (429, '7004982268', NULL, '7779911350', '', '0', '', 'deepak_1982', '', '', 'Deepak Kumar', NULL, '7779911350', 'kr.soni.11061982@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 3, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7004982268', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-21 16:42:06', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (430, '7004983144', NULL, '6207798112', '', '0', '', 'maya@321', '', '', 'Sumit Kumar', NULL, '6207798112', 'sumit.kccsl@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 2, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-21 17:56:56', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (431, '7004983144', NULL, '7079959905', '', '0', '', 'mummypapa', '', '', 'Ankit raj', NULL, '7079959905', 'ankitraj.mzf2015@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-21 17:57:01', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details1` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (432, '8936064895', NULL, '9931702474', '', '0', '', '1234', '', '', 'Prabhakar Kumar', NULL, '9931702474', 'prabhakarkr40@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-22 08:55:36', '2021-08-21 20:25:37', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');


#
# TABLE STRUCTURE FOR: districts
#

DROP TABLE IF EXISTS `districts`;

CREATE TABLE `districts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `state_id` int NOT NULL,
  `name` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=latin1;

INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (1, 1, 'North Andaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (2, 1, 'South Andaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (3, 1, 'Nicobar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (4, 2, 'Adilabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (5, 2, 'Anantapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (6, 2, 'Chittoor');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (7, 2, 'East Godavari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (8, 2, 'Guntur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (9, 2, 'Hyderabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (10, 2, 'Karimnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (11, 2, 'Khammam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (12, 2, 'Krishna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (13, 2, 'Kurnool');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (14, 2, 'Mahbubnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (15, 2, 'Medak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (16, 2, 'Nalgonda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (17, 2, 'Nizamabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (18, 2, 'Prakasam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (19, 2, 'Ranga Reddy');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (20, 2, 'Srikakulam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (21, 2, 'Sri Potti Sri Ramulu Nellore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (22, 2, 'Vishakhapatnam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (23, 2, 'Vizianagaram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (24, 2, 'Warangal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (25, 2, 'West Godavari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (26, 2, 'Cudappah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (27, 3, 'Anjaw');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (28, 3, 'Changlang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (29, 3, 'East Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (30, 3, 'East Kameng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (31, 3, 'Kurung Kumey');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (32, 3, 'Lohit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (33, 3, 'Lower Dibang Valley');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (34, 3, 'Lower Subansiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (35, 3, 'Papum Pare');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (36, 3, 'Tawang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (37, 3, 'Tirap');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (38, 3, 'Dibang Valley');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (39, 3, 'Upper Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (40, 3, 'Upper Subansiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (41, 3, 'West Kameng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (42, 3, 'West Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (43, 4, 'Baksa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (44, 4, 'Barpeta');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (45, 4, 'Bongaigaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (46, 4, 'Cachar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (47, 4, 'Chirang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (48, 4, 'Darrang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (49, 4, 'Dhemaji');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (50, 4, 'Dima Hasao');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (51, 4, 'Dhubri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (52, 4, 'Dibrugarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (53, 4, 'Goalpara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (54, 4, 'Golaghat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (55, 4, 'Hailakandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (56, 4, 'Jorhat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (57, 4, 'Kamrup');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (58, 4, 'Kamrup Metropolitan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (59, 4, 'Karbi Anglong');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (60, 4, 'Karimganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (61, 4, 'Kokrajhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (62, 4, 'Lakhimpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (63, 4, 'Morigaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (64, 4, 'Nagaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (65, 4, 'Nalbari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (66, 4, 'Sivasagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (67, 4, 'Sonitpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (68, 4, 'Tinsukia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (69, 4, 'Udalguri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (70, 5, 'Araria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (71, 5, 'Arwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (72, 5, 'Aurangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (73, 5, 'Banka');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (74, 5, 'Begusarai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (75, 5, 'Bhagalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (76, 5, 'Bhojpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (77, 5, 'Buxar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (78, 5, 'Darbhanga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (79, 5, 'East Champaran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (80, 5, 'Gaya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (81, 5, 'Gopalganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (82, 5, 'Jamui');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (83, 5, 'Jehanabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (84, 5, 'Kaimur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (85, 5, 'Katihar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (86, 5, 'Khagaria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (87, 5, 'Kishanganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (88, 5, 'Lakhisarai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (89, 5, 'Madhepura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (90, 5, 'Madhubani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (91, 5, 'Munger');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (92, 5, 'Muzaffarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (93, 5, 'Nalanda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (94, 5, 'Nawada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (95, 5, 'Patna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (96, 5, 'Purnia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (97, 5, 'Rohtas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (98, 5, 'Saharsa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (99, 5, 'Samastipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (100, 5, 'Saran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (101, 5, 'Sheikhpura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (102, 5, 'Sheohar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (103, 5, 'Sitamarhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (104, 5, 'Siwan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (105, 5, 'Supaul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (106, 6, 'Chandigarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (107, 7, 'Bastar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (108, 7, 'Bijapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (109, 7, 'Bilaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (110, 7, 'Dantewada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (111, 7, 'Dhamtari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (112, 7, 'Durg');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (113, 7, 'Jashpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (114, 7, 'Janjgir-Champa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (115, 7, 'Korba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (116, 7, 'Koriya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (117, 7, 'Kanker');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (118, 7, 'Kabirdham (formerly Kawardha)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (119, 7, 'Mahasamund');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (120, 7, 'Narayanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (121, 7, 'Raigarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (122, 7, 'Rajnandgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (123, 7, 'Raipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (124, 7, 'Surguja');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (125, 8, 'Dadra and Nagar Haveli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (126, 9, 'Daman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (127, 9, 'Diu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (128, 10, 'Central Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (129, 10, 'East Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (130, 10, 'New Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (131, 10, 'North Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (132, 10, 'North East Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (133, 10, 'North West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (134, 10, 'South Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (135, 10, 'South West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (136, 10, 'West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (137, 11, 'North Goa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (138, 11, 'South Goa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (139, 12, 'Ahmedabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (140, 12, 'Amreli district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (141, 12, 'Anand');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (142, 12, 'Banaskantha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (143, 12, 'Bharuch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (144, 12, 'Bhavnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (145, 12, 'Dahod');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (146, 12, 'The Dangs');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (147, 12, 'Gandhinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (148, 12, 'Jamnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (149, 12, 'Junagadh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (150, 12, 'Kutch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (151, 12, 'Kheda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (152, 12, 'Mehsana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (153, 12, 'Narmada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (154, 12, 'Navsari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (155, 12, 'Patan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (156, 12, 'Panchmahal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (157, 12, 'Porbandar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (158, 12, 'Rajkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (159, 12, 'Sabarkantha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (160, 12, 'Surendranagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (161, 12, 'Surat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (162, 12, 'Tapi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (163, 12, 'Vadodara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (164, 12, 'Valsad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (165, 13, 'Ambala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (166, 13, 'Bhiwani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (167, 13, 'Faridabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (168, 13, 'Fatehabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (169, 13, 'Gurgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (170, 13, 'Hissar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (171, 13, 'Jhajjar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (172, 13, 'Jind');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (173, 13, 'Karnal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (174, 13, 'Kaithal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (175, 13, 'Kurukshetra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (176, 13, 'Mahendragarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (177, 13, 'Mewat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (178, 13, 'Palwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (179, 13, 'Panchkula');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (180, 13, 'Panipat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (181, 13, 'Rewari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (182, 13, 'Rohtak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (183, 13, 'Sirsa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (184, 13, 'Sonipat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (185, 13, 'Yamuna Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (186, 14, 'Bilaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (187, 14, 'Chamba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (188, 14, 'Hamirpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (189, 14, 'Kangra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (190, 14, 'Kinnaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (191, 14, 'Kullu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (192, 14, 'Lahaul and Spiti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (193, 14, 'Mandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (194, 14, 'Shimla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (195, 14, 'Sirmaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (196, 14, 'Solan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (197, 14, 'Una');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (198, 15, 'Anantnag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (199, 15, 'Badgam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (200, 15, 'Bandipora');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (201, 15, 'Baramulla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (202, 15, 'Doda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (203, 15, 'Ganderbal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (204, 15, 'Jammu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (205, 15, 'Kargil');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (206, 15, 'Kathua');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (207, 15, 'Kishtwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (208, 15, 'Kupwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (209, 15, 'Kulgam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (210, 15, 'Leh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (211, 15, 'Poonch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (212, 15, 'Pulwama');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (213, 15, 'Rajouri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (214, 15, 'Ramban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (215, 15, 'Reasi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (216, 15, 'Samba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (217, 15, 'Shopian');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (218, 15, 'Srinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (219, 15, 'Udhampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (220, 16, 'Bokaro');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (221, 16, 'Chatra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (222, 16, 'Deoghar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (223, 16, 'Dhanbad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (224, 16, 'Dumka');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (225, 16, 'East Singhbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (226, 16, 'Garhwa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (227, 16, 'Giridih');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (228, 16, 'Godda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (229, 16, 'Gumla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (230, 16, 'Hazaribag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (231, 16, 'Jamtara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (232, 16, 'Khunti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (233, 16, 'Koderma');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (234, 16, 'Latehar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (235, 16, 'Lohardaga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (236, 16, 'Pakur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (237, 16, 'Palamu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (238, 16, 'Ramgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (239, 16, 'Ranchi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (240, 16, 'Sahibganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (241, 16, 'Seraikela Kharsawan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (242, 16, 'Simdega');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (243, 16, 'West Singhbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (244, 17, 'Bagalkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (245, 17, 'Bangalore Rural');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (246, 17, 'Bangalore Urban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (247, 17, 'Belgaum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (248, 17, 'Bellary');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (249, 17, 'Bidar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (250, 17, 'Bijapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (251, 17, 'Chamarajnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (252, 17, 'Chikkamagaluru');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (253, 17, 'Chikkaballapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (254, 17, 'Chitradurga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (255, 17, 'Davanagere');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (256, 17, 'Dharwad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (257, 17, 'Dakshina Kannada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (258, 17, 'Gadag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (259, 17, 'Gulbarga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (260, 17, 'Hassan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (261, 17, 'Haveri district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (262, 17, 'Kodagu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (263, 17, 'Kolar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (264, 17, 'Koppal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (265, 17, 'Mandya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (266, 17, 'Mysore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (267, 17, 'Raichur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (268, 17, 'Shimoga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (269, 17, 'Tumkur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (270, 17, 'Udupi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (271, 17, 'Uttara Kannada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (272, 17, 'Ramanagara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (273, 17, 'Yadgir');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (274, 18, 'Alappuzha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (275, 18, 'Ernakulam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (276, 18, 'Idukki');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (277, 18, 'Kannur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (278, 18, 'Kasaragod');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (279, 18, 'Kollam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (280, 18, 'Kottayam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (281, 18, 'Kozhikode');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (282, 18, 'Malappuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (283, 18, 'Palakkad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (284, 18, 'Pathanamthitta');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (285, 18, 'Thrissur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (286, 18, 'Thiruvananthapuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (287, 18, 'Wayanad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (288, 19, 'Lakshadweep');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (289, 20, 'Agar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (290, 20, 'Alirajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (291, 20, 'Anuppur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (292, 20, 'Ashok Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (293, 20, 'Balaghat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (294, 20, 'Barwani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (295, 20, 'Betul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (296, 20, 'Bhind');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (297, 20, 'Bhopal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (298, 20, 'Burhanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (299, 20, 'Chhatarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (300, 20, 'Chhindwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (301, 20, 'Damoh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (302, 20, 'Datia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (303, 20, 'Dewas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (304, 20, 'Dhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (305, 20, 'Dindori');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (306, 20, 'Guna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (307, 20, 'Gwalior');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (308, 20, 'Harda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (309, 20, 'Hoshangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (310, 20, 'Indore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (311, 20, 'Jabalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (312, 20, 'Jhabua');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (313, 20, 'Katni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (314, 20, 'Khandwa (East Nimar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (315, 20, 'Khargone (West Nimar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (316, 20, 'Mandla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (317, 20, 'Mandsaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (318, 20, 'Morena');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (319, 20, 'Narsinghpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (320, 20, 'Neemuch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (321, 20, 'Panna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (322, 20, 'Raisen');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (323, 20, 'Rajgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (324, 20, 'Ratlam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (325, 20, 'Rewa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (326, 20, 'Sagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (327, 20, 'Satna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (328, 20, 'Sehore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (329, 20, 'Seoni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (330, 20, 'Shahdol');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (331, 20, 'Shajapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (332, 20, 'Sheopur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (333, 20, 'Shivpuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (334, 20, 'Sidhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (335, 20, 'Singrauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (336, 20, 'Tikamgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (337, 20, 'Ujjain');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (338, 20, 'Umaria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (339, 20, 'Vidisha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (340, 21, 'Ahmednagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (341, 21, 'Akola');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (342, 21, 'Amravati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (343, 21, 'Aurangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (344, 21, 'Beed');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (345, 21, 'Bhandara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (346, 21, 'Buldhana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (347, 21, 'Chandrapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (348, 21, 'Dhule');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (349, 21, 'Gadchiroli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (350, 21, 'Gondia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (351, 21, 'Hingoli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (352, 21, 'Jalgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (353, 21, 'Jalna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (354, 21, 'Kolhapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (355, 21, 'Latur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (356, 21, 'Mumbai City');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (357, 21, 'Mumbai suburban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (358, 21, 'Nanded');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (359, 21, 'Nandurbar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (360, 21, 'Nagpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (361, 21, 'Nashik');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (362, 21, 'Osmanabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (363, 21, 'Parbhani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (364, 21, 'Pune');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (365, 21, 'Raigad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (366, 21, 'Ratnagiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (367, 21, 'Sangli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (368, 21, 'Satara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (369, 21, 'Sindhudurg');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (370, 21, 'Solapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (371, 21, 'Thane');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (372, 21, 'Wardha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (373, 21, 'Washim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (374, 21, 'Yavatmal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (375, 22, 'Bishnupur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (376, 22, 'Churachandpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (377, 22, 'Chandel');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (378, 22, 'Imphal East');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (379, 22, 'Senapati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (380, 22, 'Tamenglong');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (381, 22, 'Thoubal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (382, 22, 'Ukhrul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (383, 22, 'Imphal West');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (384, 23, 'East Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (385, 23, 'East Khasi Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (386, 23, 'Jaintia Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (387, 23, 'Ri Bhoi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (388, 23, 'South Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (389, 23, 'West Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (390, 23, 'West Khasi Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (391, 24, 'Aizawl');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (392, 24, 'Champhai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (393, 24, 'Kolasib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (394, 24, 'Lawngtlai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (395, 24, 'Lunglei');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (396, 24, 'Mamit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (397, 24, 'Saiha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (398, 24, 'Serchhip');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (399, 25, 'Dimapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (400, 25, 'Kiphire');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (401, 25, 'Kohima');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (402, 25, 'Longleng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (403, 25, 'Mokokchung');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (404, 25, 'Mon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (405, 25, 'Peren');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (406, 25, 'Phek');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (407, 25, 'Tuensang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (408, 25, 'Wokha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (409, 25, 'Zunheboto');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (410, 26, 'Angul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (411, 26, 'Boudh (Bauda)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (412, 26, 'Bhadrak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (413, 26, 'Balangir');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (414, 26, 'Bargarh (Baragarh)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (415, 26, 'Balasore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (416, 26, 'Cuttack');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (417, 26, 'Debagarh (Deogarh)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (418, 26, 'Dhenkanal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (419, 26, 'Ganjam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (420, 26, 'Gajapati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (421, 26, 'Jharsuguda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (422, 26, 'Jajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (423, 26, 'Jagatsinghpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (424, 26, 'Khordha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (425, 26, 'Kendujhar (Keonjhar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (426, 26, 'Kalahandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (427, 26, 'Kandhamal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (428, 26, 'Koraput');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (429, 26, 'Kendrapara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (430, 26, 'Malkangiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (431, 26, 'Mayurbhanj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (432, 26, 'Nabarangpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (433, 26, 'Nuapada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (434, 26, 'Nayagarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (435, 26, 'Puri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (436, 26, 'Rayagada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (437, 26, 'Sambalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (438, 26, 'Subarnapur (Sonepur)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (439, 26, 'Sundergarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (440, 27, 'Karaikal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (441, 27, 'Mahe');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (442, 27, 'Pondicherry');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (443, 27, 'Yanam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (444, 28, 'Amritsar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (445, 28, 'Barnala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (446, 28, 'Bathinda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (447, 28, 'Firozpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (448, 28, 'Faridkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (449, 28, 'Fatehgarh Sahib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (450, 28, 'Fazilka[6]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (451, 28, 'Gurdaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (452, 28, 'Hoshiarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (453, 28, 'Jalandhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (454, 28, 'Kapurthala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (455, 28, 'Ludhiana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (456, 28, 'Mansa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (457, 28, 'Moga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (458, 28, 'Sri Muktsar Sahib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (459, 28, 'Pathankot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (460, 28, 'Patiala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (461, 28, 'Rupnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (462, 28, 'Ajitgarh (Mohali)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (463, 28, 'Sangrur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (464, 28, 'Shahid Bhagat Singh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (465, 28, 'Tarn Taran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (466, 29, 'Ajmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (467, 29, 'Alwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (468, 29, 'Bikaner');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (469, 29, 'Barmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (470, 29, 'Banswara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (471, 29, 'Bharatpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (472, 29, 'Baran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (473, 29, 'Bundi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (474, 29, 'Bhilwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (475, 29, 'Churu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (476, 29, 'Chittorgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (477, 29, 'Dausa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (478, 29, 'Dholpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (479, 29, 'Dungapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (480, 29, 'Ganganagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (481, 29, 'Hanumangarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (482, 29, 'Jhunjhunu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (483, 29, 'Jalore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (484, 29, 'Jodhpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (485, 29, 'Jaipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (486, 29, 'Jaisalmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (487, 29, 'Jhalawar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (488, 29, 'Karauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (489, 29, 'Kota');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (490, 29, 'Nagaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (491, 29, 'Pali');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (492, 29, 'Pratapgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (493, 29, 'Rajsamand');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (494, 29, 'Sikar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (495, 29, 'Sawai Madhopur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (496, 29, 'Sirohi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (497, 29, 'Tonk');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (498, 29, 'Udaipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (499, 30, 'East Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (500, 30, 'North Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (501, 30, 'South Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (502, 30, 'West Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (503, 31, 'Ariyalur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (504, 31, 'Chennai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (505, 31, 'Coimbatore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (506, 31, 'Cuddalore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (507, 31, 'Dharmapuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (508, 31, 'Dindigul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (509, 31, 'Erode');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (510, 31, 'Kanchipuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (511, 31, 'Kanyakumari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (512, 31, 'Karur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (513, 31, 'Krishnagiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (514, 31, 'Madurai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (515, 31, 'Nagapattinam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (516, 31, 'Nilgiris');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (517, 31, 'Namakkal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (518, 31, 'Perambalur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (519, 31, 'Pudukkottai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (520, 31, 'Ramanathapuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (521, 31, 'Salem');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (522, 31, 'Sivaganga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (523, 31, 'Tirupur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (524, 31, 'Tiruchirappalli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (525, 31, 'Theni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (526, 31, 'Tirunelveli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (527, 31, 'Thanjavur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (528, 31, 'Thoothukudi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (529, 31, 'Tiruvallur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (530, 31, 'Tiruvarur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (531, 31, 'Tiruvannamalai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (532, 31, 'Vellore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (533, 31, 'Viluppuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (534, 31, 'Virudhunagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (535, 32, 'Dhalai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (536, 32, 'North Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (537, 32, 'South Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (538, 32, 'Khowai[7]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (539, 32, 'West Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (540, 33, 'Agra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (541, 33, 'Aligarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (542, 33, 'Allahabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (543, 33, 'Ambedkar Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (544, 33, 'Auraiya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (545, 33, 'Azamgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (546, 33, 'Bagpat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (547, 33, 'Bahraich');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (548, 33, 'Ballia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (549, 33, 'Balrampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (550, 33, 'Banda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (551, 33, 'Barabanki');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (552, 33, 'Bareilly');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (553, 33, 'Basti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (554, 33, 'Bijnor');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (555, 33, 'Budaun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (556, 33, 'Bulandshahr');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (557, 33, 'Chandauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (558, 33, 'Chhatrapati Shahuji Maharaj Nagar[8]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (559, 33, 'Chitrakoot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (560, 33, 'Deoria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (561, 33, 'Etah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (562, 33, 'Etawah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (563, 33, 'Faizabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (564, 33, 'Farrukhabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (565, 33, 'Fatehpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (566, 33, 'Firozabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (567, 33, 'Gautam Buddh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (568, 33, 'Ghaziabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (569, 33, 'Ghazipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (570, 33, 'Gonda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (571, 33, 'Gorakhpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (572, 33, 'Hamirpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (573, 33, 'Hardoi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (574, 33, 'Hathras');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (575, 33, 'Jalaun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (576, 33, 'Jaunpur district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (577, 33, 'Jhansi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (578, 33, 'Jyotiba Phule Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (579, 33, 'Kannauj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (580, 33, 'Kanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (581, 33, 'Kanshi Ram Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (582, 33, 'Kaushambi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (583, 33, 'Kushinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (584, 33, 'Lakhimpur Kheri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (585, 33, 'Lalitpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (586, 33, 'Lucknow');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (587, 33, 'Maharajganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (588, 33, 'Mahoba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (589, 33, 'Mainpuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (590, 33, 'Mathura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (591, 33, 'Mau');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (592, 33, 'Meerut');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (593, 33, 'Mirzapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (594, 33, 'Moradabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (595, 33, 'Muzaffarnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (596, 33, 'Panchsheel Nagar district (Hapur)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (597, 33, 'Pilibhit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (598, 33, 'Pratapgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (599, 33, 'Raebareli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (600, 33, 'Ramabai Nagar (Kanpur Dehat)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (601, 33, 'Rampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (602, 33, 'Saharanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (603, 33, 'Sant Kabir Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (604, 33, 'Sant Ravidas Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (605, 33, 'Shahjahanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (606, 33, 'Shamli[9]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (607, 33, 'Shravasti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (608, 33, 'Siddharthnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (609, 33, 'Sitapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (610, 33, 'Sonbhadra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (611, 33, 'Sultanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (612, 33, 'Unnao');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (613, 33, 'Varanasi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (614, 34, 'Almora');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (615, 34, 'Bageshwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (616, 34, 'Chamoli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (617, 34, 'Champawat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (618, 34, 'Dehradun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (619, 34, 'Haridwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (620, 34, 'Nainital');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (621, 34, 'Pauri Garhwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (622, 34, 'Pithoragarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (623, 34, 'Rudraprayag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (624, 34, 'Tehri Garhwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (625, 34, 'Udham Singh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (626, 34, 'Uttarkashi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (627, 35, 'Bankura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (628, 35, 'Bardhaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (629, 35, 'Birbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (630, 35, 'Cooch Behar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (631, 35, 'Dakshin Dinajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (632, 35, 'Darjeeling');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (633, 35, 'Hooghly');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (634, 35, 'Howrah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (635, 35, 'Jalpaiguri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (636, 35, 'Kolkata');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (637, 35, 'Maldah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (638, 35, 'Murshidabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (639, 35, 'Nadia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (640, 35, 'North 24 Parganas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (641, 35, 'Paschim Medinipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (642, 35, 'Purba Medinipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (643, 35, 'Purulia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (644, 35, 'South 24 Parganas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (645, 35, 'Uttar Dinajpur');


#
# TABLE STRUCTURE FOR: edd
#

DROP TABLE IF EXISTS `edd`;

CREATE TABLE `edd` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pin` int NOT NULL,
  `esd` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `edd` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `es_days` int NOT NULL,
  `es_hours` time NOT NULL,
  `ed_days` int NOT NULL,
  `ed_hours` time NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: fund_request
#

DROP TABLE IF EXISTS `fund_request`;

CREATE TABLE `fund_request` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) NOT NULL,
  `amount` float NOT NULL,
  `txnid` varchar(111) NOT NULL,
  `status` int NOT NULL,
  `msg` varchar(111) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO `fund_request` (`id`, `uid`, `amount`, `txnid`, `status`, `msg`, `addon`) VALUES (8, '1', '100', '654654654', 1, '', '2025-09-12 13:36:10');


#
# TABLE STRUCTURE FOR: fund_transfer
#

DROP TABLE IF EXISTS `fund_transfer`;

CREATE TABLE `fund_transfer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AccountName` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AccountNumber` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ifsc` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resText` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TxnId` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kush` int DEFAULT NULL,
  `wamt` float DEFAULT NULL,
  `utr` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uniq_id` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `taddon` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (1, '9876543210', 'REJECT', 'SSP Vinayak', '030605010185', 'ICIC0000306', '100', 'Withdrawal has been Rejected and Refund', '1174841041', '2025-05-06 13:41:07', 2, '8500', '', '6819c41b75805', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (2, '9876543210', 'Success', 'SSP Vinayak', '030605010185', 'ICIC0000306', '100', 'ok', '4035651911', '2025-05-06 14:06:16', 1, '8500', '46546546', '6819ca00871a2', '2025-05-07 13:15:37');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (3, '9876543210', 'REJECT', 'SSP Vinayak', '030605010185', 'ICIC0000306', '100', 'Withdrawal has been Rejected and Refund', '7428822496', '2025-05-07 13:14:22', 2, '8500', '', '681b0f565ed41', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (4, '9903382291', 'Success', 'Bikash Kumar Das', '20014673518', 'SBIN0003231', '1000', 'OK', '5063887026', '2025-07-01 15:26:51', 1, '85000', '8078040499977', '6863b0e310105', '2025-07-07 17:50:49');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (5, '8240364230', 'Success', 'Partha Bose', '40035928043', 'SBIN0016629', '2145', 'OK', '3790655912', '2025-07-03 11:27:37', 1, '182325', '785361369762', '68661bd1df779', '2025-07-07 17:45:58');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (6, '0000000017', 'Success', 'Santu Sardar', '40035928043', 'SBIN0016629', '11000', 'OK', '3790655912', '2025-07-03 11:27:37', 1, '11000', '785361369762', '68661bd1df779', '2025-07-07 17:45:58');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (7, '8240364230', 'PENDING', 'Partha Bose', '40035928043', 'SBIN0016629', '550', 'Payment is Under Proccess', '9731702479', '2025-07-23 22:27:04', 0, '46750', '', '68811460cfbee', '');


#
# TABLE STRUCTURE FOR: level
#

DROP TABLE IF EXISTS `level`;

CREATE TABLE `level` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(111) NOT NULL,
  `member` int NOT NULL,
  `dsp` int NOT NULL,
  `day` int NOT NULL,
  `amt` int NOT NULL,
  `prize` varchar(999) NOT NULL,
  `levelp` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=latin1;

INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (1, 'Beiggner', 10, 1, 30, 20, 'T-Shirt', 1);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (2, 'Runner', 60, 2, 30, 30, 'Dinner Set', 2);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (3, 'Booster', 160, 3, 30, 40, 'Mobile', 3);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (4, 'Bronze', 360, 5, 30, 90, 'LED TV', 4);


#
# TABLE STRUCTURE FOR: lottry
#

DROP TABLE IF EXISTS `lottry`;

CREATE TABLE `lottry` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lottry_no` varchar(999) NOT NULL,
  `uid` varchar(999) NOT NULL,
  `amt` varchar(999) NOT NULL,
  `lgroup` varchar(999) NOT NULL,
  `addon` varchar(999) NOT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: message
#

DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sender_id` varchar(111) NOT NULL,
  `user` varchar(111) NOT NULL,
  `pass` varchar(111) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL,
  `att` int NOT NULL,
  `dtt` int NOT NULL,
  `dutt` int NOT NULL,
  `pay` int NOT NULL,
  `sms` int NOT NULL,
  `registration` int NOT NULL,
  `enquery` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `message` (`id`, `sender_id`, `user`, `pass`, `addon`, `status`, `att`, `dtt`, `dutt`, `pay`, `sms`, `registration`, `enquery`) VALUES (1, '', '', '', '2019-07-05 07:24:00', 0, 1, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: order1
#

DROP TABLE IF EXISTS `order1`;

CREATE TABLE `order1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pname` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `size` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `mrp` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qty` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `totals` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pt` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pmode` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `mop` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `top` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `utr` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: orders1
#

DROP TABLE IF EXISTS `orders1`;

CREATE TABLE `orders1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pname` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `size` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `mrp` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pv` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qty` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `totalpv` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `totals` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tpv` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: passbook
#

DROP TABLE IF EXISTS `passbook`;

CREATE TABLE `passbook` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `type` varchar(99) DEFAULT NULL,
  `pre` varchar(11) DEFAULT NULL,
  `amount` varchar(99) NOT NULL,
  `balance` varchar(255) DEFAULT NULL,
  `date` varchar(111) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=159 DEFAULT CHARSET=latin1;

INSERT INTO `passbook` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (85, 'admin', 'Add Fund By Admin', '2025-09-12 15:43:41', 'CR', '0', '100', '100', NULL);


#
# TABLE STRUCTURE FOR: passbook1
#

DROP TABLE IF EXISTS `passbook1`;

CREATE TABLE `passbook1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `type` varchar(99) DEFAULT NULL,
  `pre` varchar(11) DEFAULT NULL,
  `amount` varchar(99) NOT NULL,
  `balance` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=latin1;

INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (1, '9876543210', 'Add Fund by Admin', '2025-05-06 12:00:00', 'CR', '0', '10000000', '10000000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (85, '9876543210', 'Activation Charge UID 0052369741', '2025-07-23 12:00:16', 'DR', '9965000', '2500', '9962500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (84, '9876543210', 'Activation Charge UID 8617712078', '2025-07-19 11:32:41', 'DR', '9967500', '2500', '9965000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (83, '9876543210', 'Activation Charge UID 9123619266', '2025-07-18 22:45:30', 'DR', '9970000', '2500', '9967500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (82, '9525225480', 'Activation Charge UID 9525225480', '2025-07-18 12:54:03', 'DR', '2500', '2500', '0');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (81, '9525225480', 'Fund add from Binance', '2025-07-18 07:23:27', 'DR', '0', '2500', '2500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (80, '0000000017', 'Activation Charge UID 9732811805', '2025-07-01 18:58:35', 'DR', '2500', '2500', '0');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (79, '0000000017', 'Self Wallet Recieve from Main ', '2025-07-01 12:57:40', 'CR', '0', '2500', '2500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (78, '9876543210', 'Activation Charge UID 8617298372', '2025-07-01 18:09:58', 'DR', '9972500', '2500', '9970000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (77, '9876543210', 'Activation Charge UID 9051778326', '2025-07-01 18:08:16', 'DR', '9975000', '2500', '9972500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (76, '9876543210', 'Activation Charge UID 8240364230', '2025-07-01 18:01:04', 'DR', '9977500', '2500', '9975000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (75, '9876543210', 'Activation Charge UID 9804624269', '2025-07-01 17:58:27', 'DR', '9980000', '2500', '9977500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (74, '9876543210', 'Activation Charge UID 8617298087', '2025-07-01 17:55:48', 'DR', '9982500', '2500', '9980000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (73, '9876543210', 'Activation Charge UID 8420245625', '2025-07-01 17:54:11', 'DR', '9985000', '2500', '9982500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (72, '9876543210', 'Activation Charge UID 6290254725', '2025-07-01 17:52:34', 'DR', '9987500', '2500', '9985000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (71, '9876543210', 'Activation Charge UID 0000000017', '2025-07-01 17:51:45', 'DR', '9990000', '2500', '9987500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (70, '9876543210', 'Activation Charge UID 0000000018', '2025-06-16 21:12:12', 'DR', '9992500', '2500', '9990000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (69, '9876543210', 'Activation Charge UID 7282076549', '2025-06-10 16:00:42', 'DR', '9995000', '2500', '9992500');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (68, '9876543210', 'Activation Charge UID 0000000006', '2025-06-10 15:43:41', 'DR', '9997500', '2500', '9995000');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`) VALUES (67, '9876543210', 'Activation Charge UID 9903382291', '2025-06-10 15:33:02', 'DR', '10000000', '2500', '9997500');


#
# TABLE STRUCTURE FOR: passbook3
#

DROP TABLE IF EXISTS `passbook3`;

CREATE TABLE `passbook3` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `type` varchar(99) DEFAULT NULL,
  `pre` varchar(11) DEFAULT NULL,
  `amount` varchar(99) NOT NULL,
  `balance` varchar(255) DEFAULT NULL,
  `date` varchar(111) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=97 DEFAULT CHARSET=latin1;

INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (1, '9876543210', 'Leadership Development Advance', '2025-05-07 14:22:21', 'DR', '0', '0', '0', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (2, '9876543210', 'Leadership Development Advance', '2025-05-07 14:23:09', 'DR', '0', '0', '0', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (3, '9304714445', 'Leadership Development Advance', '2025-05-07 14:23:09', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (4, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:23:09', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (5, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:24:47', 'CR', '-1900', '100', '-1800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (6, '9876543210', 'Leadership Development Advance', '2025-05-07 14:24:47', 'DR', '0', '0', '0', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (7, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:34:12', 'CR', '-1800', '100', '-1700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (8, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:35:24', 'CR', '-1700', '100', '-1600', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (9, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:35:45', 'CR', '-1600', '100', '-1500', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (10, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:36:02', 'CR', '-1500', '100', '-1400', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (11, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:36:19', 'CR', '-1400', '100', '-1300', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (12, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:36:41', 'CR', '-1300', '100', '-1200', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (13, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:37:01', 'CR', '-1200', '100', '-1100', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (14, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:37:28', 'CR', '-1100', '100', '-1000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (15, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:37:47', 'CR', '-1000', '100', '-900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (16, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:37:47', 'CR', '-900', '100', '-800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (17, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:38:09', 'CR', '-800', '100', '-700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (18, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:38:09', 'CR', '-700', '100', '-600', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (19, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:38:28', 'CR', '-600', '100', '-500', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (20, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:38:28', 'CR', '-500', '100', '-400', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (21, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:38:50', 'CR', '-400', '100', '-300', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (22, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:38:50', 'CR', '-300', '100', '-200', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (23, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-07 14:39:21', 'CR', '-200', '100', '-100', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (24, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:39:21', 'CR', '-100', '100', '0', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (25, '9304714445', 'Leadership Development Advance', '2025-05-07 14:40:08', 'DR', '0', '-4000', '-4000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (26, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-07 14:40:08', 'CR', '-4000', '100', '-3900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (27, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-08 11:28:18', 'CR', '-3900', '100', '-3800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (28, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-08 11:28:18', 'CR', '-3800', '100', '-3700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (29, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-08 11:32:26', 'CR', '-3700', '100', '-3600', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (30, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-08 11:32:26', 'CR', '-3600', '100', '-3500', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (31, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-12 18:17:01', 'CR', '-3500', '100', '-3400', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (32, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-12 18:18:47', 'CR', '-3400', '100', '-3300', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (33, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-12 18:18:47', 'CR', '-3300', '100', '-3200', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (34, '9304714445', 'Leadership Advance Deposit from Level Income 2', '2025-05-12 19:20:37', 'CR', '-3200', '20', '-3180', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (35, '9304714445', 'Leadership Advance Deposit from Level Income 3', '2025-05-12 19:33:35', 'CR', '-3180', '20', '-3160', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (36, '9304714445', 'Leadership Advance Deposit from Level Income 3', '2025-05-13 10:52:28', 'CR', '-3160', '20', '-3140', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (37, '5554664646', 'Leadership Development Advance', '2025-05-13 10:52:28', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (38, '5554664646', 'Leadership Advance Deposit from Matching Income', '2025-05-13 10:52:28', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (39, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-13 11:08:08', 'CR', '-3140', '100', '-3040', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (40, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-13 11:08:09', 'CR', '-3040', '100', '-2940', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (41, '9304714445', 'Leadership Advance Deposit from Level Income 2', '2025-05-15 12:08:23', 'CR', '-2940', '20', '-2920', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (42, '9304714445', 'Leadership Advance Deposit from Level Income 2', '2025-05-15 12:11:50', 'CR', '-2920', '20', '-2900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (43, '9903382291', 'Leadership Development Advance', '2025-05-15 12:11:50', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (44, '9903382291', 'Leadership Advance Deposit from Matching Income', '2025-05-15 12:11:50', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (45, '9304714445', 'Leadership Advance Deposit from Level Income 2', '2025-05-15 12:13:47', 'CR', '-2900', '20', '-2880', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (46, '9903382291', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-15 12:16:16', 'CR', '-1900', '100', '-1800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (47, '9304714445', 'Leadership Advance Deposit from Level Income 2', '2025-05-15 12:16:16', 'CR', '-2880', '20', '-2860', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (48, '9903382291', 'Leadership Advance Deposit from Matching Income', '2025-05-15 12:16:16', 'CR', '-1800', '100', '-1700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (49, '9304714445', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-05-26 11:12:22', 'CR', '-2860', '100', '-2760', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (50, '9304714445', 'Leadership Advance Deposit from Matching Income', '2025-05-26 11:12:22', 'CR', '-2760', '100', '-2660', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (51, '9903382291', 'Leadership Development Advance', '2025-06-10 16:00:42', 'DR', '-1700', '-2000', '-3700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (52, '9903382291', 'Leadership Advance Deposit from Matching Income', '2025-06-10 16:00:42', 'CR', '-3700', '100', '-3600', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (53, '9903382291', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-06-16 21:12:12', 'CR', '-3600', '100', '-3500', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (54, '9903382291', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-07-01 17:51:45', 'CR', '-3500', '100', '-3400', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (55, '9903382291', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 17:52:34', 'CR', '-3400', '20', '-3380', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (56, '9903382291', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 17:54:11', 'CR', '-3380', '20', '-3360', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (57, '0000000017', 'Leadership Development Advance', '2025-07-01 17:54:11', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (58, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 17:54:11', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (59, '0000000017', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 17:55:48', 'CR', '-1900', '20', '-1880', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (60, '9903382291', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 17:55:48', 'CR', '-3360', '20', '-3340', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (61, '0000000017', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 17:58:27', 'CR', '-1880', '20', '-1860', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (62, '9903382291', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 17:58:27', 'CR', '-3340', '20', '-3320', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (63, '8420245625', 'Leadership Development Advance', '2025-07-01 17:58:27', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (64, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 17:58:27', 'CR', '-1860', '100', '-1760', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (65, '8420245625', 'Leadership Advance Deposit from Matching Income', '2025-07-01 17:58:27', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (66, '8420245625', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-07-01 18:01:04', 'CR', '-1900', '100', '-1800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (67, '0000000017', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 18:01:04', 'CR', '-1760', '20', '-1740', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (68, '9903382291', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 18:01:04', 'CR', '-3320', '20', '-3300', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (69, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 18:01:04', 'CR', '-1740', '100', '-1640', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (70, '8420245625', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 18:08:16', 'CR', '-1800', '20', '-1780', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (71, '0000000017', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 18:08:16', 'CR', '-1640', '20', '-1620', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (72, '9903382291', 'Leadership Advance Deposit from Level Income 4', '2025-07-01 18:08:16', 'CR', '-3300', '12', '-3288', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (73, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 18:08:16', 'CR', '-1620', '100', '-1520', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (74, '8420245625', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 18:09:58', 'CR', '-1780', '20', '-1760', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (75, '0000000017', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 18:09:58', 'CR', '-1520', '20', '-1500', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (76, '9903382291', 'Leadership Advance Deposit from Level Income 4', '2025-07-01 18:09:58', 'CR', '-3288', '12', '-3276', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (77, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 18:09:58', 'CR', '-1500', '100', '-1400', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (78, '8420245625', 'Leadership Advance Deposit from Level Income 2', '2025-07-01 18:58:35', 'CR', '-1760', '20', '-1740', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (79, '0000000017', 'Leadership Advance Deposit from Level Income 3', '2025-07-01 18:58:35', 'CR', '-1400', '20', '-1380', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (80, '9903382291', 'Leadership Advance Deposit from Level Income 4', '2025-07-01 18:58:35', 'CR', '-3276', '12', '-3264', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (81, '8240364230', 'Leadership Development Advance', '2025-07-01 18:58:35', 'DR', '0', '-2000', '-2000', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (82, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-01 18:58:35', 'CR', '-1380', '100', '-1280', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (83, '8240364230', 'Leadership Advance Deposit from Matching Income', '2025-07-01 18:58:35', 'CR', '-2000', '100', '-1900', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (84, '9903382291', 'Leadership Advance Deposit from Level Income 2', '2025-07-18 12:54:03', 'CR', '-3264', '20', '-3244', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (85, '8240364230', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-07-18 22:45:30', 'CR', '-1900', '100', '-1800', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (86, '8420245625', 'Leadership Advance Deposit from Level Income 2', '2025-07-18 22:45:30', 'CR', '-1740', '20', '-1720', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (87, '0000000017', 'Leadership Advance Deposit from Level Income 3', '2025-07-18 22:45:30', 'CR', '-1280', '20', '-1260', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (88, '9903382291', 'Leadership Advance Deposit from Level Income 4', '2025-07-18 22:45:30', 'CR', '-3244', '12', '-3232', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (89, '9903382291', 'Leadership Advance Deposit from Matching Income', '2025-07-18 22:45:30', 'CR', '-3232', '100', '-3132', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (90, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-18 22:45:30', 'CR', '-1260', '100', '-1160', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (91, '8240364230', 'Leadership Advance Deposit from Direct Sponsor Income', '2025-07-19 11:32:41', 'CR', '-1800', '100', '-1700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (92, '8420245625', 'Leadership Advance Deposit from Level Income 2', '2025-07-19 11:32:41', 'CR', '-1720', '20', '-1700', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (93, '0000000017', 'Leadership Advance Deposit from Level Income 3', '2025-07-19 11:32:41', 'CR', '-1160', '20', '-1140', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (94, '9903382291', 'Leadership Advance Deposit from Level Income 4', '2025-07-19 11:32:41', 'CR', '-3132', '12', '-3120', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (95, '0000000017', 'Leadership Advance Deposit from Matching Income', '2025-07-19 11:32:41', 'CR', '-1140', '100', '-1040', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `addon`, `type`, `pre`, `amount`, `balance`, `date`) VALUES (96, '8240364230', 'Leadership Advance Deposit from Matching Income', '2025-07-23 12:00:16', 'CR', '-1700', '100', '-1600', NULL);


#
# TABLE STRUCTURE FOR: passbook4
#

DROP TABLE IF EXISTS `passbook4`;

CREATE TABLE `passbook4` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `debit` float DEFAULT NULL,
  `credit` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `status` int DEFAULT NULL,
  `pstatus` int DEFAULT NULL,
  `pdate` varchar(55) NOT NULL,
  `product` varchar(99) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `mob` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `t_ad` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amt` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `txnid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: payout
#

DROP TABLE IF EXISTS `payout`;

CREATE TABLE `payout` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int NOT NULL,
  `day` int NOT NULL,
  `day2` int NOT NULL,
  `level` int NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payout1
#

DROP TABLE IF EXISTS `payout1`;

CREATE TABLE `payout1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int NOT NULL,
  `day` int NOT NULL,
  `day2` int NOT NULL,
  `level` varchar(111) DEFAULT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payout2
#

DROP TABLE IF EXISTS `payout2`;

CREATE TABLE `payout2` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int NOT NULL,
  `day` int NOT NULL,
  `day2` int NOT NULL,
  `level` varchar(111) DEFAULT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int NOT NULL,
  `fuid` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: paytm
#

DROP TABLE IF EXISTS `paytm`;

CREATE TABLE `paytm` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `order_id` varchar(999) NOT NULL,
  `mode` varchar(999) NOT NULL,
  `amt` varchar(999) NOT NULL,
  `status` int NOT NULL,
  `addon` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: paytm1
#

DROP TABLE IF EXISTS `paytm1`;

CREATE TABLE `paytm1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `coupon_id` varchar(999) NOT NULL,
  `coupon_discount` varchar(999) NOT NULL,
  `discount_type` varchar(999) NOT NULL,
  `tpv` varchar(999) NOT NULL,
  `otp_verify` varchar(999) NOT NULL,
  `order_id` varchar(999) NOT NULL,
  `mode` varchar(999) NOT NULL,
  `amt` varchar(999) NOT NULL,
  `status` int NOT NULL,
  `addon` varchar(999) NOT NULL,
  `product_array` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `paytm1` (`id`, `uid`, `coupon_id`, `coupon_discount`, `discount_type`, `tpv`, `otp_verify`, `order_id`, `mode`, `amt`, `status`, `addon`, `product_array`) VALUES (1, '347', '', '', '', '1', '', 'ORDS38077898', '', '2499', 0, '2025-05-30 12:57:35', '[{\"productId\":\"1247\",\"cart_p_id\":1,\"cart_size_id\":\"247\",\"cart_color_id\":\"\",\"p_pv\":\"1\",\"cart_color_name\":\"\",\"qty_id\":null,\"cart_size_name\":\"1 Piece\",\"cart_p_qty\":\"1\",\"stock_qty\":108,\"cart_p_current_price\":\"2500\",\"cart_p_old_price\":\"3000\",\"cart_p_name\":\"01-SPPVINAYAK CORT PANT\",\"image\":\"Product_1.jpg\"}]');
INSERT INTO `paytm1` (`id`, `uid`, `coupon_id`, `coupon_discount`, `discount_type`, `tpv`, `otp_verify`, `order_id`, `mode`, `amt`, `status`, `addon`, `product_array`) VALUES (2, '324', '', '', '', '1', '', 'ORDS89968009', '', '2499', 0, '2025-05-31 08:14:39', '[{\"productId\":\"1247\",\"cart_p_id\":1,\"cart_size_id\":\"247\",\"cart_color_id\":\"\",\"p_pv\":\"1\",\"cart_color_name\":\"\",\"qty_id\":\"0\",\"cart_size_name\":\"1 Piece\",\"cart_p_qty\":\"1\",\"stock_qty\":106,\"cart_p_current_price\":\"2500\",\"cart_p_old_price\":\"3000\",\"cart_p_name\":\"01-SPPVINAYAK CORT PANT\",\"image\":\"Product_1.jpg\"}]');


#
# TABLE STRUCTURE FOR: plan
#

DROP TABLE IF EXISTS `plan`;

CREATE TABLE `plan` (
  `id` int NOT NULL AUTO_INCREMENT,
  `plan_b` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_c` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_d` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan2` int NOT NULL,
  `plan3` int NOT NULL,
  `plan4` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `plan` (`id`, `plan_b`, `plan_c`, `plan_d`, `plan2`, `plan3`, `plan4`) VALUES (1, '', '', '', 1, 1, 1);


#
# TABLE STRUCTURE FOR: product
#

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `p_name` varchar(111) NOT NULL,
  `mrp` varchar(111) NOT NULL,
  `pv` varchar(111) NOT NULL,
  `sponsor` varchar(111) NOT NULL,
  `capping` int NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(111) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO `product` (`id`, `p_name`, `mrp`, `pv`, `sponsor`, `capping`, `addon`, `type`, `status`) VALUES (14, 'Coat Pant', '2500', '1', '10', 80, '2020-05-20 19:30:08', 'Type 1', 0);


#
# TABLE STRUCTURE FOR: products
#

DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pname` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `size` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `mrp` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` int NOT NULL,
  `pv` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: pv
#

DROP TABLE IF EXISTS `pv`;

CREATE TABLE `pv` (
  `id` int NOT NULL AUTO_INCREMENT,
  `plan` varchar(999) DEFAULT NULL,
  `uid` varchar(999) DEFAULT NULL,
  `pv` float DEFAULT NULL,
  `date` varchar(999) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (1, NULL, '9903382291', '1', '10-06-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (2, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (3, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (4, NULL, '8420245625', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (5, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (6, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (7, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (8, NULL, '0000000017', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (9, NULL, '8240364230', '1', '01-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (10, NULL, '9903382291', '1', '18-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (11, NULL, '0000000017', '81', '18-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (12, NULL, '0000000017', '1', '19-07-2025', NULL);
INSERT INTO `pv` (`id`, `plan`, `uid`, `pv`, `date`, `status`) VALUES (13, NULL, '8240364230', '2', '23-07-2025', NULL);


#
# TABLE STRUCTURE FOR: pv_report
#

DROP TABLE IF EXISTS `pv_report`;

CREATE TABLE `pv_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(99) NOT NULL,
  `tlm` varchar(99) NOT NULL,
  `trm` varchar(99) NOT NULL,
  `addon` varchar(99) NOT NULL,
  `date` varchar(99) NOT NULL,
  `from_id` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: recharge
#

DROP TABLE IF EXISTS `recharge`;

CREATE TABLE `recharge` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `number` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oprator` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rrmarks` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txnid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bal` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `oid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: records
#

DROP TABLE IF EXISTS `records`;

CREATE TABLE `records` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `total` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: reward
#

DROP TABLE IF EXISTS `reward`;

CREATE TABLE `reward` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `reward` varchar(999) NOT NULL,
  `level` int NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: royality
#

DROP TABLE IF EXISTS `royality`;

CREATE TABLE `royality` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `date` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (1, '9304714445', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (2, '9906382291', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (3, '9996348666', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (4, '7857584499', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (5, '4653245688', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (6, '7568859595', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (7, '7686868868', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (8, '8575757858', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (9, '8756758955', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (10, '4536768776', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (11, '6875889898', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (12, '9875870998', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (13, '9587685998', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (14, '8578509859', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (15, '8976878958', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (16, '9878659897', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (17, '8798095644', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (18, '8765758955', '07-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (19, '7646768979', '08-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (20, '9876658970', '08-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (21, '9903382291', '12-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (22, '9876978555', '12-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (23, '5554664646', '12-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (24, '5758464666', '12-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (25, '8846464466', '13-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (26, '7565858049', '13-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (27, '123456789', '15-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (28, '9630000000', '15-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (29, '8856886658', '15-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (30, '9800000000', '15-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (31, '9878958655', '26-05-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (32, '9903382291', '10-06-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (33, '0000000006', '10-06-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (34, '7282076549', '10-06-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (35, '0000000018', '16-06-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (36, '0000000017', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (37, '6290254725', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (38, '8420245625', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (39, '8617298087', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (40, '9804624269', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (41, '8240364230', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (42, '9051778326', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (43, '8617298372', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (44, '9732811805', '01-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (45, '9525225480', '18-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (46, '9123619266', '18-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (47, '8617712078', '19-07-2025', 0);
INSERT INTO `royality` (`id`, `uid`, `date`, `status`) VALUES (48, '0052369741', '23-07-2025', 0);


#
# TABLE STRUCTURE FOR: staff_bill_list
#

DROP TABLE IF EXISTS `staff_bill_list`;

CREATE TABLE `staff_bill_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_payment
#

DROP TABLE IF EXISTS `staff_payment`;

CREATE TABLE `staff_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `payid` varchar(999) DEFAULT NULL,
  `pre_amt` varchar(999) DEFAULT NULL,
  `paid` varchar(999) DEFAULT NULL,
  `dues` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_stock
#

DROP TABLE IF EXISTS `staff_stock`;

CREATE TABLE `staff_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `tps` int DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_stock_list
#

DROP TABLE IF EXISTS `staff_stock_list`;

CREATE TABLE `staff_stock_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) DEFAULT NULL,
  `user_id` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` int DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: state
#

DROP TABLE IF EXISTS `state`;

CREATE TABLE `state` (
  `StateID` int NOT NULL AUTO_INCREMENT,
  `CountryID` int NOT NULL,
  `StateName` varchar(50) NOT NULL,
  `Notes` longtext,
  `ChangedBy` varchar(50) DEFAULT NULL,
  `ChangeDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`StateID`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=latin1;

INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (36, 1, 'ANDHRA PRADESH', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (37, 1, 'ASSAM', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (38, 1, 'ARUNACHAL PRADESH', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (39, 1, 'GUJRAT', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (40, 1, 'BIHAR', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (41, 1, 'HARYANA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (42, 1, 'HIMACHAL PRADESH', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (43, 1, 'JAMMU & KASHMIR', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (44, 1, 'KARNATAKA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (45, 1, 'KERALA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (46, 1, 'MADHYA PRADESH', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (47, 1, 'MAHARASHTRA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (48, 1, 'MANIPUR', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (49, 1, 'MEGHALAYA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (50, 1, 'MIZORAM', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (51, 1, 'NAGALAND', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (52, 1, 'ORISSA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (53, 1, 'PUNJAB', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (54, 1, 'RAJASTHAN', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (55, 1, 'SIKKIM', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (56, 1, 'TAMIL NADU', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (57, 1, 'TRIPURA', NULL, 'Nieanjan', '2020-01-18 15:05:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (58, 1, 'UTTAR PRADESH', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (59, 1, 'WEST BENGAL', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (60, 1, 'DELHI', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (61, 1, 'GOA', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (62, 1, 'PONDICHERY', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (63, 1, 'LAKSHDWEEP', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (64, 1, 'DAMAN & DIU', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (65, 1, 'DADRA & NAGAR', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (66, 1, 'CHANDIGARH', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (67, 1, 'ANDAMAN & NICOBAR', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (68, 1, 'UTTARANCHAL', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (69, 1, 'JHARKHAND', NULL, 'Nieanjan', '2020-01-18 15:05:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (70, 1, 'CHATTISGARH', NULL, 'Nieanjan', '2020-01-18 15:05:38');


#
# TABLE STRUCTURE FOR: tbl_ad_slider
#

DROP TABLE IF EXISTS `tbl_ad_slider`;

CREATE TABLE `tbl_ad_slider` (
  `id` int NOT NULL AUTO_INCREMENT,
  `link` varchar(999) NOT NULL,
  `title` varchar(111) NOT NULL,
  `img` varchar(999) NOT NULL,
  `other` varchar(999) NOT NULL,
  `addon` datetime NOT NULL,
  `updt` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_ad_slider` (`id`, `link`, `title`, `img`, `other`, `addon`, `updt`, `status`) VALUES (3, '#', '#', 'ad_slider-3-250505221037.JPG', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO `tbl_ad_slider` (`id`, `link`, `title`, `img`, `other`, `addon`, `updt`, `status`) VALUES (4, '#', '#', 'ad_slider-4-250505221317.JPG', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);


#
# TABLE STRUCTURE FOR: tbl_advertisement
#

DROP TABLE IF EXISTS `tbl_advertisement`;

CREATE TABLE `tbl_advertisement` (
  `adv_id` int NOT NULL AUTO_INCREMENT,
  `adv_location` varchar(255) NOT NULL,
  `adv_type` varchar(100) NOT NULL,
  `adv_photo` varchar(255) NOT NULL,
  `adv_url` varchar(255) NOT NULL,
  `adv_adsense_code` text NOT NULL,
  PRIMARY KEY (`adv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_career
#

DROP TABLE IF EXISTS `tbl_career`;

CREATE TABLE `tbl_career` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cv` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_category
#

DROP TABLE IF EXISTS `tbl_category`;

CREATE TABLE `tbl_category` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) NOT NULL,
  `category_slug` varchar(255) NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_cibil
#

DROP TABLE IF EXISTS `tbl_cibil`;

CREATE TABLE `tbl_cibil` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(111) NOT NULL,
  `full_name` varchar(111) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `mobile` varchar(111) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `pan` varchar(111) NOT NULL,
  `dob` varchar(111) NOT NULL,
  `address` varchar(255) NOT NULL,
  `pincode` varchar(111) NOT NULL,
  `response` longtext,
  `txnid` varchar(111) NOT NULL,
  `status` int NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO `tbl_cibil` (`id`, `user_id`, `full_name`, `mobile`, `pan`, `dob`, `address`, `pincode`, `response`, `txnid`, `status`, `addon`) VALUES (2, '1', 'Lov Prakash', '9835153380', 'CBZPP2003E', '1993-06-08', 'Mahamadpur Dariya', '844118', '{\"status\":\"SUCCESS\",\"statusCode\":\"200\",\"panNumber\":\"CBZPP2003E\",\"cibilReport\":{\"statuscode\":200,\"status\":true,\"message\":\"Credit Report fetched successfully\",\"reference_id\":75628280,\"data\":{\"cCRResponse\":{\"status\":\"1\",\"cIRReportDataLst\":[{\"cIRReportData\":{\"iDAndContactInfo\":{\"personalInfo\":{\"name\":{\"fullName\":\"LOV PRAKASH \",\"firstName\":\"LOV \",\"middleName\":\"PRAKASH \"},\"dateOfBirth\":\"1993-06-08\",\"gender\":\"Male\",\"age\":{\"age\":\"32\"}},\"identityInfo\":{\"pANId\":[{\"seq\":\"1\",\"reportedDate\":\"2025-08-23\",\"idNumber\":\"CBZPP2003E\"}],\"nationalIDCard\":[{\"seq\":\"1\",\"reportedDate\":\"2024-11-30\",\"idNumber\":\"XXXXXXXXXXXX\"}],\"otherId\":[{\"seq\":\"1\",\"reportedDate\":\"2025-06-30\",\"idNumber\":\"50035440778495\"}]},\"addressInfo\":[{\"seq\":\"1\",\"reportedDate\":\"2025-08-15\",\"address\":\"MAHMADPUR DARIYA GORAUL GORAUL VAISHALI BIHAR PRIMARY SCHOOL  MOHAMMADPUR\",\"state\":\"BR\",\"postal\":\"844118\",\"type\":\"Primary\"},{\"seq\":\"2\",\"reportedDate\":\"2025-02-28\",\"address\":\"S/O RAMASHISH PRASAD SINGH MAHMADPUR DARIYA GORAUL VAISHALI GORAUL 2633 BIHAR\",\"state\":\"BR\",\"postal\":\"844118\",\"type\":\"Permanent\"},{\"seq\":\"3\",\"reportedDate\":\"2025-01-31\",\"address\":\"S/O RAMASHISH PRASAD SINGH WARD  NO 10 MAHMADPUR DARIYA  NEAR JAGDAMBBA ASTHAN BIHAR 844118\",\"state\":\"BR\",\"postal\":\"844118\",\"type\":\"Primary\"},{\"seq\":\"4\",\"reportedDate\":\"2024-12-31\",\"address\":\"MAHMADPUR DARIYA GORAUL GORAUL VAISHALI BIHAR PRIMARY SCHOOL  MOHAMMADPUR\",\"state\":\"BR\",\"postal\":\"844118\",\"type\":\"Primary\"},{\"seq\":\"5\",\"reportedDate\":\"2024-05-31\",\"address\":\"S/O RAMASHISH PRASAD SINGH MAHMADPUR DARIYA VAISHALIDURGA MANDIR\",\"state\":\"BR\",\"postal\":\"844118\",\"type\":\"Primary\"}],\"phoneInfo\":[{\"seq\":\"1\",\"typeCode\":\"H\",\"reportedDate\":\"2025-08-23\",\"number\":\"9835153380\"},{\"seq\":\"2\",\"typeCode\":\"M\",\"reportedDate\":\"2025-08-15\",\"number\":\"9835153380\"},{\"seq\":\"3\",\"typeCode\":\"M\",\"reportedDate\":\"2024-11-30\",\"number\":\"919835153380\"}],\"emailAddressInfo\":[{\"seq\":\"1\",\"reportedDate\":\"2023-09-30\",\"emailAddress\":\"LOVPRAKASH03@GMAIL.COM\"}]},\"retailAccountDetails\":[{\"seq\":\"1\",\"accountNumber\":\"XXXXXXXXXXXX1996\",\"institution\":\"Cholamandalam Investment and Finance Co. Ltd.\",\"accountType\":\"Housing Loan\",\"ownershipType\":\"Individual\",\"balance\":\"1296970\",\"pastDueAmount\":\"0\",\"lastPayment\":\"20356\",\"open\":\"Yes\",\"sanctionAmount\":\"1300000\",\"lastPaymentDate\":\"2025-09-09\",\"dateReported\":\"2025-09-09\",\"dateOpened\":\"2025-07-31\",\"interestRate\":\"16.00\",\"repaymentTenure\":\"144\",\"installmentAmount\":\"20356\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Current Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"09-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-25\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"2\",\"accountNumber\":\"XXXXXXXXXXX1669\",\"institution\":\"Axis Bank\",\"accountType\":\"Kisan Credit Card\",\"ownershipType\":\"Individual\",\"balance\":\"28495\",\"pastDueAmount\":\"0\",\"open\":\"Yes\",\"sanctionAmount\":\"30000\",\"lastPaymentDate\":\"2025-07-02\",\"dateReported\":\"2025-08-31\",\"dateOpened\":\"2022-10-28\",\"termFrequency\":\"Semiannually\",\"collateralValue\":\"30000\",\"accountStatus\":\"Current Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"08-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"01+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-22\",\"paymentStatus\":\"01+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-22\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"3\",\"accountNumber\":\"XXXXXXXXXXX1656\",\"institution\":\"Axis Bank\",\"accountType\":\"Kisan Credit Card\",\"ownershipType\":\"Individual\",\"balance\":\"2178277\",\"pastDueAmount\":\"138277\",\"open\":\"Yes\",\"sanctionAmount\":\"2040000\",\"lastPaymentDate\":\"2025-07-31\",\"dateReported\":\"2025-08-31\",\"dateOpened\":\"2022-10-28\",\"termFrequency\":\"Semiannually\",\"collateralValue\":\"3187250\",\"collateralType\":\"Property\",\"accountStatus\":\"120-179 days past due\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"08-25\",\"paymentStatus\":\"120+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-25\",\"paymentStatus\":\"90+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-25\",\"paymentStatus\":\"60+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-25\",\"paymentStatus\":\"30+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-22\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"4\",\"accountNumber\":\"XXXXXXXXXXXXX6151\",\"institution\":\"IDFC FIRST Bank Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"lastPayment\":\"354\",\"open\":\"No\",\"sanctionAmount\":\"6000\",\"lastPaymentDate\":\"2023-01-01\",\"dateReported\":\"2025-02-28\",\"dateOpened\":\"2022-11-27\",\"dateClosed\":\"2025-02-06\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"84\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"02-25\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-25\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-24\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-24\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-24\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-22\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"5\",\"accountNumber\":\"XXXXXXXXXX2665\",\"institution\":\"Bajaj Finance Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"50000\",\"lastPaymentDate\":\"2024-12-30\",\"dateReported\":\"2025-02-15\",\"dateOpened\":\"2024-05-05\",\"dateClosed\":\"2024-12-30\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"12\",\"installmentAmount\":\"4167\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"02-25\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-25\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"6\",\"accountNumber\":\"XXXXXXXXXX4195\",\"institution\":\"Bajaj Finance Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"2998\",\"lastPaymentDate\":\"2024-12-30\",\"dateReported\":\"2025-02-15\",\"dateOpened\":\"2024-10-16\",\"dateClosed\":\"2024-12-30\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"3\",\"installmentAmount\":\"1000\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"02-25\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-25\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"7\",\"accountNumber\":\"XXXXXXXXX5047\",\"institution\":\"DMI Finance Private Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"writeOffAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"44996\",\"dateReported\":\"2024-12-31\",\"dateOpened\":\"2023-08-16\",\"dateClosed\":\"2024-12-31\",\"reason\":\"Closed or Paid Account/Zero Balance\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"12-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"8\",\"accountNumber\":\"XXXXXXXXXX2669\",\"institution\":\"Bajaj Finance Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"999\",\"lastPaymentDate\":\"2024-12-30\",\"dateReported\":\"2024-12-31\",\"dateOpened\":\"2024-05-05\",\"dateClosed\":\"2024-12-30\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"8\",\"installmentAmount\":\"125\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"12-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-24\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-24\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"9\",\"accountNumber\":\"XXXXXX8340\",\"institution\":\"Dhani Loans and Services Limited\",\"accountType\":\"Personal Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"15000\",\"lastPaymentDate\":\"2022-01-13\",\"dateReported\":\"2024-10-31\",\"dateOpened\":\"2022-01-01\",\"dateClosed\":\"2022-01-13\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"3\",\"accountStatus\":\"Closed Account\",\"assetClassification\":\"Standard\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"10-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"09-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"08-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"07-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"06-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"05-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"04-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"03-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-24\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"08-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"07-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"06-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"05-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"04-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"09-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"08-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"07-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"06-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"05-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"04-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"03-22\",\"paymentStatus\":\"STD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-22\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-21\",\"paymentStatus\":\"01+\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"}]},{\"seq\":\"10\",\"accountNumber\":\"XXXXXXXXXX0502\",\"institution\":\"Bajaj Finance Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"68999\",\"lastPaymentDate\":\"2023-08-02\",\"dateReported\":\"2023-10-31\",\"dateOpened\":\"2022-12-21\",\"dateClosed\":\"2023-09-27\",\"reason\":\"Closed Account\",\"repaymentTenure\":\"9\",\"installmentAmount\":\"7667\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"10-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"09-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"08-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"07-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"06-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"05-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"04-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-23\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-23\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-22\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"11\",\"accountNumber\":\"XXXXXXXXXX3443\",\"institution\":\"Bandhan Bank Limited\",\"accountType\":\"Microfinance - Business Loan\",\"ownershipType\":\"Joint Account\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"220000\",\"lastPaymentDate\":\"2022-10-28\",\"dateReported\":\"2023-03-31\",\"dateOpened\":\"2021-10-22\",\"dateClosed\":\"2022-10-28\",\"reason\":\"Closed Account\",\"interestRate\":\"19.00\",\"repaymentTenure\":\"24\",\"installmentAmount\":\"11140\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"assetClassification\":\"Standard\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"03-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-23\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"09-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"08-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"07-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"06-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"05-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"04-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"03-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-21\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"}]},{\"seq\":\"12\",\"accountNumber\":\"XXXXXX0087\",\"institution\":\"Home Credit India Finance Private Limited\",\"accountType\":\"Consumer Loan\",\"ownershipType\":\"Individual\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"12471\",\"lastPaymentDate\":\"2022-04-06\",\"dateReported\":\"2022-04-30\",\"dateOpened\":\"2021-10-05\",\"dateClosed\":\"2022-04-06\",\"reason\":\"Closed Account\",\"termFrequency\":\"Monthly\",\"accountStatus\":\"Closed Account\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"04-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"03-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"02-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-22\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"12-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"11-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"10-21\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"}]},{\"seq\":\"13\",\"accountNumber\":\"XXXXXXXXXX6188\",\"institution\":\"Bandhan Bank Limited\",\"accountType\":\"Microfinance - Business Loan\",\"ownershipType\":\"Joint Account\",\"balance\":\"0\",\"pastDueAmount\":\"0\",\"open\":\"No\",\"sanctionAmount\":\"140000\",\"lastPaymentDate\":\"2021-10-20\",\"dateReported\":\"2022-03-31\",\"dateOpened\":\"2020-12-24\",\"dateClosed\":\"2021-10-20\",\"reason\":\"Closed Account\",\"interestRate\":\"18.00\",\"repaymentTenure\":\"12\",\"installmentAmount\":\"12835\",\"accountStatus\":\"Closed Account\",\"assetClassification\":\"Standard\",\"source\":\"INDIVIDUAL\",\"history48Months\":[{\"key\":\"03-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-22\",\"paymentStatus\":\"*\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"*\"},{\"key\":\"01-22\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"12-21\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"11-21\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"10-21\",\"paymentStatus\":\"CLSD\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"09-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"08-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"07-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"06-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"05-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"04-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"03-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"02-21\",\"paymentStatus\":\"000\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"},{\"key\":\"01-21\",\"paymentStatus\":\"NEW\",\"suitFiledStatus\":\"*\",\"assetClassificationStatus\":\"STD\"}]}],\"retailAccountsSummary\":{\"noOfAccounts\":\"13\",\"noOfActiveAccounts\":\"3\",\"noOfWriteOffs\":\"0\",\"totalPastDue\":\"138277.00\",\"mostSevereStatusWithIn24Months\":\"120+\",\"singleHighestCredit\":\"0.00\",\"singleHighestSanctionAmount\":\"2040000.00\",\"totalHighCredit\":\"0.00\",\"averageOpenBalance\":\"1167914.00\",\"singleHighestBalance\":\"2178277.00\",\"noOfPastDueAccounts\":\"1\",\"noOfZeroBalanceAccounts\":\"0\",\"recentAccount\":\"Housing Loan on 31-07-2025\",\"oldestAccount\":\"Microfinance - Business Loan on 24-12-2020\",\"totalBalanceAmount\":\"3503742.00\",\"totalSanctionAmount\":\"3370000.00\",\"totalCreditLimit\":\"0.0\",\"totalMonthlyPaymentAmount\":\"20356.00\"},\"scoreDetails\":[{\"type\":\"ERS\",\"version\":\"4.0\",\"name\":\"ERS4.0\",\"value\":\"532\",\"scoringElements\":[{\"type\":\"RES\",\"seq\":\"1\",\"code\":\"400\",\"description\":\"Occurances of default account\"},{\"type\":\"RES\",\"seq\":\"2\",\"code\":\"402\",\"description\":\"Overdue Amount\"},{\"type\":\"RES\",\"seq\":\"3\",\"code\":\"401\",\"description\":\"Vintage in Bureau\"}]}],\"enquirySummary\":{\"purpose\":\"ALL\",\"total\":\"1\",\"past30Days\":\"0\",\"past12Months\":\"0\",\"past24Months\":\"0\",\"recent\":\"2021-07-09\"},\"otherKeyInd\":{\"ageOfOldestTrade\":\"57\",\"numberOfOpenTrades\":\"3\",\"allLinesEVERWritten\":\"0.00\",\"allLinesEVERWrittenIn9Months\":\"0\",\"allLinesEVERWrittenIn6Months\":\"0\"},\"recentActivities\":{\"accountsDeliquent\":\"1\",\"accountsOpened\":\"1\",\"totalInquiries\":\"0\",\"accountsUpdated\":\"3\"}}}]},\"reportOrderNumber\":\"2145156621\"}},\"bankTxnStatus\":\"true\",\"partner_id\":\"ARNPY17576579369591\",\"clientData\":{\"client_id\":\"CYc0377788b7ea4b2\"}}', '58801953', 1, '2025-09-12 11:49:00');


#
# TABLE STRUCTURE FOR: tbl_color
#

DROP TABLE IF EXISTS `tbl_color`;

CREATE TABLE `tbl_color` (
  `color_id` int NOT NULL AUTO_INCREMENT,
  `color_name` varchar(255) NOT NULL,
  `status` int NOT NULL,
  `color_code` varchar(999) NOT NULL,
  PRIMARY KEY (`color_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (1, 'Green', 0, '#00ff00');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (2, 'Red', 0, '#000000');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (3, 'Blue', 0, '#000000');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (4, 'Black', 0, '#000000');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (5, 'Gray', 0, '#000000');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (6, 'Yellow', 0, '#fbff00');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (7, 'Yellow', 0, '#e1ed75');
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`, `color_code`) VALUES (8, 'yellow', 0, '#e8f943');


#
# TABLE STRUCTURE FOR: tbl_contact_inq
#

DROP TABLE IF EXISTS `tbl_contact_inq`;

CREATE TABLE `tbl_contact_inq` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(99) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(99) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` varchar(9999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  `ip_address` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `browser` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (1, '???? + 1.72276 BTC.GET - https://graph.org/Ticket--58146-05-02?hs=e92dc5a41593fa8c8bf4f28a8153c1e3&', '9041203800', 'aurorabnkwy@gmailbrt.com', 'l7xkj2', '2025-05-04 21:39:35', 1, '45.66.35.20', 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36 OPR/29.0.1795.47 (Edition Yx)');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (2, 'Felicity Sauncho', '620857947', 'felicitysauncho02@gmail.com', 'Hi there,\r\n\r\nWe run a Youtube growth service, where we can increase your subscriber count safely and practically. \r\n\r\n- Gain 700-1500+ real, human subscribers who subscribe because they are interested in your channel/videos. \r\n- Safe: All actions are done, without using any automated tasks / bots.\r\n- Channel Creation: If you haven\'t started your YouTube journey yet, we can create a professional channel for you as part of your initial order.\r\n\r\nIf you are interested then we can discuss further.\r\n\r\nKind regards,\r\nFelicity', '2025-05-08 05:05:07', 1, '89.37.66.75', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (3, 'Search Engine Index', '6811852227', 'submissions@searchindex.site', 'Hello,\r\n\r\nfor your website do be displayed in searches your domain needs to be indexed in the Google Search Index.\r\n\r\nTo add your domain to Google Search Index now, please visit \r\n\r\nhttps://SearchRegister.info/\r\n', '2025-05-08 20:59:33', 1, '51.38.163.120', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (4, '???? Notification; TRANSACTION 1.119766 bitcoin. Get > https://graph.org/Ticket--58146-05-02?hs=e92', '2392056779', 'diakhan@haialo.top', 'x6kl1z', '2025-05-10 05:39:55', 1, '192.42.116.212', 'Mozilla/5.0 (X11; U; Linux x86_64; en-US) AppleWebKit/533.4 (KHTML, like Gecko) Chrome/5.0.375.53 Safari/533.4');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (5, 'Joanna Riggs', '624976977', 'joannariggs278@gmail.com', 'Hi,\r\n\r\nI just visited sppvinayak.com and wondered if you\'d ever thought about having an engaging video to explain what you do?\r\n\r\nOur videos cost just $195 (USD) for a 30 second video ($239 for 60 seconds) and include a full script, voice-over and video.\r\n\r\nI can show you some previous videos we\'ve done if you want me to send some over. Let me know if you\'re interested in seeing samples of our previous work.\r\n\r\nRegards,\r\nJoanna\r\n\r\nUnsubscribe: https://removeme.live/unsubscribe.php?d=sppvinayak.com', '2025-05-14 00:38:45', 1, '196.245.247.55', 'Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (6, '???? Notification; Process 1,559373 BTC. Receive =>> https://yandex.com/poll/HsemiBCtfopPhJGk2rGvc2', '4868837073', 'ransan@apotekberjalan.com', '66pblk', '2025-05-16 09:26:54', 1, '45.84.107.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:36.0) Gecko/20100101 Firefox/36.0 SeaMonkey/2.33.1');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (7, '???? + 1.964710 BTC.NEXT - https://yandex.com/poll/5JjqQt7R61CTYdYVd17t6p?hs=e92dc5a41593fa8c8bf4f2', '1235674125', 'roofa2000@automisly.org', 'szikkf', '2025-05-17 11:07:03', 1, '45.84.107.55', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.159 YaBrowser/21.8.3.607 Yowser/2.5 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (8, 'Search Engine Index', '9548886604', 'submissions@searchindex.site', 'Hello,\r\n\r\nfor your website do be displayed in searches your domain needs to be indexed in the Google Search Index.\r\n\r\nTo add your domain to Google Search Index now, please visit \r\n\r\nhttps://SearchRegister.info/\r\n', '2025-05-18 22:51:21', 1, '209.127.116.16', 'Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:114.0) Gecko/20100101 Firefox/114.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (9, '???? + 1.462854 BTC.GET - https://yandex.com/poll/7HqNsFACc4dya6qN3zJ4f5?hs=e92dc5a41593fa8c8bf4f28', '1885213497', 'vivzgnoras@email-temp.com', 'wp4wmo', '2025-05-21 13:01:09', 1, '45.141.215.111', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A710F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.111 Mobile Safari/537.36 OPR/46.1.2246.127339');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (10, 'Search Engine Index', '478932862', 'submissions@searchindex.site', 'Hello,\r\n\r\nfor your website do be displayed in searches your domain needs to be indexed in the Google Search Index.\r\n\r\nTo add your domain to Google Search Index now, please visit \r\n\r\nhttps://SearchRegister.info/\r\n', '2025-05-22 20:26:38', 1, '209.127.116.16', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (11, 'Joanna Riggs', '396519602', 'joannariggs278@gmail.com', 'Hi,\r\n\r\nI just visited sppvinayak.com and wondered if you\'d ever thought about having an engaging video to explain what you do?\r\n\r\nA couple of samples to check out for a Service and a Product:\r\n\r\nhttps://www.youtube.com/watch?v=uMI9l_FHwA8\r\n\r\nhttps://www.youtube.com/watch?v=67neUK1vylc\r\n\r\nOur videos cost just $195 (USD) for a 30 second video ($239 for 60 seconds) and include a full script, voice-over and video.\r\n\r\nI can show you some previous videos we\'ve done if you want me to send some over. Let me know if you\'re interested in seeing samples of our previous work.\r\n\r\nRegards,\r\nJoanna', '2025-05-24 19:53:30', 1, '196.242.4.94', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (12, '', '', '', '', '2025-05-26 04:18:08', 1, '85.208.96.202', 'Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (13, 'Pete Faring', '715-966-69', 'xj37.revolver901@passmail.com', 'Hi I can send a message (just like this one) to 15,000 website contact forms daily in your niche advertising your product, service, or website. I also send mass email. Reply for more information.', '2025-05-26 12:23:08', 1, '206.190.145.90', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (14, '???? Message- TRANSACTION 1.634089 BTC. Continue =>> https://yandex.com/poll/HsemiBCtfopPhJGk2rGvc2', '5752765140', 'ransan@apotekberjalan.com', '1y0fmq', '2025-05-26 17:49:23', 1, '185.107.57.64', 'Mozilla/5.0 (Linux; Android 10; Nokia 7.2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (15, '', '', '', '', '2025-05-28 04:33:23', 1, '49.51.183.75', 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (16, '???? + 1.544753 BTC.NEXT - https://yandex.com/poll/HYTE3DqXnHUqpZMyFqetue?hs=e92dc5a41593fa8c8bf4f2', '9039422172', 'avijagtap@dmxs8.com', '3suqp4', '2025-05-31 17:23:58', 1, '45.84.107.47', 'Mozilla/5.0 (Linux; Android 9; SO-02K Build/47.2.B.5.38; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36 YJApp-ANDROID jp.co.yahoo.android.yjtop/3.35.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (17, '???? + 1.687457 BTC.NEXT - https://yandex.com/poll/enter/BXidu5Ewa8hnAFoFznqSi9?hs=e92dc5a41593fa8c', '4473768944', 'zinnurofff@btcmod.com', 'kzsemn', '2025-06-01 04:33:09', 1, '80.94.92.92', 'Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3278.0 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (18, '???? + 1.696262 BTC.GET - https://yandex.com/poll/enter/BXidu5Ewa8hnAFoFznqSi9?hs=e92dc5a41593fa8c8', '5328220862', 'golovachenasywa@boranora.com', '1snvuz', '2025-06-01 20:21:31', 1, '45.138.16.248', 'Mozilla/5.0 (Linux; Android 7.0; VTR-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (19, 'Joanna Riggs', '31387171', 'joannariggs278@gmail.com', 'Hi,\r\n\r\nI just visited sppvinayak.com and wondered if you\'d ever thought about having an engaging video to explain what you do?\r\n\r\nOur prices start from just $195 (USD).\r\n\r\nA couple of samples to check out for a Service and a Product:\r\n\r\nhttps://www.youtube.com/watch?v=EkHWr2IHSqk\r\n\r\nhttps://www.youtube.com/watch?v=8S4l8_bgcnc\r\n\r\nLet me know if you\'re interested in seeing more samples of our previous work or have any questions.\r\n\r\nRegards,\r\nJoanna', '2025-06-02 16:08:36', 1, '23.95.204.126', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (20, '???? Message- + 1.570053 BTC. Withdraw >>> https://yandex.com/poll/5JjqQt7R61CTYdYVd17t6p?hs=e92dc5', '4927143066', 'aurorabnkwy@gmailbrt.com', '7q9ya0', '2025-06-03 01:14:14', 1, '45.84.107.74', 'Mozilla/5.0 (Linux; U; Android 9; en-gb; Redmi Note 8 Pro Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/71.0.3578.141 Mobile Safari/537.36 XiaoMi/MiuiBrowser/11.1.9-g');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (21, 'Patricia Hope', '653113771', 'ptrhop@protonmail.com', 'Hi!\r\n\r\nI\'ve been a reader of your blog for around 4 months and I would like first of all to say that I really enjoy it.\r\n\r\nI\'ve got recently some problems with my eyes which effects my reading ability.\r\n\r\nThereby I have a favor to ask. Is it possible for you to add an audio podcast version of your articles?\r\n\r\nIt would be very useful for people like me and others who like to listen to your content.\r\n\r\nI\'ve researched on that a bit and I found few free services that can help to do that.\r\n\r\nHere are the websites that I found that can add podcast to your site for free, maybe there are more but I found these two.\r\n\r\nhttps://websitevoice.com\r\n\r\nhttps://www.text2speech.org/\r\n\r\nhttp://www.fromtexttospeech.com\r\n\r\nThank you!\r\n\r\nPatri Hope', '2025-06-03 13:55:22', 1, '193.151.188.242', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (22, '???? Ticket; Operation 1,16630 bitcoin. Get >>> https://yandex.com/poll/76RuKke5vYn6W1hp2wxzvb?hs=e', '9095068330', 'friedenspfeifen@omggreatfoods.com', 'ewf9bu', '2025-06-05 08:08:31', 1, '45.84.107.17', 'Mozilla/5.0 (Linux; Android 9; P30 Build/PPR1.180610.011) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36 YaApp_Android/10.61 YaSearchBrowser/10.61');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (23, '???? + 1.24905 BTC.NEXT - https://yandex.com/poll/Ef2mNddcUzfYHaPDepm53G?hs=e92dc5a41593fa8c8bf4f28', '5965188872', 'romnik2012@code-gmail.com', 'yjc8f9', '2025-06-06 00:06:31', 1, '185.220.100.250', 'Mozilla/5.0 (Linux; Android 9; X10 PLUS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.111 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (24, 'lkjdretlvssss www.yandex.ru', '+749562031', 'john@protdskeit.ru', 'lkjdretlvssss www.yandex.ru', '2025-06-09 02:15:44', 1, '144.76.93.50', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (25, 'wjrqllofjn', '+1-578-076', 'uhorquxk@testform.xyz', 'uvrwwrdswqdoeiwwihvqnvudmhnnzh', '2025-06-17 21:57:54', 1, '196.251.87.128', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MDDCJS; rv:11.0) like Gecko');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (26, 'Barbara Murray', '7070952789', 'barbaramurray432@gmail.com', 'Hi there,\r\n\r\nWe specialize in creating modern, impactful logos that help businesses stand out online.\r\n\r\nWe\'d like to offer you a logo concept for sppvinayak.com. This would give you a chance to visualize how a fresh design could enhance your brand\'s presence, with no obligation on your part. It\'s a great way to see the potential impact before making any decisions.\r\n\r\nIf exploring a new visual direction for your business is of interest, just reply to this email, and we can start developing a concept for you. Otherwise, if this isn\'t of interest, no action is needed.\r\n\r\nBest regards,\r\nBarbara Murray', '2025-06-18 10:13:50', 1, '80.97.96.130', 'Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (27, 'Manshi Sharma', '9266141479', 'sales@support.webxtalk.com', 'Hi,\r\n\r\nMany local businesses lose out on customers due to poor local SEO. When I checked your site, I found:\r\n\r\n • Missing Google Business Profile details\r\n • Lack of location-based keywords\r\n • No local citations or reviews\r\n\r\nIf you\'re looking to bring in more local traffic, I’d love to help.\r\n\r\nWe can help optimize your website for better conversions. Interested?\r\n\r\nBest regards,\r\nManshi', '2025-06-18 17:46:43', 1, '122.162.151.188', 'Mozilla/5.0 (Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (28, '???? Message; Process 1,906687 BTC. Get >> https://yandex.com/poll/enter/74bfAGFkYMSw1paqJM8NzD?hs=', '8947564782', 'romnik2012@code-gmail.com', '11kshd', '2025-06-19 03:38:18', 1, '185.246.188.73', 'Mozilla/5.0 (Linux; Android 8.1.0; P410 Build/OPM2.171019.012; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/81.0.4044.117 YaBrowser/19.6.0.158 (lite) Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (29, '???? Reminder: + 1,987935 BTC. Assure >>> https://yandex.com/poll/enter/L5vH9ubiXcdtj4jHBcJenv?hs=e', '7457942720', 'alexwhitson@theking.id', 'nyirkl', '2025-06-24 04:32:02', 1, '185.220.101.31', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; MRSPUTNIK 2, 4, 0, 460; GTB7.2; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (30, '???? Reminder; Process 1,912494 BTC. Confirm > https://yandex.com/poll/enter/12JSER8t8KDJewYyTprg7K', '8319868972', 'ajvazovaskijo@gomigoofficial.com', 'pdidf7', '2025-06-26 12:27:08', 1, '109.70.100.4', 'Mozilla/5.0 (Linux; Android 9; SM-G892U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (31, 'Joe Louise', '313103745', 'louise.joe@msn.com', 'Hi,\r\n\r\nToday you have the opportunity to pick yourself up a copy of the brand-new PLR that has been released to the market, which you can also sell under your own name or brand it by using a complete set of ready-to-install, and the best quality marketing tools.\r\n\r\nGo directly to the product here: https://furtherinfo.info/plrorganic\r\n\r\nHere\'s what you\'re getting: \r\n\r\nModule 1 - 5 High-Quality Training Videos\r\nModule 2 - Professionally Written Training Guide\r\nModule 3 - 5 Audio Files\r\nModule 4 - 5 Raw Video Files\r\nModule 5 - 5 Expert Presentation slides (PPT)\r\nModule 6 - High-Converting Sales Copy\r\nModule 7 - Customer Sales Video\r\nModule 8 - Professional Graphics\r\nModule 9 - Animated Banners\r\nModule 10 - Professionally Written Email Swipes\r\nModule 11 - Professional Minisites\r\nModule 12 - Legal Pages\r\nModule 13 - Social Media Graphics\r\nModule 14 - PDF Graphics\r\nModule 15 - Chapter Images\r\n\r\nHot Niche Alert:\r\nOrganic eating, toxin-free living, and sustainable habits are in high demand across the globe. Consumers are hungry for simple, actionable ways to live healthier and greener lives.\r\n\r\nComplete Sales Material Provided:\r\nIncludes email swipes, videos, graphics, and more for effortless conversions.\r\n\r\nFull Private Label Rights Included:\r\nCustomize, rebrand, and resell for maximum profits.\r\n\r\nBoost Credibility Instantly:\r\nHelp your customers become trusted guides in the organic lifestyle niche, even if they\'re new to the space.\r\n\r\nIt\'s perfect for:\r\n- Wellness bloggers\r\n- Holistic coaches\r\n- Eco-conscious influencers\r\n- Digital entrepreneurs in the health & lifestyle niche\r\n\r\nGo directly to the product here: https://furtherinfo.info/plrorganic\r\n\r\nKeep in mind, right now it\'s at the early-bird introductory price, so it would be a wise decision to snap yourself up a copy now, so you don\'t have to pay more for it later.\r\n\r\nKind regards,\r\nJoe', '2025-06-27 18:16:33', 1, '37.203.210.216', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (32, '???? Notification: TRANSACTION 1.817271 bitcoin. Continue >>> https://graph.org/Payout-from-Blockch', '3631552444', 'vivzgnoras@email-temp.com', 'tetlgb', '2025-07-01 11:20:43', 1, '176.65.149.87', 'Mozilla/5.0 (Linux; Android 9; Redmi S2 Build/PKQ1.181203.001) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.92 Mobile Safari/537.36 YaApp_Android/9.00 YaSearchBrowser/9.00');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (33, '???? + 1.509833 BTC.GET - https://graph.org/Payout-from-Blockchaincom-06-26?hs=e92dc5a41593fa8c8bf4', '8682880503', 'andreiutenkov@twitch.work', '5u8yen', '2025-07-01 22:15:48', 1, '45.84.107.172', 'Mozilla/5.0 (Linux; Android 10; BKL-AL00) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.117 Mobile Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (34, '???? Ticket: TRANSFER 1,123623 BTC. GET > https://graph.org/Payout-from-Blockchaincom-06-26?hs=e92d', '6002801513', 'easyasswinsman@thinhmin.com', 'dohq0r', '2025-07-08 10:07:05', 1, '204.8.96.103', 'Mozilla/5.0 (iPad; U; CPU OS 5_0 like Mac OS X; en-us) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.0.2 Mobile/9A5248d Safari/6533.18.5#2.0#TCL/TCL-EU-RT2851-S1/28/tclwebkit1.0.2/1920*1080(547201164,null;223638693,5e1c14b212714aba9f902d376e3504aa)');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (35, '???? + 1.276695 BTC.NEXT - https://graph.org/Payout-from-Blockchaincom-06-26?hs=e92dc5a41593fa8c8bf', '4287881240', 'azizxkill1@setxko.com', 'phu179', '2025-07-10 10:52:07', 1, '93.90.74.29', 'Mozilla/5.0 (Linux; Android 10; SM-A505GT) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36,gzip(gfe),gzip(gfe)');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (36, '', '', '', '', '2025-07-12 03:43:09', 1, '43.130.26.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (37, 'Hildegarde Paltridge', '1484525965', 'paltridge.hildegarde@hotmail.com', 'Hi,\r\n\r\nI just wanted to share an a YouTube A-Z system that guides you to build a thriving YouTube business, and here\'s the revolutionary part: it comes with full private label rights (PLR) to sell as your own.\r\n\r\nThis 55+ page blueprint covers:\r\n\r\nFoundation Blueprint: Niche, audience, and channel optimization.\r\nContent Engine: Creating videos people want to watch.\r\nGrowth Accelerator: Demystifying the algorithm, SEO, and clickable thumbnails.\r\nMonetization Machine: Unlocking 7+ income streams, including sponsorships.\r\n\r\nThe real game-changer is the PLR! You get permission to:\r\n\r\nSell this eBook and keep 100% of the money.\r\nPut your name on it as the author.\r\nUse it as a high-value bonus, break it into articles, or build your email list.\r\n\r\nWe\'ve done the hard work; you get to profit instantly and build your authority.\r\n\r\nBut that\'s not all. You\'ll also receive the Complete Creator\'s Launch Kit absolutely FREE! This bonus kit includes:\r\n\r\n1. Pro Channel Branding Kit: Logo templates, YouTube intro/outro logos, end screens, channel art, lower third graphics, and a YouTube thumbnail bundle.\r\n2. Viral Video Essentials: YT motion graphics, title animations, video transitions, animated subscribe buttons, and YouTube ranking tools.\r\n3. Audio Engineer\'s Sound Pack: Royalty-free background music, popular YouTuber sound effects, and transition sound effects.\r\n\r\nFind out more here:\r\nhttps://furtherinfo.info/ytmastery\r\n\r\nBest regards,\r\nHildegarde', '2025-07-14 11:24:56', 1, '168.151.242.175', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (38, 'Theo Martens', '675100593', 'hacked@sppvinayak.com', 'We have hacked your website https://sppvinayak.com and extracted your databases.\r\n\r\nHow did this happen?\r\n\r\nOur team has found a vulnerability within your site that we were able to exploit. After finding the vulnerability we were able to get your database credentials and extract your entire database and move the information to an offshore server.\r\n\r\nWhat does this mean?\r\n\r\nWe will systematically go through a series of steps of totally damaging your reputation. First your database will be leaked or sold to the highest bidder which they will use with whatever their intentions are. Next if there are e-mails found they will be e-mailed that their information has been sold or leaked and your site https://sppvinayak.com was at fault thusly damaging your reputation and having angry customers/associates with whatever angry customers/associates do. Lastly any links that you have indexed in the search engines will be de-indexed based off of blackhat techniques that we used in the past to de-index Our targets.\r\n\r\nHow do i stop this?\r\n\r\nWe are willing to refrain from destroying your site\'s reputation for a small fee. The current fee is $5000 in bitcoins (0.043 BTC).\r\n\r\nSend the bitcoin to the following Bitcoin address (Make sure to copy and paste):\r\n\r\n bc1quggjdwt0u9wycl9f4f36zce6tg94u3uajvtzky \r\n\r\nOnce you have paid we will automatically get informed that it was your payment. Please note that you have to make payment within 5 days after receiving this e-mail or the database leak, e-mails dispatched, and de-index of your site WiLL start!\r\n\r\nHow do i get Bitcoins?\r\n\r\nYou can easily buy bitcoins via several websites or even offline from a Bitcoin-ATM.\r\n\r\nWhat if i don\'t pay?\r\n\r\nWe will start the attack at the indicated date and uphold it until you do, there\'s no counter measure to this, you will Only end up wasting more money trying to find a solution. We will completely destroy your reputation amongst google and your customers.\r\n\r\nThis is not a hoax, do not reply to this email, don\'t try to reason or negotiate, we will not read any replies. Once you have paid we will stop what we were doing and you will never hear from us again!\r\n\r\nPlease note that Bitcoin is anonymous and no one will find out that you have complied.', '2025-07-18 20:51:57', 1, '194.104.11.69', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:114.0) Gecko/20100101 Firefox/114.0');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (39, '???? Email- + 1,300002 BTC. Verify =>> https://graph.org/Payout-from-Blockchaincom-06-26?hs=e92dc5a', '6497585905', '6j3m5@jagomail.com', '5vz2ef', '2025-07-19 03:39:58', 1, '45.90.185.105', 'WordPress/5.4.1; https://investuji.eu');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (40, '???? Reminder: Process 1.328651 bitcoin. Confirm => https://graph.org/Payout-from-Blockchaincom-06-', '0521244484', 'avijagtap@dmxs8.com', '242406', '2025-07-19 09:16:36', 1, '195.47.238.88', 'Mozilla/5.0 (Linux; Android 5.1.1; ZUK Z1 Build/LMY47V; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/81.0.4044.138 Mobile Safari/537.36 Browser');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (41, '???? Ticket: SENDING 1,147545 BTC. Verify =>> https://graph.org/Payout-from-Blockchaincom-06-26?hs=', '5920581141', 'roofa2000@automisly.org', '1zh1co', '2025-07-20 20:07:36', 1, '192.42.116.177', 'Mozilla/5.0 (Linux; Android 8.0.0; ATU-LX3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Mobile Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (42, '???? + 1.813940 BTC.GET - https://graph.org/Payout-from-Blockchaincom-06-26?hs=e92dc5a41593fa8c8bf4', '1648779427', 'stevescan@24hinbox.com', 'eivzwo', '2025-07-21 05:06:58', 1, '5.45.102.93', 'Mozilla/5.0 (Windows NT 6.1; rv:68.9) Gecko/20100101 Goanna/4.5 Firefox/68.9 PaleMoon/28.9.3');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (43, '???? Notification; Process 1.936375 BTC. Receive => https://graph.org/Payout-from-Blockchaincom-06-', '9417954850', 'ransan@apotekberjalan.com', 'lqe791', '2025-07-21 12:32:02', 1, '154.41.95.2', 'Mozilla/5.0 (Linux; Android 7.0; TZ175) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.136 Mobile Safari/537.36');


#
# TABLE STRUCTURE FOR: tbl_country
#

DROP TABLE IF EXISTS `tbl_country`;

CREATE TABLE `tbl_country` (
  `country_id` int NOT NULL AUTO_INCREMENT,
  `country_name` varchar(100) NOT NULL DEFAULT '',
  `state_id` varchar(110) NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: tbl_coupon
#

DROP TABLE IF EXISTS `tbl_coupon`;

CREATE TABLE `tbl_coupon` (
  `coupon_id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(999) DEFAULT NULL,
  `code` varchar(999) DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `addon` datetime DEFAULT NULL,
  `status` int DEFAULT NULL,
  `min_amt` float DEFAULT NULL,
  `type` int DEFAULT NULL,
  `uid` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_customer
#

DROP TABLE IF EXISTS `tbl_customer`;

CREATE TABLE `tbl_customer` (
  `cust_id` int NOT NULL AUTO_INCREMENT,
  `sponsor_id` varchar(999) NOT NULL,
  `cust_name` varchar(100) NOT NULL,
  `cust_cname` varchar(100) NOT NULL,
  `cust_email` varchar(100) NOT NULL,
  `cust_phone` varchar(50) NOT NULL,
  `cust_image` varchar(999) NOT NULL,
  `cust_country` int NOT NULL,
  `cust_address` text NOT NULL,
  `cust_city` varchar(100) NOT NULL,
  `cust_state` varchar(100) NOT NULL,
  `cust_zip` varchar(30) NOT NULL,
  `cust_b_name` varchar(100) NOT NULL,
  `cust_b_cname` varchar(100) NOT NULL,
  `cust_b_phone` varchar(50) NOT NULL,
  `cust_b_country` int NOT NULL,
  `cust_b_address` text NOT NULL,
  `cust_b_city` varchar(100) NOT NULL,
  `cust_b_state` varchar(100) NOT NULL,
  `cust_b_zip` varchar(30) NOT NULL,
  `cust_s_name` varchar(100) NOT NULL,
  `cust_s_cname` varchar(100) NOT NULL,
  `cust_s_phone` varchar(50) NOT NULL,
  `cust_s_country` int NOT NULL,
  `cust_s_address` text NOT NULL,
  `cust_s_city` varchar(100) NOT NULL,
  `cust_s_state` varchar(100) NOT NULL,
  `cust_s_zip` varchar(30) NOT NULL,
  `cust_password` varchar(100) NOT NULL,
  `cust_token` varchar(255) NOT NULL,
  `cust_datetime` varchar(100) NOT NULL,
  `cust_timestamp` varchar(100) NOT NULL,
  `cust_status` int NOT NULL,
  `code` int NOT NULL,
  `cust_otp` varchar(99) NOT NULL,
  `uid` varchar(999) NOT NULL,
  `pass` varchar(999) NOT NULL,
  `user` varchar(999) NOT NULL,
  PRIMARY KEY (`cust_id`)
) ENGINE=InnoDB AUTO_INCREMENT=378 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (1, '', 'Chhotu Traders', '', 'spp@gmail.com', '9876543210', 'Customer-1-1190066793.jpg', 0, 'Patna Pahari', 'Vaishali', '1', '844117', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'aa847eeb1a227071ab703b45450415c2', '', '2025-08-11 18:08:43', '', 1, 1, '', '9876543210', 'customer@12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (377, '8084940179', 'Test', '', 'test@gmail.com', '9876543210', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e10adc3949ba59abbe56e057f20f883e', '9154e02191d40a4800c4bb27ea7114a8', '2025-09-12 09:29:39', '1757649579', 1, 8673, '', '9876543210', '123456', '1');


#
# TABLE STRUCTURE FOR: tbl_customer_message
#

DROP TABLE IF EXISTS `tbl_customer_message`;

CREATE TABLE `tbl_customer_message` (
  `customer_message_id` int NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `order_detail` text NOT NULL,
  `cust_id` int NOT NULL,
  PRIMARY KEY (`customer_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_delivery_address
#

DROP TABLE IF EXISTS `tbl_delivery_address`;

CREATE TABLE `tbl_delivery_address` (
  `delivery_address_id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(99) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pin_code` int NOT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`delivery_address_id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (2, '3', 'Ram ji', '9939195269', 'Bihar', 'MUZAFFARPUR', 842002, 'Vill post karaundi soraon allahabad', '2021-07-18 06:04:04', '2021-07-18 06:04:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (3, '1', 'TryIt India', '8084940179', 'Bihar', 'MUZAFFARPUR', 842003, 'Muzaffarpur', '2021-07-17 04:05:04', '2021-07-17 04:05:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (4, '5', 'Manish kr', '9711002470', 'Bihar', 'MUZAFFARPUR', 842001, '85 B, LALA KI SARAI, TELIYARGANJ', '2021-07-17 04:38:04', '2021-07-17 04:38:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (5, '28', 'MITHILESH KUMAR', '08210179625', 'Bihar', '', 842001, 'Majhauliya,Shivpuri colony  lane no-2 muzaffarpur,near parmanand smriti bhawan', '2021-07-25 09:13:41', '2021-07-25 09:13:41', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (6, '14', 'Abhishek Sharma', '7004983144', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzafafrpur', '2021-08-03 01:15:33', '2021-08-03 01:15:33', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (16, '83', 'Anand mohan', '9097027327', 'Bihar', 'MUZAFFARPUR', 842001, ' Ahiyapur Dharmkanta Hanuman mandir road near brahmsthan chakmohamad Muzaffarpur\n', '2021-08-03 02:25:02', '2021-08-03 02:25:02', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (17, '10', 'Vimal Kumar', '7992259617', 'Bihar', 'MUZAFFARPUR', 842002, 'Ram saikil niwas\nJanglimai colony, mithanpura\nMuzaffarpur', '2021-08-03 08:02:53', '2021-08-03 08:02:53', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (18, '64', 'Pankaj Kumar ', '7717790405', 'Bihar', 'MUZAFFARPUR', 842005, 'Mal godown chowk narayanpur Sherpur ', '2021-08-15 11:38:15', '2021-08-15 11:38:15', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (19, '191', 'RAM PRAVESH SINGH', '9939903944', 'Bihar', 'MUZAFFARPUR', 842005, 'Muzaffarpur', '2021-08-16 08:36:56', '2021-08-16 08:36:56', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (23, '92', 'Dhruv kumar', '7979835482', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-08-16 12:51:46', '2021-08-16 12:51:46', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (24, '176', 'Nayan Prakash', '7004982268', '', '', 842002, 'anand nagar gobarsahi muzaffarpur', '2021-08-17 04:51:46', '2021-08-17 04:51:46', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (25, '206', 'Sippu Mishra', '9102849149', 'Bihar', 'MUZAFFARPUR', 842002, 'Shiv shankar Path, Lane 1\r\nSuresh singh House. \r\nMithanpura. \r\nNear Vats academy. \r\n7352231292', '2021-08-18 09:48:39', '2021-08-18 09:48:39', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (26, '203', 'Awishkar ', '7060035539', '', '', 842001, 'aghoriya bazar muzaffarpur', '2021-08-19 07:49:52', '2021-08-19 07:49:52', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (27, '201', 'Anuranjan kumar', '9565873620', 'Bihar', 'MUZAFFARPUR', 842001, 'prabhat nagar, road no 4, gobarsahi, near jj prep public school', '2021-08-19 12:03:30', '2021-08-19 12:03:30', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (31, '116', 'Chandrabhushan Prakash', '9939527762', 'Bihar', 'MUZAFFARPUR', 842002, 'Juranchhapra', '2021-08-19 11:35:08', '2021-08-19 11:35:08', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (32, '211', 'Pradeep thakur', 'thakur7004191773', 'Bihar', 'MUZAFFARPUR', 842002, 'Trinetra bhawan 52 bigha road no-17 kanhouli', '2021-08-20 07:54:49', '2021-08-20 07:54:49', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (33, '215', 'Mrinal', '9304928494', 'Bihar', 'MUZAFFARPUR', 842001, 'Krishna nagar colony lane no 1 , Gobarshai. \r\nSnake bite hospital road. ', '2021-08-21 03:32:40', '2021-08-21 03:32:40', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (34, '216', 'Deepak Kumar', '7779911350', 'Bihar', 'MUZAFFARPUR', 842001, 'Prabhat tara road,jyoti gunj ,chanakya bihar road no-2 ,', '2021-08-21 04:47:18', '2021-08-21 04:47:18', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (35, '56', 'RAJEEV RANJAN MISHRA', '8210687557', 'Bihar', 'MUZAFFARPUR', 842002, 'dwarikanagar muzaffarpur', '2021-08-22 09:34:30', '2021-08-22 09:34:30', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (36, '182', 'Sk Diwakar', '6207063262', 'Bihar', 'MUZAFFARPUR', 842002, 'Sherpur ', '2021-08-23 04:54:50', '2021-08-23 04:54:50', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (37, '220', 'DILIP KUMAR ', '9852727321', 'Bihar', 'MUZAFFARPUR', 842002, 'Sherpur', '2021-08-23 05:48:33', '2021-08-23 05:48:33', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (38, '221', 'ravi sachdev', '8910190186', 'Bihar', 'MUZAFFARPUR', 842002, 'mithanpura', '2021-08-24 08:36:41', '2021-08-24 08:36:41', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (39, '196', 'MANAS KUMAR', '9304117388', 'Bihar', 'MUZAFFARPUR', 842002, 'R K PURAM, ROAD NO 4, NEAR INDRASAN VIVAH BHAWAN,BELA, MUZAFFARPUR', '2021-08-24 08:50:59', '2021-08-24 08:50:59', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (40, '222', 'Amit Ranjan', '7004535282', 'Bihar', 'MUZAFFARPUR', 842002, 'Laxmi Narayan colony\r\nInfront of lane no 9\r\nMuzaffarpur', '2021-08-25 02:39:02', '2021-08-25 02:39:02', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (41, '208', 'Pushp Ranjan', '9264489691', 'Bihar', 'MUZAFFARPUR', 842002, 'Sonbarsa', '2021-08-25 02:45:18', '2021-08-25 02:45:18', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (42, '218', 'Ankit raj', '7079959905', 'Bihar', 'MUZAFFARPUR', 842002, 'Sherpur', '2021-08-25 06:31:27', '2021-08-25 06:31:27', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (43, '95', 'Lov Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-08-26 11:13:05', '2021-08-26 11:13:05', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (44, '135', 'Nitin Kumar', '9964852841', 'Bihar', 'MUZAFFARPUR', 842002, 'C/o Sunil Kumar Singh station Master H No B-25, Indrapuri colony lane no 2, Mithanpura.', '2021-09-06 06:20:22', '2021-09-06 06:20:22', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (45, '236', 'RAJ KISHORE GUPTA', '7004519780', 'Bihar', 'MUZAFFARPUR', 842005, 'Muza', '2021-08-28 06:33:19', '2021-08-28 06:33:19', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (46, '237', 'Dharmendra singh', '9142426646', 'Bihar', 'MUZAFFARPUR', 842002, 'Sherpur', '2021-08-28 07:52:00', '2021-08-28 07:52:00', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (47, '232', 'RAJNISH SINGH', '6203671487', 'Bihar', 'MUZAFFARPUR', 842002, 'Muz', '2021-09-11 07:36:06', '2021-09-11 07:36:06', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (48, '12', 'Sanjay Kumar Mishra', '9939090087', 'Bihar', 'MUZAFFARPUR', 842001, 'Kolhua paigamberpur', '2021-10-27 03:43:02', '2021-10-27 03:43:02', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (49, '183', 'Om Prakash', '8210898066', 'Bihar', 'MUZAFFARPUR', 842005, 'Rpf post nrpa\r\n', '2021-08-31 04:35:09', '2021-08-31 04:35:09', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (50, '242', 'Satyendra Narayan Singh', '8789068194', 'Bihar', 'MUZAFFARPUR', 843113, 'Shanti vihar colony\r\nDamodarpur', '2021-09-01 03:15:48', '2021-09-01 03:15:48', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (51, '204', 'Sunil Kumar', '7903392008', 'Bihar', 'MUZAFFARPUR', 842001, 'Muzaffarpur', '2021-09-02 09:24:24', '2021-09-02 09:24:24', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (52, '250', 'MUNNA SINGH', '7070852455', 'Bihar', 'MUZAFFARPUR', 842001, 'Eb star market, club road, mithanpura', '2021-09-03 05:27:42', '2021-09-03 05:27:42', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (53, '66', 'Deepak', '9304292354', 'Bihar', 'MUZAFFARPUR', 842001, 'Muzaffarpur', '2021-09-04 01:50:37', '2021-09-04 01:50:37', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (54, '37', 'Abhishek Kumar', '7050096409', 'Bihar', 'MUZAFFARPUR', 842005, 'बेला मुजफ्फरपुर\r\n', '2021-09-04 09:00:14', '2021-09-04 09:00:14', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (55, '253', 'shashi bhushan Kumar', '9572420157', 'Bihar', 'MUZAFFARPUR', 842001, 'Muz\r\n', '2021-09-05 05:00:12', '2021-09-05 05:00:12', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (56, '53', 'Wipin kumar', '9955659959', 'Bihar', 'MUZAFFARPUR', 842005, 'Near mic Post office Bela\r\nMuzaffarpur 842005', '2021-09-19 10:23:30', '2021-09-19 10:23:30', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (57, '245', 'Rajesh kumar singh', '9471818943', 'Bihar', 'MUZAFFARPUR', 843113, 'Shanti vihar colony East of housing board damodarpur', '2021-09-09 05:18:06', '2021-09-09 05:18:06', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (58, '192', 'Deepak Tiwari', '8097688109', 'Bihar', 'MUZAFFARPUR', 842005, 'Vill. Sherpur, Post- M.I.C. Bela\r\n', '2021-09-10 05:04:13', '2021-09-10 05:04:13', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (59, '261', 'Sanjeev Kumar ', '7667452404', 'Bihar', 'MUZAFFARPUR', 842001, 'Muz ', '2021-09-14 10:55:56', '2021-09-14 10:55:56', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (60, '264', 'ASHOK KUMAR ', '9852052351', 'Bihar', 'MUZAFFARPUR', 842001, 'ZEROMILE MUZAFFARPUR ', '2021-09-19 02:28:48', '2021-09-19 02:28:48', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (61, '266', 'Priyanka rani', '7488254922', 'Bihar', 'MUZAFFARPUR', 842001, 'Saketpuri bibigang near Munna shukla petrol pump', '2021-09-20 04:47:02', '2021-09-20 04:47:02', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (62, '267', 'Dhiraju Jha', '8002133129', 'Bihar', 'MUZAFFARPUR', 842002, 'Narayanpur', '2021-09-20 07:34:48', '2021-09-20 07:34:48', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (63, '213', 'Pramathnath kumar', '9006997575', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur\r\n\r\n', '2021-09-21 07:26:52', '2021-09-21 07:26:52', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (64, '274', 'Pankaj Kumar Mishra', '9572519741', 'Bihar', 'MUZAFFARPUR', 842002, 'Muz', '2021-10-01 05:28:31', '2021-10-01 05:28:31', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (65, '134', 'Navin kumar', '7488006584', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-10-04 05:25:16', '2021-10-04 05:25:16', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (66, '184', 'Anshika', '7761952639', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-10-04 05:42:08', '2021-10-04 05:42:08', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (67, '248', 'Rashmi', '7301654632', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-10-08 05:37:32', '2021-10-08 05:37:32', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (68, '75', 'Kamlesh kumar', '9835295896', 'Bihar', 'MUZAFFARPUR', 842002, 'Mithanpura', '2021-10-12 01:56:17', '2021-10-12 01:56:17', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (69, '276', 'Shivesh Mishra', '7909077814', 'Bihar', 'MUZAFFARPUR', 842005, 'Bhaskar awas, HOUSE NO.1, raghunath pandey memorial law collage, BELA phase 2', '2021-10-12 03:52:16', '2021-10-12 03:52:16', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (70, '41', 'Surendra chaudhary', '8084562474', 'Bihar', 'MUZAFFARPUR', 843108, 'Old motihari road\r\nNear sbi bank\r\nBariya', '2021-10-17 01:35:09', '2021-10-17 01:35:09', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (71, '281', 'Sneha kumari', '8210628324', 'Bihar', 'MUZAFFARPUR', 842002, 'Bela', '2021-10-23 02:58:37', '2021-10-23 02:58:37', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (72, '283', 'zahid', '9835069919', 'Bihar', 'Patna', 842003, 'Brahampura', '2021-10-27 05:14:39', '2021-10-27 05:14:39', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (73, '88', 'Amod Kumar', '9234659964', 'Bihar', 'MUZAFFARPUR', 842002, 'Gaushala chowk', '2021-11-26 02:56:14', '2021-11-26 02:56:14', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (74, '347', 'Vishal Kumar ', '9939864956', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill-chakwaja , p.s- chakwaja nagwan, Vaishali Bihar , 844120', '2025-05-30 12:56:32', '2025-05-30 12:56:32', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (75, '324', 'BIKASH KUMAR DAS', '9903382291', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill-lautan', '2025-05-31 08:03:26', '2025-05-31 08:03:26', 1);


#
# TABLE STRUCTURE FOR: tbl_district
#

DROP TABLE IF EXISTS `tbl_district`;

CREATE TABLE `tbl_district` (
  `id` int NOT NULL AUTO_INCREMENT,
  `state` varchar(999) DEFAULT NULL,
  `district` varchar(999) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (3, '1', 'Patna', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (5, '1', 'MUZAFFARPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (6, '1', 'Vaishali', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (7, '1', 'Bhagalpur', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (8, '1', 'Buxar', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (9, '1', 'Darbhanga', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (10, '1', 'East Champaran', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (11, '1', 'Gaya', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (12, '1', 'Gopalganj', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (13, '1', 'Jamui', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (14, '1', 'Jehanabad', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (15, '1', 'Kaimur', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (16, '1', 'Katihar', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (17, '1', 'Khagaria', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (18, '1', 'Kishanganj', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (19, '1', 'Nalanda', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (20, '1', 'Nawada', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (21, '1', 'Samastipur', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (22, '13', 'ALIPURDUAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (23, '13', 'BANKURA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (24, '13', 'BIRBHUM', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (25, '13', 'COOCH BEHAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (26, '13', 'DAKSHIN DINAJPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (27, '1', 'Araria', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (28, '1', 'Arwal', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (29, '1', 'Aurangabad', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (30, '1', 'Banka', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (31, '1', 'Begusarai', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (32, '1', 'Bhojpur', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (33, '1', 'Lakhisarai', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (34, '1', 'Madhubani', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (35, '1', 'Munger', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (36, '1', 'Pashchim Champaran', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (37, '1', 'Purbi Champaran', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (38, '1', 'Purnia', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (39, '1', 'Rohatas', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (40, '1', 'Saharsa', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (41, '1', 'Saran', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (42, '1', 'Sheikpura', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (43, '1', 'Sheohar', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (44, '1', 'Sitamarhi', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (45, '1', 'Siwan', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (46, '1', 'Supaul', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (47, '1', 'Madhepura', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (48, '13', 'DARJELING', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (49, '13', 'JALPAIGURI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (50, '13', 'MALDA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (51, '13', 'MURSHIDABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (52, '13', 'PURBA BARDHAMAN', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (53, '13', 'NADIA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (54, '13', 'PURULIA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (55, '13', 'HOOGHLY', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (56, '13', 'NORTH 24 PARGANES', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (57, '13', 'PASHCHIM MEDINIPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (58, '13', 'HOWRAH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (59, '13', 'KOLKATA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (60, '13', 'SOUTH 24 PARGANA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (61, '13', 'KALIMPONG', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (62, '13', 'ALIPURDUAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (63, '13', 'PASCHIM BARDHAMAN', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (64, '13', 'JHARGRAM', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (65, '7', 'AGRA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (66, '7', 'ALIGARH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (67, '7', 'ALLAHABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (68, '7', 'AMBEDKAR NAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (69, '7', 'AMETHI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (70, '7', 'AMROHA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (71, '7', 'AZAMGARH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (72, '7', 'BADAUN', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (73, '7', 'AURAIYA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (74, '7', 'BAGHPAT', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (75, '7', 'BAHRAICN', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (76, '7', 'BALLIA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (77, '7', 'BALRAMPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (78, '7', 'BANDA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (79, '7', 'BARABANKI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (80, '7', 'BAREILLY', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (81, '7', 'BASTI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (82, '7', 'BIJNOR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (83, '7', 'BULANDSHAHR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (84, '7', 'CHANDAULI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (85, '7', 'CHITRAKOOT', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (86, '7', 'ETAWAH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (87, '7', 'ETAH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (88, '7', 'DEORIA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (89, '7', 'FAIZABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (90, '7', 'FIROZABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (91, '7', 'FARRUKHABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (92, '7', 'FATEHPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (93, '7', 'GAUTAM BUDDHA NAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (94, '7', 'GHAZIABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (95, '7', 'GHAZIPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (96, '7', 'GONDA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (97, '7', 'GORAKHPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (98, '7', 'HAMIRPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (99, '7', 'HAPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (100, '7', 'HARDOR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (101, '7', 'HATHRAS', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (102, '7', 'JALAUN', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (103, '7', 'JAUNPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (104, '7', 'JHANSI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (105, '7', 'KANPUR DEHAT', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (106, '7', 'KANPUR NAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (107, '7', 'KASGANJ', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (108, '7', 'KAUSHAMBI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (109, '7', 'KUSHINAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (110, '7', 'LAKHIMPUR KHERI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (111, '7', 'LALITPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (112, '7', 'LUCKNOW', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (113, '7', 'MAHARAJGANJ', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (114, '7', 'MOHABA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (115, '7', 'MAINPURI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (116, '7', 'MATHURA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (117, '7', 'MAU', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (118, '7', 'MEERUT', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (119, '7', 'MIRZAPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (120, '7', 'MORADABAD', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (121, '7', 'MUZAFFARNAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (122, '7', 'PILIBHIT', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (123, '7', 'PRATAPGARH', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (124, '7', 'PRAYAGRAJ', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (125, '7', 'RAEBARELI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (126, '7', 'RAMPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (127, '7', 'SAHARANPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (128, '7', 'SAMBHAL', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (129, '7', 'SANT KABIR NAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (130, '7', 'SHAHJAHANPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (131, '7', 'SHAMLI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (132, '7', 'SHRAVASTI', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (133, '7', 'SIDDHARTHNAGAR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (134, '7', 'SITAPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (135, '7', 'SONBHADRA', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (136, '7', 'SULTANPUR', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (137, '7', 'UNNAO', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (138, '7', 'VARANASI', 1);


#
# TABLE STRUCTURE FOR: tbl_end_category
#

DROP TABLE IF EXISTS `tbl_end_category`;

CREATE TABLE `tbl_end_category` (
  `ecat_id` int NOT NULL AUTO_INCREMENT,
  `ecat_pic` varchar(111) NOT NULL,
  `ecat_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `tcat_id` int NOT NULL,
  `mcat_id` int NOT NULL,
  `status` int NOT NULL,
  `status_home` int NOT NULL,
  PRIMARY KEY (`ecat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (1, 'end_category-1.jpg', 'Court Paint', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (2, 'end_category-2.jpg', 'Saree', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (3, '', 'Tulsi', 1, 2, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (4, '', 'Aloe Vera', 1, 2, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (5, '', 'Humanity Buster ', 1, 2, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (6, '', 'Turmeric', 1, 4, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (7, '', 'Coriander', 1, 4, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (8, '', 'Red Chilli', 1, 4, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (9, '', 'Gram Masala', 1, 4, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (10, '', 'Garlic Powder', 1, 4, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (11, '', 'Paper', 1, 5, 1, 1);


#
# TABLE STRUCTURE FOR: tbl_enquiry
#

DROP TABLE IF EXISTS `tbl_enquiry`;

CREATE TABLE `tbl_enquiry` (
  `id` int NOT NULL AUTO_INCREMENT,
  `property_id` varchar(999) DEFAULT NULL,
  `name` varchar(999) DEFAULT NULL,
  `phone` varchar(999) DEFAULT NULL,
  `email` varchar(999) DEFAULT NULL,
  `user_message` varchar(999) DEFAULT NULL,
  `addon` datetime DEFAULT NULL,
  `status` int DEFAULT NULL,
  `term_policy` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_faq
#

DROP TABLE IF EXISTS `tbl_faq`;

CREATE TABLE `tbl_faq` (
  `faq_id` int NOT NULL AUTO_INCREMENT,
  `faq_title` varchar(255) NOT NULL,
  `faq_content` text NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`faq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_language
#

DROP TABLE IF EXISTS `tbl_language`;

CREATE TABLE `tbl_language` (
  `lang_id` int NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(255) NOT NULL,
  `lang_value` text NOT NULL,
  PRIMARY KEY (`lang_id`)
) ENGINE=MyISAM AUTO_INCREMENT=164 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (1, 'Currency', '&#8377;');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (2, 'Search Product', 'Search Product');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (3, 'Search', 'Search');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (4, 'Submit', 'Submit');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (5, 'Update', 'Update');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (6, 'Read More', 'Read More');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (7, 'Serial', 'Serial');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (8, 'Photo', 'Photo');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (9, 'Login', 'Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (10, 'Customer Login', 'Customer Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (11, 'Click here to login', 'Click here to login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (12, 'Back to Login Page', 'Back to Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (13, 'Logged in as', 'Logged in as');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (14, 'Logout', 'Logout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (15, 'Register', 'Register');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (16, 'Customer Registration', 'Customer Registration');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (17, 'Registration Successful', 'Registration Successful');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (18, 'Cart', 'Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (19, 'View Cart', 'View Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (20, 'Update Cart', 'Update Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (21, 'Back to Cart', 'Back to Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (22, 'Checkout', 'Checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (23, 'Proceed to Checkout', 'Proceed to Checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (24, 'Orders', 'Orders');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (25, 'Order History', 'Order History');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (26, 'Order Details', 'Order Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (27, 'Payment Date and Time', 'Payment Date and Time');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (28, 'Transaction ID', 'Transaction ID');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (29, 'Paid Amount', 'Paid Amount');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (30, 'Payment Status', 'Payment Status');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (31, 'Payment Method', 'Payment Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (32, 'Payment ID', 'Payment ID');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (33, 'Payment Section', 'Payment Section');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (34, 'Select Payment Method', 'Select Payment Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (35, 'Select a Method', 'Select a Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (36, 'PayPal', 'PayPal');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (37, 'Stripe', 'Stripe');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (38, 'Bank Deposit', 'Bank Deposit');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (39, 'Card Number', 'Card Number');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (40, 'CVV', 'CVV');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (41, 'Month', 'Month');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (42, 'Year', 'Year');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (43, 'Send to this Details', 'Send to this Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (44, 'Transaction Information', 'Transaction Information');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (45, 'Include transaction id and other information correctly', 'Include transaction id and other information correctly');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (46, 'Pay Now', 'Pay Now');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (47, 'Product Name', 'Product Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (48, 'Product Details', 'Product Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (49, 'Categories', 'Categories');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (50, 'Category:', 'Category:');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (51, 'All Products Under', 'All Products Under');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (52, 'Select Size', 'Select Size');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (53, 'Select Color', 'Select Color');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (54, 'Product Price', 'Product Price');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (55, 'Quantity', 'Quantity');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (56, 'Out of Stock', 'Out of Stock');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (57, 'Share This', 'Share This');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (58, 'Share This Product', 'Share This Product');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (59, 'Product Description', 'Product Description');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (60, 'Features', 'Features');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (61, 'Conditions', 'Conditions');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (62, 'Return Policy', 'Return Policy');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (63, 'Reviews', 'Reviews');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (64, 'Review', 'Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (65, 'Give a Review', 'Give a Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (66, 'Write your comment (Optional)', 'Write your comment (Optional)');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (67, 'Submit Review', 'Submit Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (68, 'You already have given a rating!', 'You already have given a rating!');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (69, 'You must have to login to give a review', 'You must have to login to give a review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (70, 'No description found', 'No description found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (71, 'No feature found', 'No feature found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (72, 'No condition found', 'No condition found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (73, 'No return policy found', 'No return policy found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (74, 'No Review is Found', 'No Review is Found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (75, 'Customer Name', 'Customer Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (76, 'Comment', 'Comment');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (77, 'Comments', 'Comments');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (78, 'Rating', 'Rating');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (79, 'Previous', 'Previous');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (80, 'Next', 'Next');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (81, 'Sub Total', 'Sub Total');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (82, 'Total', 'Total');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (83, 'Action', 'Action');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (84, 'Shipping Cost', 'Shipping Cost');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (85, 'Continue Shipping', 'Continue Shipping');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (86, 'Update Billing Address', 'Update Billing Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (87, 'Update Shipping Address', 'Update Shipping Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (88, 'Update Billing and Shipping Info', 'Update Billing and Shipping Info');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (89, 'Dashboard', 'Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (90, 'Welcome to the Dashboard', 'Welcome to the Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (91, 'Back to Dashboard', 'Back to Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (92, 'Subscribe', 'Subscribe');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (93, 'Subscribe To Our Newsletter', 'Subscribe To Our Newsletter');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (94, 'Email Address', 'Email Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (95, 'Enter Your Email Address', 'Enter Your Email Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (96, 'Password', 'Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (97, 'Forget Password', 'Forget Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (98, 'Retype Password', 'Retype Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (99, 'Update Password', 'Update Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (100, 'New Password', 'New Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (101, 'Retype New Password', 'Retype New Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (102, 'Full Name', 'Full Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (103, 'Company Name', 'Company Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (104, 'Phone Number', 'Phone Number');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (105, 'Address', 'Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (106, 'Country', 'Country');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (107, 'City', 'City');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (108, 'State', 'State');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (109, 'Zip Code', 'Zip Code');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (110, 'About Us', 'About Us');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (111, 'Featured Posts', 'Featured Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (112, 'Popular Posts', 'Popular Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (113, 'Recent Posts', 'Recent Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (114, 'Contact Information', 'Contact Information');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (115, 'Contact Form', 'Contact Form');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (116, 'Our Office', 'Our Office');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (117, 'Update Profile', 'Update Profile');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (118, 'Send Message', 'Send Message');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (119, 'Message', 'Message');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (120, 'Find Us On Map', 'Find Us On Map');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (121, 'Congratulation! Payment is successful.', 'Congratulation! Payment is successful.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (122, 'Billing and Shipping Information is updated successfully.', 'Billing and Shipping Information is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (123, 'Customer Name can not be empty.', 'Customer Name can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (124, 'Phone Number can not be empty.', 'Phone Number can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (125, 'Address can not be empty.', 'Address can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (126, 'You must have to select a country.', 'You must have to select a country.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (127, 'City can not be empty.', 'City can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (128, 'State can not be empty.', 'State can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (129, 'Zip Code can not be empty.', 'Zip Code can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (130, 'Profile Information is updated successfully.', 'Profile Information is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (131, 'Email Address can not be empty', 'Email Address can not be empty');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (132, 'Email and/or Password can not be empty.', 'Email and/or Password can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (133, 'Email Address does not match.', 'Email Address does not match.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (134, 'Email address must be valid.', 'Email address must be valid.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (135, 'You email address is not found in our system.', 'You email address is not found in our system.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (136, 'Please check your email and confirm your subscription.', 'Please check your email and confirm your subscription.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (137, 'Your email is verified successfully. You can now login to our website.', 'Your email is verified successfully. You can now login to our website.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (138, 'Password can not be empty.', 'Password can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (139, 'Passwords does not match.', 'Password does not match.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (140, 'Please enter new and retype passwords.', 'Please enter new and retype passwords.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (141, 'Password is updated successfully.', 'Password is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (142, 'To reset your password, please click on the link below.', 'To reset your password, please click on the link below.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (143, 'PASSWORD RESET REQUEST - YOUR WEBSITE.COM', 'PASSWORD RESET REQUEST - YOUR WEBSITE.COM');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (144, 'The password reset email time (24 hours) has expired. Please again try to reset your password.', 'The password reset email time (24 hours) has expired. Please again try to reset your password.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (145, 'A confirmation link is sent to your email address. You will get the password reset information in there.', 'A confirmation link is sent to your email address. You will get the password reset information in there.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (146, 'Password is reset successfully. You can now login.', 'Password is reset successfully. You can now login.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (147, 'Email Address Already Exists', 'Email Address Already Exists.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (148, 'Sorry! Your account is inactive. Please contact to the administrator.', 'Sorry! Your account is inactive. Please contact to the administrator.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (149, 'Change Password', 'Change Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (150, 'Registration Email Confirmation for YOUR WEBSITE', 'Registration Email Confirmation for YOUR WEBSITE.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (151, 'Thank you for your registration! Your account has been created. To active your account click on the link below:', 'Thank you for your registration! Your account has been created. To active your account click on the link below:');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (152, 'Your registration is completed. Please check your email address to follow the process to confirm your registration.', 'Your registration is completed. Please check your email address to follow the process to confirm your registration.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (153, 'No Product Found', 'No Product Found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (154, 'Add to Cart', 'Buy Now');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (155, 'Related Products', 'Related Products');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (156, 'See all related products from below', 'See all the related products from below');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (157, 'Size', 'Size');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (158, 'Color', 'Color');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (159, 'Price', 'Price');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (160, 'Please login as customer to checkout', 'Please login as customer to checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (161, 'Billing Address', 'Billing Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (162, 'Shipping Address', 'Shipping Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (163, 'Rating is Submitted Successfully!', 'Rating is Submitted Successfully!');


#
# TABLE STRUCTURE FOR: tbl_mid_category
#

DROP TABLE IF EXISTS `tbl_mid_category`;

CREATE TABLE `tbl_mid_category` (
  `mcat_id` int NOT NULL AUTO_INCREMENT,
  `mcat_pic` varchar(111) NOT NULL,
  `mcat_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `tcat_id` int NOT NULL,
  `status` int NOT NULL,
  `status_home` int NOT NULL,
  PRIMARY KEY (`mcat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (1, 'mid_category-1.jpg', 'Garments', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (2, 'mid_category-2.jpg', 'Ayurveda', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (3, 'mid_category-3.jpg', 'Beauty Care', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (4, 'mid_category-4.jpg', 'Spices', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (5, '', 'Scrap', 1, 1, 1);


#
# TABLE STRUCTURE FOR: tbl_order
#

DROP TABLE IF EXISTS `tbl_order`;

CREATE TABLE `tbl_order` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `product_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `size` varchar(100) NOT NULL,
  `color` varchar(100) NOT NULL,
  `quantity` varchar(50) NOT NULL,
  `unit_price` double NOT NULL,
  `mrp_price` float NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `pv` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (1, 1, '01-SPPVINAYAK CORT PANT', '1 Piece', '', '1', '2500', '3000', '1748590064', '1');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (2, 1, '01-SPPVINAYAK CORT PANT', '1 Piece', '', '1', '2500', '3000', '1748702009', '1');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (3, 1, '01-SPPVINAYAK CORT PANT', '1 Piece', '', '1', '2500', '3000', '1748702731', '1');


#
# TABLE STRUCTURE FOR: tbl_page
#

DROP TABLE IF EXISTS `tbl_page`;

CREATE TABLE `tbl_page` (
  `id` int NOT NULL AUTO_INCREMENT,
  `about_title` varchar(255) NOT NULL,
  `about_content` text NOT NULL,
  `about_banner` varchar(255) NOT NULL,
  `about_meta_title` varchar(255) NOT NULL,
  `about_meta_keyword` text NOT NULL,
  `about_meta_description` text NOT NULL,
  `faq_title` varchar(255) NOT NULL,
  `faq_banner` varchar(255) NOT NULL,
  `faq_meta_title` varchar(255) NOT NULL,
  `faq_meta_keyword` text NOT NULL,
  `faq_meta_description` text NOT NULL,
  `blog_title` varchar(255) NOT NULL,
  `blog_banner` varchar(255) NOT NULL,
  `blog_meta_title` varchar(255) NOT NULL,
  `blog_meta_keyword` text NOT NULL,
  `blog_meta_description` text NOT NULL,
  `contact_title` varchar(255) NOT NULL,
  `contact_banner` varchar(255) NOT NULL,
  `contact_meta_title` varchar(255) NOT NULL,
  `contact_meta_keyword` text NOT NULL,
  `contact_meta_description` text NOT NULL,
  `pgallery_title` varchar(255) NOT NULL,
  `pgallery_banner` varchar(255) NOT NULL,
  `pgallery_meta_title` varchar(255) NOT NULL,
  `pgallery_meta_keyword` text NOT NULL,
  `pgallery_meta_description` text NOT NULL,
  `vgallery_title` varchar(255) NOT NULL,
  `vgallery_banner` varchar(255) NOT NULL,
  `vgallery_meta_title` varchar(255) NOT NULL,
  `vgallery_meta_keyword` text NOT NULL,
  `vgallery_meta_description` text NOT NULL,
  `terms_title` varchar(999) NOT NULL,
  `terms_content` mediumtext NOT NULL,
  `terms_meta_title` varchar(999) NOT NULL,
  `terms_meta_keyword` varchar(999) NOT NULL,
  `terms_meta_description` varchar(999) NOT NULL,
  `privacy_policy_title` varchar(999) NOT NULL,
  `privacy_policy_content` text NOT NULL,
  `privacy_policy_meta_title` varchar(999) NOT NULL,
  `privacy_policy_meta_keyword` varchar(999) NOT NULL,
  `privacy_policy_meta_description` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_page` (`id`, `about_title`, `about_content`, `about_banner`, `about_meta_title`, `about_meta_keyword`, `about_meta_description`, `faq_title`, `faq_banner`, `faq_meta_title`, `faq_meta_keyword`, `faq_meta_description`, `blog_title`, `blog_banner`, `blog_meta_title`, `blog_meta_keyword`, `blog_meta_description`, `contact_title`, `contact_banner`, `contact_meta_title`, `contact_meta_keyword`, `contact_meta_description`, `pgallery_title`, `pgallery_banner`, `pgallery_meta_title`, `pgallery_meta_keyword`, `pgallery_meta_description`, `vgallery_title`, `vgallery_banner`, `vgallery_meta_title`, `vgallery_meta_keyword`, `vgallery_meta_description`, `terms_title`, `terms_content`, `terms_meta_title`, `terms_meta_keyword`, `terms_meta_description`, `privacy_policy_title`, `privacy_policy_content`, `privacy_policy_meta_title`, `privacy_policy_meta_keyword`, `privacy_policy_meta_description`) VALUES (1, 'About Us', '<p></p><div class=\"about-section\" style=\"padding: 20px;\"><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"\"><span style=\"font-family: Impact; font-size: 24px;\">&nbsp;About SPP Vinayak</span></p><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"font-family: Arial, sans-serif;\">SPP Vinayak Solution Private Limited is a dynamic and growth-oriented e-commerce company committed to redefining how people shop and earn online. Established with a vision to empower individuals through digital platforms, we offer a seamless shopping experience combined with innovative income opportunities for our partners and affiliates.</p><p style=\"font-family: Arial, sans-serif;\"><br></p><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"font-family: Arial, sans-serif;\">At SPP Vinayak Solution, we believe in creating a win-win ecosystem. Our platform offers a wide variety of quality products at competitive prices, catering to the everyday needs of consumers. What sets us apart is our focus on financial inclusion—giving individuals from all walks of life the chance to become part of a growing digital business landscape.</p><p style=\"font-family: Arial, sans-serif;\"><br></p><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"font-family: Arial, sans-serif;\">Our affiliate and partnership programs are designed to be simple, transparent, and rewarding. We provide all the tools, training, and support needed for our partners to succeed, including marketing resources, dashboards, and real-time commission tracking. Whether you\'re a student, homemaker, influencer, or business enthusiast, SPP Vinayak Solution provides you with a reliable and scalable way to generate income online.</p><p style=\"font-family: Arial, sans-serif;\"><br></p><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"font-family: Arial, sans-serif;\">We are driven by trust, innovation, and a passion for creating meaningful opportunities. Join us and be part of a movement that’s changing lives through smart commerce and shared success.</p><p style=\"font-family: Arial, sans-serif;\">&nbsp; </p><p style=\"font-family: Arial, sans-serif;\"></p><p style=\"font-family: Arial, sans-serif;\"></p></div><p></p><div><br></div>\r\n', 'about-banner.jpg', 'About Us || SPP Vinayak Solutions Private Limited', 'SPP Vinayak Solutions Private Limited', 'This is a page where we have described details about Tryit India', 'FAQ', 'faq-banner.jpg', 'FAQ', 'SPP Vinayak Solutions Private Limited', 'SPP Vinayak Solutions Private Limited', 'Blog', 'blog-banner.jpg', 'Ecommerce - Blog', '', '', 'Contact Us', 'contact-banner.jpg', ' Contact Us || SPP Vinayak Solutions Private Limited', 'SPP Vinayak Solutions Private Limited', 'SPP Vinayak Solutions Private Limited', 'Photo Gallery', 'pgallery-banner.jpg', 'Ecommerce - Photo Gallery', '', '', 'Video GalleryÅ«', 'vgallery-banner.jpeg', 'Ecommerce  - Video Gallery', '', '', 'Terms & Conditions', '<p><b style=\"border: 0px; margin: 0px 0px 20px; padding: 0px; font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" line-height:=\"\" 1.2em;=\"\" color:=\"\" rgb(58,=\"\" 58,=\"\" 58);=\"\" text-align:=\"\" center;\"=\"\"><span style=\"color: rgb(58, 58, 58);>Last updated:Â&nbsp;</span><span class=\" date\"=\"\">Last Updated : 2020-11-17</span></b></p><p>\r\n\r\n</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">1</span>.&nbsp;<span style=\"font-weight: 700;\">Introduction</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Welcome to SPP Vinayak Solutions Private Limited!</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">These Terms of Service govern your use of our website located at&nbsp;</font><font color=\"#3a3a3a\">SPP Vinayak Solutions Private Limited. (together or individually operated by&nbsp;SPP Vinayak Solutions Private Limited<span style=\"font-size: 0.9rem;\">.</span></font></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Our Privacy Policy also governs your use of our Service and explains how we collect, safeguard, and disclose information that results from your use of our web pages.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Your agreement with us includes these Terms and our Privacy Policy (term &amp; condition). You acknowledge that you have read and understood Agreements, and agree to be bound by them.</p><p style=\"text-align: left; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">If you do not agree with (or cannot comply with) Agreements, then you may not use the Service, but please let us know by emailing at&nbsp;<b>support@</b></font><font color=\"#3a3a3a\"><b>sppvinayak.com</b>&nbsp;so we can try to find a solution. These Terms apply to all visitors, users, and others who wish to access or use Service.</font></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">2</span>.&nbsp;<span style=\"font-weight: 700;\">Communications</span></p><p style=\"text-align: left; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">By using our Service, you agree to subscribe to newsletters, marketing or promotional materials, and other information we may send. However, you may opt out of receiving any, or all, of these communications from us by following the unsubscribe link or by emailing at&nbsp;</font><span class=\"email\" style=\"color: rgb(58, 58, 58); border: 0px; margin: 0px; padding: 0px;\">support@</span><span style=\"text-align: left;\"><font color=\"#3a3a3a\"><b>sppvinayak.com</b></font></span></p><div id=\"purchases\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">3</span>.&nbsp;<span style=\"font-weight: 700;\">Purchases</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">If you wish to purchase any product or service made available through Service (sale or purchase or services), you may be asked to supply certain information relevant to your Purchase including but not limited to, your credit or debit card number, the expiration date of your card, your billing address, and your shipping information.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You represent and warrant that: (i) you have the legal right to use any card(s) or other payment methods (s) in connection with any Purchase; and that (ii) the information you supply to us is true, correct, and complete.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We may employ the use of third-party services for the purpose of facilitating payment and the completion of Purchases. By submitting your information, you grant us the right to provide the information to these third parties subject to our Privacy Policy.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse or cancel your order at any time for reasons including but not limited to product or service availability, errors in the description or price of the product or service, error in your order, or other reasons.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse or cancel your order if fraud or an unauthorized or illegal transaction is suspected.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">4</span>.&nbsp;<span style=\"font-weight: 700;\">Contests, Sweepstakes, and Promotions</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Any contests, sweepstakes or other promotions (collectively) made available through Service may be governed by rules that are separate from these Terms of Service. If you participate in any Promotions, please review the applicable rules as well as our Privacy Policy. If the rules for a Promotion conflict with these Terms of Service, Promotion rules will apply.</p><div id=\"subscriptions\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"></div><div id=\"refunds\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">5</span>.&nbsp;<span style=\"font-weight: 700;\">Refunds</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We issue refunds for Contracts within&nbsp;<span style=\"font-weight: 700;\"><span class=\"refund-days\" style=\"border: 0px; margin: 0px; padding: 0px;\">1</span>&nbsp;day</span>&nbsp;of the original purchase of the Contract.</p></div><div id=\"tc-content\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">6</span>.&nbsp;<span style=\"font-weight: 700;\">Content</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">The content found on or through this Service are the property of sppvinayak&nbsp; or used with this permission. You may not distribute, modify, transmit, reuse, download, repost, copy, or use said Content, whether in whole or in part, for commercial purposes or for personal gain, without express advance written permission from us.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">7</span>.&nbsp;<span style=\"font-weight: 700;\">Prohibited Uses</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You may use Service only for lawful purposes and in accordance with Terms. You agree not to use Service:</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.1. In any way that violates any applicable national or international law or regulation.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.2. For the purpose of exploiting, harming, or attempting to exploit or harm minors in any way by exposing them to inappropriate content or otherwise.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.3. To transmit, or procure the sending of, any advertising or promotional material, including any junk mail, chain letter, spam, or any other similar solicitation.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.4. To impersonate or attempt to impersonate Company, a Company employee, another user, or any other person or entity.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.5. In any way that infringes upon the rights of others, or in any way is illegal, threatening, fraudulent, or harmful, or in connection with any unlawful, illegal, fraudulent, or harmful purpose or activity.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.6. To engage in any other conduct that restricts or inhibits anyone use or enjoyment of Service, or which, as determined by us, may harm or offend Company or users of Service or expose them to liability.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Additionally, you agree not to:</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.1. Use Service in any manner that could disable, overburden, damage, or impair Service or interfere with any other party use of Service, including their ability to engage in real-time activities through Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.2. Use any robot, spider, or other automatic devices, process, or means to access Service for any purpose, including monitoring or copying any of the material on Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.3. Use any manual process to monitor or copy any of the material on Service or for any other unauthorized purpose without our prior written consent.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.4. Use any device, software, or routine that interferes with the proper working of Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.5. Introduce any viruses, trojan horses, worms, logic bombs, or other material which is malicious or technologically harmful.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.6. Attempt to gain unauthorized access to, interfere with, damage, or disrupt any parts of Service, the server on which Service is stored, or any server, computer, or database connected to Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.7. Attack Service via a denial-of-service attack or a distributed denial-of-service attack.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.8. Take any action that may damage or falsify the Company rating.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.9. Otherwise attempt to interfere with the proper working of Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">8</span>.&nbsp;<span style=\"font-weight: 700;\">Analytics</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We may use third-party Service Providers to monitor and analyze the use of our Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">9</span>.&nbsp;<span style=\"font-weight: 700;\">No Use By Minors</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Service is intended only for access and use by individuals at least eighteen (18) years old. By accessing or using Service, you warrant and represent that you are at least eighteen (18) years of age and with the full authority, right, and capacity to enter into this agreement and abide by all of the terms and conditions of Terms. If you are not at least eighteen (18) years old, you are prohibited from both the access and usage of Service.</p><div id=\"account\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">10</span>.&nbsp;<span style=\"font-weight: 700;\">Accounts</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">When you create an account with us, you guarantee that you are above the age of 18 and that the information you provide us is accurate, complete, and current at all times. Inaccurate, incomplete, or obsolete information may result in the immediate termination of your account on Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You are responsible for maintaining the confidentiality of your account and password, including but not limited to the restriction of access to your computer and/or account. You agree to accept responsibility for any and all activities or actions that occur under your account and/or password, whether your password is with our Service or a third-party service. You must notify us immediately upon becoming aware of any breach of security or unauthorized use of your account.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You may not use as a username the name of another person or entity or that is not lawfully available for use, a name or trademark that is subject to any rights of another person or entity other than you, without appropriate authorization. You may not use as a username any name that is offensive, vulgar, or obscene.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse service, terminate accounts, remove or edit content, or cancel orders at our sole discretion.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><br></p>', 'Terms & Conditions || SPP Vinayak Solutions Private Limited', 'Terms & Conditions,Terms & Conditions || SPP Vinayak Solutions Private Limited', 'Welcome to SPP Vinayak Solutions Private Limited!\r\nThese terms and conditions outline the rules and regulations for the use of SPP Vinayak Solutions Private Limited\'s Website, located at https://www.sppvinayak.com', 'PRIVCY POLICY || SPP Vinayak Solutions Private Limited', '<p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><span style=\"margin: 0px; padding: 0px;\">Privacy Policy</span></p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We value the trust you place in us and recognize the importance of secure transactions and information privacy. This Privacy Policy describes how SPP Vinayak Solutions Private Limited and its affiliates (collectively “SSP Vinayak, we, our, us”) collect, use, share or otherwise process your personal information through SPP Vinayak website&nbsp;<a href=\"http://www.flipkart.com/\" style=\"margin: 0px; padding: 0px; color: inherit; border: none; outline: none;\">www.tryitindia.com</a>, its mobile application, and m-site (hereinafter referred to as the “Platform”).</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">While you may be able to browse certain sections of the Platform without registering with us, however, please note we do not offer any product/service under this Platform outside India. By visiting this Platform, providing your information or availing out product/service, you expressly agree to be bound by the terms and conditions of this Privacy Policy, the&nbsp;<a href=\"https://www.flipkart.com/pages/terms\" style=\"margin: 0px; padding: 0px; color: inherit; border: none; outline: none;\">Terms of Use</a>&nbsp;and the applicable service/product terms and conditions, and agree to be governed by the laws of India including but not limited to the laws applicable to data protection and privacy. If you do not agree please do not use or access our Platform.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><span style=\"margin: 0px; padding: 0px;\">1. Collection of Your Information</span></p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">When you use our Platform, we collect and store your information which is provided by you from time to time. In general, you can browse the Platform without telling us who you are or revealing any personal information about yourself. Once you give us your personal information, you are not anonymous to us. Where possible, we indicate which fields are required and which fields are optional. You always have the option to not provide information by choosing not to use a particular service, product or feature on the Platform.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We may track your buying behavior, preferences, and other information that you choose to provide on our Platform. We use this information to do internal research on our users\' demographics, interests, and behavior to better understand, protect and serve our users. This information is compiled and analyses on an aggregated basis. This information may include the URL that you just came from (whether this URL is on our Platform or not), which URL you next go to (whether this URL is on our Platform or not), your computer browser information, and your IP address.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We collect personal information (such as email address, delivery address, name, phone number, credit card/debit card and other payment instrument details) from you when you set up an account or transact with us. While you can browse some sections of our Platform without being a registered member, certain activities (such as placing an order or consuming our online content or services) do require registration. We do use your contact information to send you offers based on your previous orders and your interests.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">If you choose to post messages on our message boards, chat rooms or other message areas or leave feedback or if you use voice commands to shop on the Platform, we will collect that information you provide to us. We retain this information as necessary to resolve disputes, provide customer support and troubleshoot problems as permitted by law.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">If you send us personal correspondence, such as emails or letters, or if other users or third parties send us correspondence about your activities or postings on the Platform, we may collect such information into a file specific to you.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><br></p><p>PRIVACY POLICY || SPP Vinayak Solutions Private Limited<br></p>', 'PRIVCY POLICY || SPP Vinayak Solutions Private Limited', 'PRIVACY POLICY || TSPP Vinayak Solutions Private Limited', 'PRIVACY POLICY || SPP Vinayak Solutions Private Limited');


#
# TABLE STRUCTURE FOR: tbl_payment
#

DROP TABLE IF EXISTS `tbl_payment`;

CREATE TABLE `tbl_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `payment_date` varchar(50) NOT NULL,
  `txnid` varchar(255) NOT NULL,
  `paid_amount` int NOT NULL,
  `card_number` varchar(50) NOT NULL,
  `card_cvv` varchar(10) NOT NULL,
  `card_month` varchar(10) NOT NULL,
  `card_year` varchar(10) NOT NULL,
  `bank_transaction_info` text NOT NULL,
  `payment_method` varchar(20) NOT NULL,
  `payment_status` varchar(25) NOT NULL,
  `shipping_status` varchar(20) NOT NULL,
  `shipping_date` varchar(999) NOT NULL,
  `delivery_date` varchar(999) NOT NULL,
  `cancelled_date` varchar(999) NOT NULL,
  `returned_date` varchar(999) NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `add_time` varchar(999) NOT NULL,
  `tpv` float NOT NULL,
  `db_id` varchar(999) NOT NULL,
  `dcode` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (1, 347, 'Vishal Kumar ', 'vishaldastanti@gmail.com', '2025-05-30 12:57:44', '', 2, 'Dues', '', '', '', 'This Booking By COD. At 30 May 2025 12:57:43 PM.  ', 'COD', 'Completed', 'Cancelled', '', '', '2025-05-30 14:28:45', '', '1748590064', '', '1', '', '3226');
INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (2, 324, 'BIKASH KUMAR DAS', 'bkdaskol@gmail.com', '2025-05-31 20:03:29', '', 2, 'Dues', '', '', '', 'This Booking By COD. At 31 May 2025 08:03:27 PM.  ', 'COD', 'Completed', 'Arrive', '2025-06-02 13:55:49', '', '', '', '1748702009', '', '1', '', '9569');
INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (3, 324, 'BIKASH KUMAR DAS', 'bkdaskol@gmail.com', '2025-05-31 20:15:31', '', 2, 'Dues', '', '', '', 'This Booking By COD. At 31 May 2025 08:15:15 PM.  ', 'COD', 'Completed', 'Cancelled', '', '', '2025-06-02 13:55:09', '', '1748702731', '', '1', '', '7151');


#
# TABLE STRUCTURE FOR: tbl_photo
#

DROP TABLE IF EXISTS `tbl_photo`;

CREATE TABLE `tbl_photo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `caption` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `title` varchar(111) DEFAULT NULL,
  `link` varchar(111) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_photo` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (9, '', 'https://www.sppvinayak.com/uploads/website/gallery/gallery-1-1673847928.jpg', 'Image Title 1 - Description of image goes here.', '#', 1);
INSERT INTO `tbl_photo` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (10, '', 'https://www.sppvinayak.com/uploads/website/gallery/gallery-10-1748626088.jpg', 'Image Title 2 - Description of image goes here.', '#', 1);
INSERT INTO `tbl_photo` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (11, '', 'https://www.sppvinayak.com/uploads/website/gallery/gallery-11-910992315.jpg', 'Image Title 3 - Description of image goes here.', '#', 1);


#
# TABLE STRUCTURE FOR: tbl_photo1
#

DROP TABLE IF EXISTS `tbl_photo1`;

CREATE TABLE `tbl_photo1` (
  `id` int NOT NULL AUTO_INCREMENT,
  `caption` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `title` varchar(111) DEFAULT NULL,
  `link` varchar(111) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_photo1` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (13, '', 'https://www.sppvinayak.com/uploads/website/Achiever/Achiever-1-546817902.JPG', 'Raushan Kumar', 'SPP010101', 1);


#
# TABLE STRUCTURE FOR: tbl_photo2
#

DROP TABLE IF EXISTS `tbl_photo2`;

CREATE TABLE `tbl_photo2` (
  `id` int NOT NULL AUTO_INCREMENT,
  `caption` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `title` varchar(111) DEFAULT NULL,
  `link` varchar(111) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_photo2` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (17, '', '', 'SPP VINAYAK', 'SPP VINAYAK SOLUTION PRIVATE LIMITED ', 1);
INSERT INTO `tbl_photo2` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (24, '', '', 'Motivation', 'positive thinking always leads to success', 1);
INSERT INTO `tbl_photo2` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (25, '', '', 'Motivation', 'positive thinking always leads to success', 1);
INSERT INTO `tbl_photo2` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (26, '', '', 'Motivation', 'positive thinking always leads to success', 1);
INSERT INTO `tbl_photo2` (`id`, `caption`, `photo`, `title`, `link`, `status`) VALUES (27, '', '', 'Motivation', 'positive thinking always leads to success', 1);


#
# TABLE STRUCTURE FOR: tbl_pin
#

DROP TABLE IF EXISTS `tbl_pin`;

CREATE TABLE `tbl_pin` (
  `pin_id` int NOT NULL AUTO_INCREMENT,
  `pin` int NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`pin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (1, 842001, '2021-07-16 18:56:35', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (2, 842002, '2021-07-16 18:56:45', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (3, 842003, '2021-07-16 18:56:53', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (4, 842004, '2021-07-22 14:54:00', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (5, 842005, '2021-07-22 14:54:12', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (6, 843108, '2021-07-22 14:54:29', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (7, 843113, '2021-07-22 14:56:39', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (8, 843147, '2021-07-22 14:57:00', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (9, 843165, '2021-07-22 14:57:38', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (10, 844117, '2025-06-05 14:20:17', 1);


#
# TABLE STRUCTURE FOR: tbl_post
#

DROP TABLE IF EXISTS `tbl_post`;

CREATE TABLE `tbl_post` (
  `post_id` int NOT NULL AUTO_INCREMENT,
  `post_title` varchar(255) NOT NULL,
  `post_slug` varchar(255) NOT NULL,
  `post_content` text NOT NULL,
  `post_date` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `category_id` int NOT NULL,
  `total_view` int NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_product
#

DROP TABLE IF EXISTS `tbl_product`;

CREATE TABLE `tbl_product` (
  `p_id` int NOT NULL AUTO_INCREMENT,
  `p_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `p_keyword` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `p_old_price` varchar(10) NOT NULL,
  `p_current_price` varchar(10) NOT NULL,
  `p_qty` int NOT NULL,
  `p_featured_photo` varchar(255) NOT NULL,
  `p_description` text NOT NULL,
  `p_short_description` text NOT NULL,
  `p_feature` text NOT NULL,
  `p_condition` text NOT NULL,
  `p_return_policy` text NOT NULL,
  `p_total_view` int NOT NULL,
  `p_is_featured` int NOT NULL,
  `p_is_active` int NOT NULL,
  `p_is_active_home` int NOT NULL,
  `todays_best_deal` int NOT NULL,
  `tcat_id` int NOT NULL,
  `mcat_id` int NOT NULL,
  `ecat_id` int NOT NULL,
  `user` varchar(110) NOT NULL,
  `p_type` int DEFAULT NULL,
  `sett` int NOT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (1, '01-SPPVINAYAK CORT PANT', '01-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_1.jpg', '<p><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color 1-piece formal suit</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit single-breasted blazer, has a notched lapel with button closures, long sleeves, three pockets</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit trousers has an elasticated waisted with zip closure, two pockets</span></p>', '', '<p><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color 1-piece formal suit</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit single-breasted blazer, has a notched lapel with button closures, long sleeves, three pockets</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit trousers has an elasticated waisted with zip closure, two pockets</span></p>', '<p><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color 1-piece formal suit</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit single-breasted blazer, has a notched lapel with button closures, long sleeves, three pockets</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit trousers has an elasticated waisted with zip closure, two pockets</span></p>', '<p><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color 1-piece formal suit</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit single-breasted blazer, has a notched lapel with button closures, long sleeves, three pockets</span><br style=\"box-sizing: inherit; color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\">Gray Color</span><span style=\"color: rgb(40, 44, 63); font-family: Assistant, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, Helvetica, Arial, sans-serif; font-size: 16px;\"> regular-fit trousers has an elasticated waisted with zip closure, two pockets</span></p>', 121, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (2, '02-SPPVINAYAK CORT PANT', '02-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_2.jpg', '', '', '', '', '', 91, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (3, '03-SPPVINAYAK CORT PANT', '03-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_3.jpg', '', '', '', '', '', 121, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (4, '04-SPPVINAYAK CORT PANT', '04-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_4.jpg', '', '', '', '', '', 99, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (5, '05-SPPVINAYAK CORT PANT', '05-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_5.jpg', '', '', '', '', '', 84, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (6, '06-SPPVINAYAK CORT PANT', '06-SPPVINAYAK CORT PANT', '', '', '', 0, 'Product_6.jpg', '', '', '', '', '', 95, 0, 1, 0, 1, 1, 1, 1, '', NULL, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (18, 'Carton Craf 1kg @5%', 'Carton 1kg @5%', '', '', '', 0, '', '', '', '', '', '', 0, 0, 1, 0, 0, 1, 5, 11, '', NULL, 0);


#
# TABLE STRUCTURE FOR: tbl_product_photo
#

DROP TABLE IF EXISTS `tbl_product_photo`;

CREATE TABLE `tbl_product_photo` (
  `pp_id` int NOT NULL AUTO_INCREMENT,
  `photo` varchar(255) NOT NULL,
  `p_id` int NOT NULL,
  PRIMARY KEY (`pp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_product_size
#

DROP TABLE IF EXISTS `tbl_product_size`;

CREATE TABLE `tbl_product_size` (
  `id` int NOT NULL AUTO_INCREMENT,
  `size_id` int DEFAULT NULL,
  `color_id` varchar(255) DEFAULT NULL,
  `p_old_price` float NOT NULL,
  `p_current_price` float NOT NULL,
  `p_qty` int NOT NULL,
  `p_min_qty` int NOT NULL,
  `p_id` int NOT NULL,
  `p_featured_photo` varchar(999) NOT NULL,
  `p_dp_price` float DEFAULT NULL,
  `p_pv` float DEFAULT NULL,
  `user` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (2, 247, '', '3000', '2500', 100, 5, 1, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (4, 307, '', '2999', '2500', 7, 2, 2, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (5, 307, '', '2999', '2500', 10, 2, 3, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (6, 307, '', '2999', '2500', 10, 2, 4, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (7, 307, '', '2999', '2500', 10, 2, 5, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (8, 307, '', '2999', '2500', 10, 2, 6, '', '0', '1', '1');
INSERT INTO `tbl_product_size` (`id`, `size_id`, `color_id`, `p_old_price`, `p_current_price`, `p_qty`, `p_min_qty`, `p_id`, `p_featured_photo`, `p_dp_price`, `p_pv`, `user`) VALUES (27, 176, '', '15', '15', 9900, 1000, 18, '', '0', '5', '1');


#
# TABLE STRUCTURE FOR: tbl_rating
#

DROP TABLE IF EXISTS `tbl_rating`;

CREATE TABLE `tbl_rating` (
  `rt_id` int NOT NULL AUTO_INCREMENT,
  `p_id` int NOT NULL,
  `cust_id` int NOT NULL,
  `comment` text NOT NULL,
  `rating` int NOT NULL,
  PRIMARY KEY (`rt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_service
#

DROP TABLE IF EXISTS `tbl_service`;

CREATE TABLE `tbl_service` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `photo` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_settings
#

DROP TABLE IF EXISTS `tbl_settings`;

CREATE TABLE `tbl_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `currency` varchar(11) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `footer_logo` varchar(999) NOT NULL,
  `favicon` varchar(255) NOT NULL,
  `share_image` varchar(880) NOT NULL,
  `footer_about` text NOT NULL,
  `footer_copyright` text NOT NULL,
  `contact_address` text NOT NULL,
  `contact_email` varchar(255) NOT NULL,
  `contact_phone` varchar(255) NOT NULL,
  `web_url` varchar(999) NOT NULL,
  `app_url` varchar(999) NOT NULL,
  `contact_fax` varchar(255) NOT NULL,
  `contact_map_iframe` text NOT NULL,
  `receive_email` varchar(255) NOT NULL,
  `receive_email_subject` varchar(255) NOT NULL,
  `receive_email_thank_you_message` text NOT NULL,
  `forget_password_message` text NOT NULL,
  `total_recent_post_footer` int NOT NULL,
  `total_popular_post_footer` int NOT NULL,
  `total_recent_post_sidebar` int NOT NULL,
  `total_popular_post_sidebar` int NOT NULL,
  `total_featured_product_home` int NOT NULL,
  `total_latest_product_home` int NOT NULL,
  `total_popular_product_home` int NOT NULL,
  `meta_title_home` text NOT NULL,
  `base_name` varchar(999) NOT NULL,
  `meta_keyword_home` text NOT NULL,
  `meta_description_home` text NOT NULL,
  `banner_login` varchar(255) NOT NULL,
  `banner_registration` varchar(255) NOT NULL,
  `banner_forget_password` varchar(255) NOT NULL,
  `banner_reset_password` varchar(255) NOT NULL,
  `banner_search` varchar(255) NOT NULL,
  `banner_cart` varchar(255) NOT NULL,
  `banner_checkout` varchar(255) NOT NULL,
  `banner_product_category` varchar(255) NOT NULL,
  `banner_blog` varchar(255) NOT NULL,
  `cta_title` varchar(255) NOT NULL,
  `cta_content` text NOT NULL,
  `cta_read_more_text` varchar(255) NOT NULL,
  `cta_read_more_url` varchar(255) NOT NULL,
  `cta_photo` varchar(255) NOT NULL,
  `featured_product_title` varchar(255) NOT NULL,
  `featured_product_subtitle` varchar(255) NOT NULL,
  `latest_product_title` varchar(255) NOT NULL,
  `latest_product_subtitle` varchar(255) NOT NULL,
  `popular_product_title` varchar(255) NOT NULL,
  `popular_product_subtitle` varchar(255) NOT NULL,
  `testimonial_title` varchar(255) NOT NULL,
  `testimonial_subtitle` varchar(255) NOT NULL,
  `testimonial_photo` varchar(255) NOT NULL,
  `blog_title` varchar(255) NOT NULL,
  `blog_subtitle` varchar(255) NOT NULL,
  `newsletter_text` text NOT NULL,
  `paypal_email` varchar(255) NOT NULL,
  `stripe_public_key` varchar(255) NOT NULL,
  `stripe_secret_key` varchar(255) NOT NULL,
  `bank_detail` text NOT NULL,
  `before_head` text NOT NULL,
  `after_body` text NOT NULL,
  `before_body` text NOT NULL,
  `home_service_on_off` int NOT NULL,
  `home_welcome_on_off` int NOT NULL,
  `home_featured_product_on_off` int NOT NULL,
  `home_latest_product_on_off` int NOT NULL,
  `home_popular_product_on_off` int NOT NULL,
  `home_testimonial_on_off` int NOT NULL,
  `home_blog_on_off` int NOT NULL,
  `newsletter_on_off` int NOT NULL,
  `ads_above_welcome_on_off` int NOT NULL,
  `ads_above_featured_product_on_off` int NOT NULL,
  `ads_above_latest_product_on_off` int NOT NULL,
  `ads_above_popular_product_on_off` int NOT NULL,
  `ads_above_testimonial_on_off` int NOT NULL,
  `ads_category_sidebar_on_off` int NOT NULL,
  `color` varchar(10) NOT NULL,
  `special` int DEFAULT NULL,
  `spt` varchar(110) NOT NULL,
  `sps` varchar(110) NOT NULL,
  `total_special_product_home` int DEFAULT NULL,
  `vendor` int NOT NULL,
  `shop` int NOT NULL,
  `mlm` int NOT NULL,
  `sms_sender` varchar(999) NOT NULL,
  `sms_user` varchar(999) NOT NULL,
  `sms_pass` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_settings` (`id`, `currency`, `logo`, `footer_logo`, `favicon`, `share_image`, `footer_about`, `footer_copyright`, `contact_address`, `contact_email`, `contact_phone`, `web_url`, `app_url`, `contact_fax`, `contact_map_iframe`, `receive_email`, `receive_email_subject`, `receive_email_thank_you_message`, `forget_password_message`, `total_recent_post_footer`, `total_popular_post_footer`, `total_recent_post_sidebar`, `total_popular_post_sidebar`, `total_featured_product_home`, `total_latest_product_home`, `total_popular_product_home`, `meta_title_home`, `base_name`, `meta_keyword_home`, `meta_description_home`, `banner_login`, `banner_registration`, `banner_forget_password`, `banner_reset_password`, `banner_search`, `banner_cart`, `banner_checkout`, `banner_product_category`, `banner_blog`, `cta_title`, `cta_content`, `cta_read_more_text`, `cta_read_more_url`, `cta_photo`, `featured_product_title`, `featured_product_subtitle`, `latest_product_title`, `latest_product_subtitle`, `popular_product_title`, `popular_product_subtitle`, `testimonial_title`, `testimonial_subtitle`, `testimonial_photo`, `blog_title`, `blog_subtitle`, `newsletter_text`, `paypal_email`, `stripe_public_key`, `stripe_secret_key`, `bank_detail`, `before_head`, `after_body`, `before_body`, `home_service_on_off`, `home_welcome_on_off`, `home_featured_product_on_off`, `home_latest_product_on_off`, `home_popular_product_on_off`, `home_testimonial_on_off`, `home_blog_on_off`, `newsletter_on_off`, `ads_above_welcome_on_off`, `ads_above_featured_product_on_off`, `ads_above_latest_product_on_off`, `ads_above_popular_product_on_off`, `ads_above_testimonial_on_off`, `ads_category_sidebar_on_off`, `color`, `special`, `spt`, `sps`, `total_special_product_home`, `vendor`, `shop`, `mlm`, `sms_sender`, `sms_user`, `sms_pass`) VALUES (1, '&#8377;', 'logo-2081267169-.png', 'footer_logo-701720180-.png', 'favicon-1139944507-.png', 'share_image-730923551-.png', 'Enexa IT Solutions Pvt Ltd', '© Copyright  2025 Enexa IT Solutions Pvt Ltd  . All Rights Reserved.', 'Muzaffarpur Bihar', 'example@gmail.com', '9876543210', 'www.enexademo.in/cibil', '#', '9876543210', '<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d28662.015533818103!2d85.35630678845557!3d26.107014942774423!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39ed11a78f368515%3A0xd1bbedaa809cb570!2sJajba%20muz%20office!5e0!3m2!1sen!2sin!4v1626346294942!5m2!1sen!2sin\" width=\"500\" height=\"400\" style=\"border:0;\" allowfullscreen=\"\" loading=\"lazy\"></iframe>', 'anoopkirana01@gmail.com', 'Visitor Email Message from www.Anoopkirana.in', 'Thank you for sending email. We will contact you shortly.', 'A confirmation link is sent to your email address. You will get the password reset information in there.', 0, 0, 0, 0, 10, 10, 10, 'ENEXA ERP CIBIL', 'Enexa IT Solutions Pvt Ltd', 'ENEXA ERP CIBIL', 'ENEXA ERP CIBIL', 'banner_login.png', 'banner_registration454296033.jpg', 'banner_forget_password677306323.jpg', 'banner_reset_password631180328.jpg', 'banner_search698526825.jpg', 'banner_cart1705349562.jpg', 'banner_checkout238919124.jpg', 'banner_product_category1186272307.jpg', 'banner_blog690679890.jpg', 'Welcome To ', '<p>Welcome</p>', 'Read More', '#', 'cta222270325.jpg', 'Featured Products', 'See all our featured products from here', 'Latest Products', 'See all our latest products from here', 'Popular Products', 'See all our popular products from here', 'Testimonials', 'See what our clients tell about us', 'testimonial1512564621.jpg', 'Latest Blog', 'See all our latest articles and news from below', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aliquid fugit expedita, iure ullam cum vero ex sint aperiam maxime.', 'biz111@shop.com', 'pk_test_0SwMWadgu8DwmEcPdUPRsZ7b', 'sk_test_TFcsLJ7xxUtpALbDo1L5c1PN', '\r\nBank Name: ABC Bank\r\nAccount Number: 1222320234444\r\nBranch Name: NY Branch\r\nCountry: USA', '<script async src=\"https://www.googletagmanager.com/gtag/js?id=GA_TRACKING_ID\"></script>\r\n<script>\r\n  window.dataLayer = window.dataLayer || [];\r\n  function gtag(){dataLayer.push(arguments);}\r\n  gtag(\'js\', new Date());\r\n\r\n  gtag(\'config\', \'GA_TRACKING_ID\');\r\n</script>', '<div id=\"fb-root\"></div>\r\n<script>(function(d, s, id) {\r\n  var js, fjs = d.getElementsByTagName(s)[0];\r\n  if (d.getElementById(id)) return;\r\n  js = d.createElement(s); js.id = id;\r\n  js.src = \"//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.10&appId=323620764400430\";\r\n  fjs.parentNode.insertBefore(js, fjs);\r\n}(document, \'script\', \'facebook-jssdk\'));</script>', '<!--Start of Tawk.to Script-->\r\n<script type=\"text/javascript\">\r\nvar Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();\r\n(function(){\r\nvar s1=document.createElement(\"script\"),s0=document.getElementsByTagName(\"script\")[0];\r\ns1.async=true;\r\ns1.src=\'https://embed.tawk.to/5a7c31ded7591465c7077c48/default\';\r\ns1.charset=\'UTF-8\';\r\ns1.setAttribute(\'crossorigin\',\'*\');\r\ns0.parentNode.insertBefore(s1,s0);\r\n})();\r\n</script>\r\n<!--End of Tawk.to Script-->', 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, '#7FAE54', 1, 'Holi Special Product', 'Purchase Your Holi Need products Here', 10, 0, 0, 1, '1', '1', '1');


#
# TABLE STRUCTURE FOR: tbl_shipping_cost
#

DROP TABLE IF EXISTS `tbl_shipping_cost`;

CREATE TABLE `tbl_shipping_cost` (
  `shipping_cost_id` int NOT NULL AUTO_INCREMENT,
  `country_id` varchar(110) NOT NULL,
  `amount` varchar(20) NOT NULL,
  PRIMARY KEY (`shipping_cost_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_shipping_cost_all
#

DROP TABLE IF EXISTS `tbl_shipping_cost_all`;

CREATE TABLE `tbl_shipping_cost_all` (
  `sca_id` int NOT NULL AUTO_INCREMENT,
  `amount` float NOT NULL,
  `min_amt` float NOT NULL,
  `max_amt` float NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`sca_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_shipping_cost_all` (`sca_id`, `amount`, `min_amt`, `max_amt`, `addon`, `status`) VALUES (1, '10', '1', '200', '2021-07-16 18:27:58', 1);


#
# TABLE STRUCTURE FOR: tbl_size
#

DROP TABLE IF EXISTS `tbl_size`;

CREATE TABLE `tbl_size` (
  `size_id` int NOT NULL AUTO_INCREMENT,
  `size_name` varchar(255) NOT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`size_id`)
) ENGINE=InnoDB AUTO_INCREMENT=308 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (131, '3g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (132, '5g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (133, '7g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (134, '10g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (135, '15g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (136, '20g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (137, '25g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (138, '30g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (139, '35g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (140, '40g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (141, '45g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (142, '50g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (143, '55g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (144, '60g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (145, '65g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (146, '70g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (147, '75g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (148, '80g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (149, '85g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (150, '90g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (151, '95g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (152, '100g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (153, '105g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (154, '110g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (155, '115g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (156, '120g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (157, '125g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (158, '130g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (159, '135g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (160, '140g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (161, '145g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (162, '150g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (163, '160g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (164, '175g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (165, '200g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (166, '225g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (167, '250g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (168, '300g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (169, '350g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (170, '400g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (171, '500g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (172, '600g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (173, '700g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (174, '750g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (175, '800g', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (176, '1Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (177, '1.25 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (178, '1.5 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (179, '1.75 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (180, '2 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (181, '2.25 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (182, '2.5 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (183, '2.75 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (184, '3 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (185, '3.5 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (186, '4 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (187, '5 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (188, '6 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (189, '10 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (190, '15 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (191, '20 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (192, '25 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (193, '30 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (194, '50 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (195, '5ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (196, '10ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (197, '15ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (198, '20ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (199, '25ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (200, '30ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (201, '40ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (202, '50ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (203, '60ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (204, '70ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (205, '75ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (206, '80ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (207, '90ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (208, '100ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (209, '110 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (210, '115 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (211, '120 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (212, '125ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (213, '130ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (214, '135ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (215, '140 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (216, '150 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (217, '160 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (218, '170 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (219, '180 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (220, '200 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (221, '225 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (222, '250 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (223, '275 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (224, '300 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (225, '350 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (226, '400 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (227, '450 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (228, '500 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (229, '600 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (230, '700 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (231, '750 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (232, '800 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (233, '900 ml', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (234, '1 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (235, '1.25 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (236, '1.5 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (237, '1.75 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (238, '2 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (239, '2.25 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (240, '2.5 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (241, '2.75 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (242, '3 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (243, '5 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (244, '10 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (245, '15 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (246, '20 L', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (247, '1 Piece', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (248, '2 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (249, '3 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (250, '4 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (251, '5 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (252, '6 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (253, '7 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (254, '8 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (255, '9 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (256, '10 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (257, '11 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (258, '12 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (259, '13 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (260, '14 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (261, '15 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (262, '16 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (263, '17 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (264, '18 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (265, '19 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (266, '20 pcs', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (267, '1 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (268, '1.5 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (269, '2 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (270, '3 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (271, '4 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (272, '5 dozen', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (273, '1 Carton', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (274, '2 Cartons', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (275, '3 Cartons', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (276, '4 Cartons', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (277, '5 Cartons', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (278, '1 Packet', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (279, '2 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (280, '3 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (281, '4 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (282, '5 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (283, '6 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (284, '7 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (285, '8 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (286, '9 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (287, '10 pkts', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (288, '18 Kg', NULL);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (289, 'ONE CARAT ', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (290, 'SIZE ONE PC 44 ', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (291, 'SIZE ONE PC 46', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (292, '12g', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (293, '560g', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (294, '950 gm', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (295, '950 gm', 0);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (296, 'XL+', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (297, '330g', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (298, '780ml', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (299, '650ml', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (300, '650ml', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (301, '975 ML', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (302, '12 hour', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (303, '45ml', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (304, '78g', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (305, '50 pcs', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (306, '8g', 1);
INSERT INTO `tbl_size` (`size_id`, `size_name`, `status`) VALUES (307, '1 Set', 1);


#
# TABLE STRUCTURE FOR: tbl_slider
#

DROP TABLE IF EXISTS `tbl_slider`;

CREATE TABLE `tbl_slider` (
  `id` int NOT NULL AUTO_INCREMENT,
  `photo` varchar(255) NOT NULL,
  `title` varchar(111) DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `button_text` varchar(255) NOT NULL,
  `button_url` varchar(255) NOT NULL,
  `position` varchar(255) NOT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_slider` (`id`, `photo`, `title`, `heading`, `content`, `button_text`, `button_url`, `position`, `status`) VALUES (2, 'slider_969053715_2.jpg', 'Welcome', '', '', '', '#', '', 1);
INSERT INTO `tbl_slider` (`id`, `photo`, `title`, `heading`, `content`, `button_text`, `button_url`, `position`, `status`) VALUES (3, 'slider_1807934187_3.jpg', '#', '', '', '', '#', '', 1);


#
# TABLE STRUCTURE FOR: tbl_sms
#

DROP TABLE IF EXISTS `tbl_sms`;

CREATE TABLE `tbl_sms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_social
#

DROP TABLE IF EXISTS `tbl_social`;

CREATE TABLE `tbl_social` (
  `social_id` int NOT NULL AUTO_INCREMENT,
  `social_name` varchar(30) NOT NULL,
  `social_url` varchar(255) NOT NULL,
  `social_icon` varchar(30) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`social_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_state
#

DROP TABLE IF EXISTS `tbl_state`;

CREATE TABLE `tbl_state` (
  `id` int NOT NULL AUTO_INCREMENT,
  `state` varchar(999) DEFAULT NULL,
  `code` int NOT NULL,
  `status` int DEFAULT NULL,
  `addon` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (1, 'Bihar', 10, 1, '2021-03-17 03:17:53');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (7, 'UP', 9, 1, '2021-06-27 22:53:13');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (8, 'Jharkhand', 13, 1, '2021-07-02 13:52:07');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (13, 'West Bengal', 12, 1, '2025-06-05 14:22:18');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (14, 'Rajasthan', 0, 1, '2025-06-05 14:34:18');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (15, 'Uttarakhand', 0, 1, '2025-06-05 14:35:01');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (16, 'Sikkim', 0, 1, '2025-06-05 14:35:28');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (17, 'Gujarat', 0, 1, '2025-06-05 14:36:01');
INSERT INTO `tbl_state` (`id`, `state`, `code`, `status`, `addon`) VALUES (18, 'Assam', 0, 1, '2025-06-05 14:36:30');


#
# TABLE STRUCTURE FOR: tbl_subscriber
#

DROP TABLE IF EXISTS `tbl_subscriber`;

CREATE TABLE `tbl_subscriber` (
  `subs_id` int NOT NULL AUTO_INCREMENT,
  `subs_email` varchar(255) NOT NULL,
  `subs_date` varchar(100) NOT NULL,
  `subs_date_time` varchar(100) NOT NULL,
  `subs_hash` varchar(255) NOT NULL,
  `subs_active` int NOT NULL,
  PRIMARY KEY (`subs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_testimonial
#

DROP TABLE IF EXISTS `tbl_testimonial`;

CREATE TABLE `tbl_testimonial` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_top_category
#

DROP TABLE IF EXISTS `tbl_top_category`;

CREATE TABLE `tbl_top_category` (
  `tcat_id` int NOT NULL AUTO_INCREMENT,
  `tcat_pic` varchar(111) NOT NULL,
  `tcat_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `status` int NOT NULL,
  `status_home` int NOT NULL,
  PRIMARY KEY (`tcat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_top_category` (`tcat_id`, `tcat_pic`, `tcat_name`, `status`, `status_home`) VALUES (1, '', 'Super Store', 1, 1);


#
# TABLE STRUCTURE FOR: tbl_top_cities
#

DROP TABLE IF EXISTS `tbl_top_cities`;

CREATE TABLE `tbl_top_cities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tbl_top_cities` (`id`, `name`, `addon`, `status`) VALUES (1, 'Muzaffarpur', '0000-00-00 00:00:00', 1);


#
# TABLE STRUCTURE FOR: tbl_user
#

DROP TABLE IF EXISTS `tbl_user`;

CREATE TABLE `tbl_user` (
  `id` int NOT NULL AUTO_INCREMENT,
  `full_name` varchar(100) DEFAULT NULL,
  `fname` varchar(999) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `address` varchar(999) NOT NULL,
  `role` varchar(30) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `vender` int NOT NULL,
  `aadhar` varchar(110) DEFAULT NULL,
  `pan` varchar(110) DEFAULT NULL,
  `dob` varchar(999) NOT NULL,
  `gst` varchar(110) DEFAULT NULL,
  `aletter` varchar(110) DEFAULT NULL,
  `acc` varchar(110) DEFAULT NULL,
  `acc_name` varchar(11) DEFAULT NULL,
  `ifsc` varchar(110) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `passwords` varchar(999) DEFAULT NULL,
  `a` int NOT NULL,
  `b` int NOT NULL,
  `c` int NOT NULL,
  `d` int NOT NULL,
  `e` int NOT NULL,
  `f` int NOT NULL,
  `g` int NOT NULL,
  `h` int NOT NULL,
  `i` int NOT NULL,
  `j` int NOT NULL,
  `k` int NOT NULL,
  `l` int NOT NULL,
  `m` int NOT NULL,
  `n` int NOT NULL,
  `o` int NOT NULL,
  `p` int NOT NULL,
  `q` int NOT NULL,
  `r` int NOT NULL,
  `s` int NOT NULL,
  `t` int NOT NULL,
  `u` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_user` (`id`, `full_name`, `fname`, `email`, `phone`, `password`, `photo`, `address`, `role`, `status`, `vender`, `aadhar`, `pan`, `dob`, `gst`, `aletter`, `acc`, `acc_name`, `ifsc`, `date`, `passwords`, `a`, `b`, `c`, `d`, `e`, `f`, `g`, `h`, `i`, `j`, `k`, `l`, `m`, `n`, `o`, `p`, `q`, `r`, `s`, `t`, `u`) VALUES (1, 'Enexa IT Solutions', '', 'admin@admin.com', '+91 1234567890', '827ccb0eea8a706c4c34a16891f84e7b', 'User-1.jpeg', '', 'Admin', 'Active', 1, '', '', '', '', '', '', '', '', '2019-02-27 14:04:08', '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0);
INSERT INTO `tbl_user` (`id`, `full_name`, `fname`, `email`, `phone`, `password`, `photo`, `address`, `role`, `status`, `vender`, `aadhar`, `pan`, `dob`, `gst`, `aletter`, `acc`, `acc_name`, `ifsc`, `date`, `passwords`, `a`, `b`, `c`, `d`, `e`, `f`, `g`, `h`, `i`, `j`, `k`, `l`, `m`, `n`, `o`, `p`, `q`, `r`, `s`, `t`, `u`) VALUES (20, 'Test', 'Test1', 'test@gmail.com', '9876543210', 'e10adc3949ba59abbe56e057f20f883e', 'user.png', '', 'Staff', 'Active', 0, '', '', '', '', NULL, '', '', '', '2025-09-12 13:48:33', '123456', 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);


#
# TABLE STRUCTURE FOR: tbl_video
#

DROP TABLE IF EXISTS `tbl_video`;

CREATE TABLE `tbl_video` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `iframe_code` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tree
#

DROP TABLE IF EXISTS `tree`;

CREATE TABLE `tree` (
  `id` int NOT NULL AUTO_INCREMENT,
  `plan` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uid` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `root` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: vendor
#

DROP TABLE IF EXISTS `vendor`;

CREATE TABLE `vendor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sponsor` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `cname` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `shopid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phone` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pass` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pass2` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `address` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `lanmark` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `deal` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `discount` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dis` varchar(99) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `account` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ifsc` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `photo` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sponsor_com` varchar(99) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qrcode` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: vendor_passbook
#

DROP TABLE IF EXISTS `vendor_passbook`;

CREATE TABLE `vendor_passbook` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `uid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `txnid` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tamt` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dis` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `amt` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `balance` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `remark` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `status1` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `addon` varchar(999) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: win_lottry
#

DROP TABLE IF EXISTS `win_lottry`;

CREATE TABLE `win_lottry` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lottry_no` varchar(999) DEFAULT NULL,
  `lgroup` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

